/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.border;

import java.util.Locale;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.IComponentBorder;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Response;
import org.apache.wicket.Session;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.ContainerInfo;
import org.apache.wicket.markup.Markup;
import org.apache.wicket.markup.MarkupElement;
import org.apache.wicket.markup.MarkupResourceStream;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.WicketTag;
import org.apache.wicket.markup.parser.filter.WicketTagIdentifier;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.locator.IResourceStreamLocator;

public class MarkupComponentBorder
implements IComponentBorder {
    private static final long serialVersionUID = 1L;
    private transient MarkupStream markupStream;
    static /* synthetic */ Class class$org$apache$wicket$markup$html$border$MarkupComponentBorder;

    public void renderBefore(Component component) {
        MarkupStream stream = this.getMarkupStream(component);
        Response response = component.getResponse();
        stream.setCurrentIndex(0);
        boolean insideBorderMarkup = false;
        while (stream.hasMore()) {
            MarkupElement e = stream.get();
            stream.next();
            if (e instanceof WicketTag) {
                WicketTag wt = (WicketTag)e;
                if (!insideBorderMarkup) {
                    if (wt.isBorderTag() && wt.isOpen()) {
                        insideBorderMarkup = true;
                        continue;
                    }
                    throw new WicketRuntimeException("Unexpected tag encountered in markup of component border " + this.getClass().getName() + ". Tag: " + wt.toString() + ", expected tag: <wicket:border>");
                }
                if (wt.isBodyTag()) break;
                throw new WicketRuntimeException("Unexpected tag encountered in markup of component border " + this.getClass().getName() + ". Tag: " + wt.toString() + ", expected tag: <wicket:body> or </wicket:body>");
            }
            if (!insideBorderMarkup) continue;
            response.write(e.toCharSequence());
        }
        if (!stream.hasMore()) {
            throw new WicketRuntimeException("Markup for component border " + this.getClass().getName() + " ended prematurely, was expecting </wicket:border>");
        }
    }

    public void renderAfter(Component component) {
        MarkupStream stream = this.getMarkupStream(component);
        Response response = component.getResponse();
        while (stream.hasMore()) {
            MarkupElement e = stream.get();
            stream.next();
            if (e instanceof WicketTag) {
                WicketTag wt = (WicketTag)e;
                if (wt.isBorderTag() && wt.isClose()) break;
                throw new WicketRuntimeException("Unexpected tag encountered in markup of component border " + this.getClass().getName() + ". Tag: " + wt.toString() + ", expected tag: </wicket:border>");
            }
            response.write(e.toCharSequence());
        }
    }

    private MarkupStream getMarkupStream(Component component) {
        if (this.markupStream == null) {
            this.markupStream = this.findMarkupStream(component);
        }
        return this.markupStream;
    }

    private MarkupStream findMarkupStream(Component owner) {
        String markupType = this.getMarkupType(owner);
        IResourceStreamLocator locator = Application.get().getResourceSettings().getResourceStreamLocator();
        Session session = Session.get();
        String style = session.getStyle();
        Locale locale = session.getLocale();
        MarkupResourceStream markupResourceStream = null;
        Class<?> containerClass = this.getClass();
        while (!containerClass.equals(class$org$apache$wicket$markup$html$border$MarkupComponentBorder == null ? MarkupComponentBorder.class$("org.apache.wicket.markup.html.border.MarkupComponentBorder") : class$org$apache$wicket$markup$html$border$MarkupComponentBorder)) {
            String path = containerClass.getName().replace('.', '/');
            IResourceStream resourceStream = locator.locate(containerClass, path, style, locale, markupType);
            if (resourceStream != null) {
                ContainerInfo ci = new ContainerInfo(containerClass, locale, style, null, markupType);
                markupResourceStream = new MarkupResourceStream(resourceStream, ci, containerClass);
                break;
            }
            containerClass = containerClass.getSuperclass();
        }
        if (markupResourceStream == null) {
            throw new WicketRuntimeException("Could not find markup for component border `" + this.getClass().getName() + "`");
        }
        try {
            Markup markup = Application.get().getMarkupSettings().getMarkupParserFactory().newMarkupParser(markupResourceStream).parse();
            return new MarkupStream(markup);
        }
        catch (Exception e) {
            throw new WicketRuntimeException("Could not parse markup from markup resource stream: " + markupResourceStream.toString());
        }
    }

    private String getMarkupType(Component component) {
        String extension = component instanceof MarkupContainer ? ((MarkupContainer)component).getMarkupType() : component.getParent().getMarkupType();
        return extension;
    }

    static {
        WicketTagIdentifier.registerWellKnownTagName("border");
        WicketTagIdentifier.registerWellKnownTagName("body");
    }
}

