/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form.validation;

import java.util.HashMap;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.validation.IFormValidator;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.lang.Classes;
import org.apache.wicket.validation.ValidationError;

public abstract class AbstractFormValidator
implements IFormValidator {
    private static final long serialVersionUID = 1L;

    protected final Map messageModel() {
        throw new UnsupportedOperationException("THIS METHOD IS DEPRECATED, SEE JAVADOC");
    }

    public void error(FormComponent fc) {
        this.error(fc, this.resourceKey(), this.variablesMap());
    }

    public void error(FormComponent fc, String resourceKey) {
        if (resourceKey == null) {
            throw new IllegalArgumentException("Argument [[resourceKey]] cannot be null");
        }
        this.error(fc, resourceKey, this.variablesMap());
    }

    public void error(FormComponent fc, Map vars) {
        if (vars == null) {
            throw new IllegalArgumentException("Argument [[vars]] cannot be null");
        }
        this.error(fc, this.resourceKey(), vars);
    }

    public void error(FormComponent fc, String resourceKey, Map vars) {
        if (fc == null) {
            throw new IllegalArgumentException("Argument [[fc]] cannot be null");
        }
        if (vars == null) {
            throw new IllegalArgumentException("Argument [[vars]] cannot be null");
        }
        if (resourceKey == null) {
            throw new IllegalArgumentException("Argument [[resourceKey]] cannot be null");
        }
        ValidationError error = new ValidationError().addMessageKey(resourceKey);
        String defaultKey = Classes.simpleName(this.getClass());
        if (!resourceKey.equals(defaultKey)) {
            error.addMessageKey(defaultKey);
        }
        error.setVariables(vars);
        fc.error(error);
    }

    protected Map variablesMap() {
        FormComponent[] formComponents = this.getDependentFormComponents();
        if (formComponents != null && formComponents.length > 0) {
            HashMap<String, Object> args = new HashMap<String, Object>(formComponents.length * 3);
            for (int i = 0; i < formComponents.length; ++i) {
                FormComponent formComponent = formComponents[i];
                String arg = "label" + i;
                IModel label = formComponent.getLabel();
                if (label != null) {
                    args.put(arg, label.getObject());
                } else {
                    args.put(arg, formComponent.getLocalizer().getString(formComponent.getId(), (Component)formComponent.getParent(), formComponent.getId()));
                }
                args.put("input" + i, formComponent.getInput());
                args.put("name" + i, formComponent.getId());
            }
            return args;
        }
        return new HashMap(2);
    }

    protected String resourceKey() {
        return Classes.simpleName(this.getClass());
    }
}

