/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.image.resource;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.HashMap;
import java.util.Map;
import org.apache.wicket.markup.html.image.resource.RenderedDynamicImageResource;

public class DefaultButtonImageResource
extends RenderedDynamicImageResource {
    private static final long serialVersionUID = 1L;
    private static int defaultHeight = 26;
    private static int defaultWidth = 74;
    private static final int DEFAULT_COLOR = new Color(233, 96, 26).getRGB();
    private static final int DEFAULT_BACKGROUND_COLOR = Color.WHITE.getRGB();
    private static final int DEFAULT_TEXT_COLOR = Color.WHITE.getRGB();
    private static final Map DEFAULT_FONT = new HashMap(new Font("Helvetica", 1, 16).getAttributes());
    private int arcHeight = 10;
    private int arcWidth = 10;
    private int backgroundColorRgb = DEFAULT_BACKGROUND_COLOR;
    private int colorRgb = DEFAULT_COLOR;
    private Map fontAttributes = DEFAULT_FONT;
    private int textColorRgb = DEFAULT_TEXT_COLOR;
    private final String label;

    public static void setDefaultHeight(int defaultHeight) {
        DefaultButtonImageResource.defaultHeight = defaultHeight;
    }

    public static void setDefaultWidth(int defaultWidth) {
        DefaultButtonImageResource.defaultWidth = defaultWidth;
    }

    public DefaultButtonImageResource(int width, int height, String label) {
        super(width, height, "png");
        this.label = label;
        this.setWidth(width == -1 ? defaultWidth : width);
        this.setHeight(height == -1 ? defaultHeight : height);
    }

    public DefaultButtonImageResource(String label) {
        this(defaultWidth, defaultHeight, label);
    }

    public synchronized int getArcHeight() {
        return this.arcHeight;
    }

    public synchronized int getArcWidth() {
        return this.arcWidth;
    }

    public synchronized Color getBackgroundColor() {
        return new Color(this.backgroundColorRgb);
    }

    public synchronized Color getColor() {
        return new Color(this.colorRgb);
    }

    public synchronized Font getFont() {
        return new Font(this.fontAttributes);
    }

    public synchronized Color getTextColor() {
        return new Color(this.textColorRgb);
    }

    public synchronized void setArcHeight(int arcHeight) {
        this.arcHeight = arcHeight;
        this.invalidate();
    }

    public synchronized void setArcWidth(int arcWidth) {
        this.arcWidth = arcWidth;
        this.invalidate();
    }

    public synchronized void setBackgroundColor(Color backgroundColor) {
        this.backgroundColorRgb = backgroundColor.getRGB();
        this.invalidate();
    }

    public synchronized void setColor(Color color) {
        this.colorRgb = color.getRGB();
        this.invalidate();
    }

    public synchronized void setFont(Font font) {
        this.fontAttributes = new HashMap(font.getAttributes());
        this.invalidate();
    }

    public synchronized void setTextColor(Color textColor) {
        this.textColorRgb = textColor.getRGB();
        this.invalidate();
    }

    protected boolean render(Graphics2D graphics) {
        int width = this.getWidth();
        int height = this.getHeight();
        graphics.setFont(this.getFont());
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int dxText = fontMetrics.stringWidth(this.label);
        int dxMargin = 10;
        if (dxText > width - 10) {
            this.setWidth(dxText + 10);
            return false;
        }
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color bgColor = this.getBackgroundColor();
        graphics.setColor(bgColor);
        graphics.fillRect(0, 0, width, height);
        graphics.setColor(this.getColor());
        graphics.setBackground(bgColor);
        graphics.fillRoundRect(0, 0, width, height, this.arcWidth, this.arcHeight);
        graphics.setColor(this.getTextColor());
        int x = (width - dxText) / 2;
        int y = (this.getHeight() - fontMetrics.getHeight()) / 2;
        graphics.drawString(this.label, x, y + fontMetrics.getAscent());
        return true;
    }
}

