/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.parser.filter;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupElement;
import org.apache.wicket.markup.MarkupResourceData;
import org.apache.wicket.markup.WicketTag;
import org.apache.wicket.markup.parser.AbstractMarkupFilter;
import org.apache.wicket.markup.parser.XmlTag;

public final class WicketTagIdentifier
extends AbstractMarkupFilter {
    private static List wellKnownTagNames;
    private final MarkupResourceData markup;

    public WicketTagIdentifier(MarkupResourceData markup) {
        this.markup = markup;
    }

    public MarkupElement nextTag() throws ParseException {
        String value;
        ComponentTag tag;
        XmlTag xmlTag = (XmlTag)this.getParent().nextTag();
        if (xmlTag == null) {
            return xmlTag;
        }
        String namespace = this.markup.getWicketNamespace();
        if (namespace.equalsIgnoreCase(xmlTag.getNamespace())) {
            tag = new WicketTag(xmlTag);
            tag.setId("_" + tag.getName());
            tag.setAutoComponentTag(true);
            tag.setModified(true);
            if (!this.isWellKnown(xmlTag)) {
                throw new ParseException("Unknown tag name with Wicket namespace: '" + xmlTag.getName() + "'. Might be you haven't installed the appropriate resolver?", tag.getPos());
            }
        } else {
            tag = new ComponentTag(xmlTag);
        }
        if ((value = tag.getAttributes().getString(namespace + ":id")) != null) {
            if (value.trim().length() == 0) {
                throw new ParseException("The wicket:id attribute value must not be empty. May be unmatched quotes?!?", tag.getPos());
            }
            tag.setId(value);
        }
        return tag;
    }

    public static final void registerWellKnownTagName(String name) {
        if (wellKnownTagNames == null) {
            wellKnownTagNames = new ArrayList();
        }
        if (!wellKnownTagNames.contains(name)) {
            wellKnownTagNames.add(name);
        }
    }

    private boolean isWellKnown(XmlTag xmlTag) {
        Iterator iterator = wellKnownTagNames.iterator();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            if (!xmlTag.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }
}

