/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.IPageMap;
import org.apache.wicket.IRedirectListener;
import org.apache.wicket.IResourceListener;
import org.apache.wicket.Page;
import org.apache.wicket.RequestListenerInterface;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.IFormSubmitListener;
import org.apache.wicket.markup.html.form.IOnChangeListener;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.link.ILinkListener;
import org.apache.wicket.protocol.http.MockHttpSession;
import org.apache.wicket.protocol.http.RequestUtils;
import org.apache.wicket.protocol.http.WicketURLEncoder;
import org.apache.wicket.util.file.File;
import org.apache.wicket.util.io.IOUtils;
import org.apache.wicket.util.lang.Classes;
import org.apache.wicket.util.value.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockHttpServletRequest
implements HttpServletRequest {
    private static final Logger log = LoggerFactory.getLogger((Class)MockHttpServletRequest.class);
    private final Application application;
    private final ValueMap attributes = new ValueMap();
    private String authType;
    private String characterEncoding;
    private final ServletContext context;
    private final List cookies = new ArrayList();
    private final ValueMap headers = new ValueMap();
    private String method;
    private final ValueMap parameters = new ValueMap();
    private String path;
    private final HttpSession session;
    private String url;
    private Map uploadedFiles;
    private boolean useMultiPartContentType;
    private static final String crlf = "\r\n";
    private static final String boundary = "--abcdefgABCDEFG";

    public MockHttpServletRequest(Application application, HttpSession session, ServletContext context) {
        this.application = application;
        this.session = session;
        this.context = context;
        this.initialize();
    }

    public void addCookie(Cookie cookie) {
        this.cookies.add(cookie);
    }

    public void addFile(String fieldName, File file, String contentType) {
        if (file == null) {
            throw new IllegalArgumentException("File must not be null");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("File does not exists. You must provide an existing file: " + file.getAbsolutePath());
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException("You can only add a File, which is not a directory. Only files can be uploaded.");
        }
        if (this.uploadedFiles == null) {
            this.uploadedFiles = new HashMap();
        }
        UploadedFile uf = new UploadedFile(fieldName, file, contentType);
        this.uploadedFiles.put(fieldName, uf);
    }

    public void addHeader(String name, String value) {
        ArrayList<String> list = (ArrayList<String>)this.headers.get(name);
        if (list == null) {
            list = new ArrayList<String>(1);
            this.headers.put(name, list);
        }
        list.add(value);
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration getAttributeNames() {
        return Collections.enumeration(this.attributes.keySet());
    }

    public String getAuthType() {
        return this.authType;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setUseMultiPartContentType(boolean useMultiPartContentType) {
        this.useMultiPartContentType = useMultiPartContentType;
    }

    public int getContentLength() {
        if (this.useMultiPartContentType) {
            byte[] request = this.buildRequest();
            return request.length;
        }
        return -1;
    }

    public String getContentType() {
        if (this.useMultiPartContentType) {
            return "multipart/form-data; boundary=abcdefgABCDEFG";
        }
        return null;
    }

    public String getContextPath() {
        return "/" + this.application.getName();
    }

    public Cookie[] getCookies() {
        if (this.cookies.size() == 0) {
            return null;
        }
        Cookie[] result = new Cookie[this.cookies.size()];
        return this.cookies.toArray(result);
    }

    public long getDateHeader(String name) throws IllegalArgumentException {
        String value = this.getHeader(name);
        if (value == null) {
            return -1L;
        }
        DateFormat df = DateFormat.getDateInstance(0);
        try {
            return df.parse(value).getTime();
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Can't convert header to date " + name + ": " + value);
        }
    }

    public String getHeader(String name) {
        List l = (List)this.headers.get(name);
        if (l == null || l.size() < 1) {
            return null;
        }
        return (String)l.get(0);
    }

    public Enumeration getHeaderNames() {
        return Collections.enumeration(this.headers.keySet());
    }

    public Enumeration getHeaders(String name) {
        ArrayList list = (ArrayList)this.headers.get(name);
        if (list == null) {
            list = new ArrayList();
        }
        return Collections.enumeration(list);
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.uploadedFiles != null && this.uploadedFiles.size() > 0) {
            byte[] request = this.buildRequest();
            final ByteArrayInputStream bais = new ByteArrayInputStream(request);
            return new ServletInputStream(){

                public int read() {
                    return bais.read();
                }
            };
        }
        return new ServletInputStream(){

            public int read() {
                return -1;
            }
        };
    }

    public int getIntHeader(String name) {
        String value = this.getHeader(name);
        if (value == null) {
            return -1;
        }
        return Integer.valueOf(value);
    }

    public Locale getLocale() {
        String header = this.getHeader("Accept-Language");
        if (header == null) {
            return Locale.getDefault();
        }
        String[] firstLocale = header.split(",");
        if (firstLocale.length < 1) {
            return Locale.getDefault();
        }
        String[] bits = firstLocale[0].split("-");
        if (bits.length < 1) {
            return Locale.getDefault();
        }
        String language = bits[0].toLowerCase();
        if (bits.length > 1) {
            String country = bits[1].toUpperCase();
            return new Locale(language, country);
        }
        return new Locale(language);
    }

    public Enumeration getLocales() {
        ArrayList<Locale> list = new ArrayList<Locale>(1);
        list.add(this.getLocale());
        return Collections.enumeration(list);
    }

    public String getMethod() {
        return this.method;
    }

    public String getParameter(String name) {
        return this.parameters.getString(name);
    }

    public Map getParameterMap() {
        return this.parameters;
    }

    public Enumeration getParameterNames() {
        return Collections.enumeration(this.parameters.keySet());
    }

    public String[] getParameterValues(String name) {
        Object value = this.parameters.get(name);
        if (value == null) {
            return new String[0];
        }
        if (value instanceof String[]) {
            return (String[])value;
        }
        String[] result = new String[]{value.toString()};
        return result;
    }

    public String getPathInfo() {
        return this.path;
    }

    public String getPathTranslated() {
        return null;
    }

    public String getProtocol() {
        return "HTTP/1.1";
    }

    public String getQueryString() {
        if (this.parameters.size() == 0) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        Iterator iterator = this.parameters.keySet().iterator();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            String value = this.parameters.getString(name);
            if (name != null) {
                buf.append(WicketURLEncoder.QUERY_INSTANCE.encode(name));
            }
            buf.append('=');
            if (value != null) {
                buf.append(WicketURLEncoder.QUERY_INSTANCE.encode(value));
            }
            if (!iterator.hasNext()) continue;
            buf.append('&');
        }
        return buf.toString();
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new CharArrayReader(new char[0]));
    }

    public String getRealPath(String name) {
        return this.context.getRealPath(name);
    }

    public String getRemoteAddr() {
        return "127.0.0.1";
    }

    public String getRemoteHost() {
        return "localhost";
    }

    public String getRemoteUser() {
        return this.getHeader("REMOTE_USER");
    }

    public RequestDispatcher getRequestDispatcher(String name) {
        return this.context.getRequestDispatcher(name);
    }

    public String getRequestedSessionId() {
        if (this.session instanceof MockHttpSession && ((MockHttpSession)this.session).isTemporary()) {
            return null;
        }
        return this.session.getId();
    }

    public String getRequestURI() {
        if (this.url == null) {
            return this.getContextPath() + this.getServletPath();
        }
        return this.url;
    }

    public StringBuffer getRequestURL() {
        String query;
        StringBuffer buf = new StringBuffer();
        buf.append("http://localhost");
        buf.append(this.getContextPath());
        if (this.getPathInfo() != null) {
            buf.append(this.getPathInfo());
        }
        if ((query = this.getQueryString()) != null) {
            buf.append('?');
            buf.append(query);
        }
        return buf;
    }

    public String getScheme() {
        return "http";
    }

    public String getServerName() {
        return "localhost";
    }

    public int getServerPort() {
        return 80;
    }

    public String getServletPath() {
        return this.getContextPath();
    }

    public HttpSession getSession() {
        if (this.session instanceof MockHttpSession && ((MockHttpSession)this.session).isTemporary()) {
            return null;
        }
        return this.session;
    }

    public HttpSession getSession(boolean b) {
        if (b && this.session instanceof MockHttpSession) {
            ((MockHttpSession)this.session).setTemporary(false);
        }
        return this.getSession();
    }

    public Principal getUserPrincipal() {
        final String user = this.getRemoteUser();
        if (user == null) {
            return null;
        }
        return new Principal(){

            public String getName() {
                return user;
            }
        };
    }

    public boolean hasUploadedFiles() {
        return this.uploadedFiles != null;
    }

    public void initialize() {
        this.authType = null;
        this.method = "post";
        this.cookies.clear();
        this.setDefaultHeaders();
        this.path = null;
        this.url = null;
        this.characterEncoding = "UTF-8";
        this.parameters.clear();
        this.attributes.clear();
    }

    public boolean isRequestedSessionIdFromCookie() {
        return true;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return false;
    }

    public boolean isRequestedSessionIdFromURL() {
        return false;
    }

    public boolean isRequestedSessionIdValid() {
        return true;
    }

    public boolean isSecure() {
        return false;
    }

    public boolean isUserInRole(String name) {
        return false;
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public void setAttribute(String name, Object o) {
        this.attributes.put(name, o);
    }

    public void setAuthType(String authType) {
        this.authType = authType;
    }

    public void setCharacterEncoding(String encoding) throws UnsupportedEncodingException {
        this.characterEncoding = encoding;
    }

    public void setCookies(Cookie[] theCookies) {
        this.cookies.clear();
        for (int i = 0; i < theCookies.length; ++i) {
            this.cookies.add(theCookies[i]);
        }
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setParameter(String name, String value) {
        this.parameters.put(name, value);
    }

    public void setParameters(Map parameters) {
        this.parameters.putAll(parameters);
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setURL(String url) {
        int index;
        if (url.startsWith("http://")) {
            index = url.indexOf("/", 7);
            url = url.substring(index);
        }
        this.url = url;
        if (url.startsWith(this.getContextPath())) {
            url = url.substring(this.getContextPath().length());
        }
        if (url.startsWith(this.getServletPath())) {
            url = url.substring(this.getServletPath().length());
        }
        if ((index = url.indexOf("?")) == -1) {
            this.path = url;
        } else {
            this.path = url.substring(0, index);
            String queryString = url.substring(index + 1);
            RequestUtils.decodeParameters(queryString, this.parameters);
        }
    }

    public void setRequestToBookmarkablePage(Page page, Map params) {
        this.parameters.putAll(params);
        this.parameters.put("wicket:bookmarkablePage", page.getClass().getName());
    }

    public void setRequestToComponent(Component component) {
        String pageMapName;
        IPageMap pageMap = component.getPage().getPageMap();
        String string = pageMapName = pageMap.isDefault() ? "" : pageMap.getName();
        if (component instanceof BookmarkablePageLink) {
            Class clazz = ((BookmarkablePageLink)component).getPageClass();
            this.parameters.put("wicket:bookmarkablePage", pageMapName + ':' + clazz.getName());
        } else {
            int version = component.getPage().getCurrentVersionNumber();
            Class clazz = null;
            if (component instanceof IRedirectListener) {
                clazz = IRedirectListener.class;
            } else if (component instanceof IResourceListener) {
                clazz = IResourceListener.class;
            } else if (component instanceof IFormSubmitListener) {
                clazz = IFormSubmitListener.class;
            } else if (component instanceof ILinkListener) {
                clazz = ILinkListener.class;
            } else if (component instanceof IOnChangeListener) {
                clazz = IOnChangeListener.class;
            } else {
                throw new IllegalArgumentException("The component class doesn't seem to implement any of the known *Listener interfaces: " + component.getClass());
            }
            this.parameters.put("wicket:interface", pageMapName + ':' + component.getPath() + ':' + (version == 0 ? "" : "" + version) + ':' + Classes.simpleName(clazz) + "::");
            try {
                RequestListenerInterface rli = (RequestListenerInterface)clazz.getField("INTERFACE").get(clazz);
                String auto = ((Object)component.getRequestCycle().urlFor(component, rli)).toString();
                int idx = auto.indexOf("wicket:interface");
                if (idx >= 0) {
                    auto = auto.substring(idx + "wicket:interface".length() + 1);
                } else {
                    idx = auto.indexOf("x=6*");
                    if (idx >= 0) {
                        auto = auto.substring(idx + 4);
                    }
                }
                idx = auto.indexOf("&");
                if (idx >= 0) {
                    auto = auto.substring(0, idx);
                }
                this.parameters.put("wicket:interface", auto);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (component.isStateless() && component.getPage().isBookmarkable()) {
                this.parameters.put("wicket:bookmarkablePage", pageMapName + ':' + component.getPage().getClass().getName());
            }
        }
    }

    public void setRequestToFormComponent(Form form, final Map values) {
        this.setRequestToComponent(form);
        final HashMap valuesApplied = new HashMap();
        form.visitChildren(new Component.IVisitor(){

            public Object component(Component component) {
                String value;
                if (component instanceof FormComponent && (value = (String)values.get(component)) != null) {
                    MockHttpServletRequest.this.parameters.put(((FormComponent)component).getInputName(), values.get(component));
                    valuesApplied.put(component.getId(), component);
                }
                return CONTINUE_TRAVERSAL;
            }
        });
        if (values.size() != valuesApplied.size()) {
            HashMap diff = new HashMap();
            diff.putAll(values);
            Iterator iter = valuesApplied.keySet().iterator();
            while (iter.hasNext()) {
                diff.remove(iter.next());
            }
            log.error("Parameter mismatch: didn't find all components referenced in parameter 'values': " + diff.keySet());
        }
    }

    public void setRequestToRedirectString(String redirect) {
        this.parameters.clear();
        int queryStringPos = redirect.indexOf(63);
        if (queryStringPos != -1) {
            String queryString = redirect.substring(queryStringPos + 1);
            RequestUtils.decodeParameters(queryString, this.parameters);
        }
        this.url = this.getContextPath() + this.getServletPath() + "/" + redirect;
        this.url = RequestUtils.removeDoubleDots(this.url);
        log.info("Redirecting to " + this.url);
    }

    private void setDefaultHeaders() {
        this.headers.clear();
        this.addHeader("Accept", "text/xml,application/xml,application/xhtml+xml,text/html;q=0.9,text/plain;q=0.8,image/png,*/*;q=0.5");
        this.addHeader("Accept-Charset", "ISO-8859-1,utf-8;q=0.7,*;q=0.7");
        Locale l = Locale.getDefault();
        this.addHeader("Accept-Language", l.getLanguage().toLowerCase() + "-" + l.getCountry().toLowerCase() + "," + l.getLanguage().toLowerCase() + ";q=0.5");
        this.addHeader("User-Agent", "Mozilla/5.0 (Windows; U; Windows NT 5.0; en-US; rv:1.7) Gecko/20040707 Firefox/0.9.2");
    }

    private void newAttachment(OutputStream out) throws IOException {
        out.write(boundary.getBytes());
        out.write(crlf.getBytes());
        out.write("Content-Disposition: form-data".getBytes());
    }

    private byte[] buildRequest() {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Iterator iterator = this.parameters.keySet().iterator();
            while (iterator.hasNext()) {
                String name = (String)iterator.next();
                this.newAttachment(out);
                out.write("; name=\"".getBytes());
                out.write(name.getBytes());
                out.write("\"".getBytes());
                out.write(crlf.getBytes());
                out.write(crlf.getBytes());
                out.write(this.parameters.get(name).toString().getBytes());
                out.write(crlf.getBytes());
            }
            if (this.uploadedFiles != null) {
                iterator = this.uploadedFiles.keySet().iterator();
                while (iterator.hasNext()) {
                    String fieldName = (String)iterator.next();
                    UploadedFile uf = (UploadedFile)this.uploadedFiles.get(fieldName);
                    this.newAttachment(out);
                    out.write("; name=\"".getBytes());
                    out.write(fieldName.getBytes());
                    out.write("\"; filename=\"".getBytes());
                    out.write(uf.getFile().getName().getBytes());
                    out.write("\"".getBytes());
                    out.write(crlf.getBytes());
                    out.write("Content-Type: ".getBytes());
                    out.write(uf.getContentType().getBytes());
                    out.write(crlf.getBytes());
                    out.write(crlf.getBytes());
                    FileInputStream fis = new FileInputStream(uf.getFile());
                    IOUtils.copy((InputStream)fis, (OutputStream)out);
                    fis.close();
                    out.write(crlf.getBytes());
                }
            }
            out.write(boundary.getBytes());
            out.write("--".getBytes());
            out.write(crlf.getBytes());
            return out.toByteArray();
        }
        catch (IOException e) {
            throw new WicketRuntimeException(e);
        }
    }

    public String getLocalAddr() {
        return "127.0.0.1";
    }

    public String getLocalName() {
        return "127.0.0.1";
    }

    public int getLocalPort() {
        return 80;
    }

    public int getRemotePort() {
        return 80;
    }

    private class UploadedFile {
        private String fieldName;
        private File file;
        private String contentType;

        public UploadedFile(String fieldName, File file, String contentType) {
            this.fieldName = fieldName;
            this.file = file;
            this.contentType = contentType;
        }

        public String getContentType() {
            return this.contentType;
        }

        public void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public File getFile() {
            return this.file;
        }

        public void setFile(File file) {
            this.file = file;
        }
    }
}

