/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http;

import java.io.UnsupportedEncodingException;
import org.apache.wicket.Application;
import org.apache.wicket.WicketRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WicketURLDecoder {
    private static final Logger log = LoggerFactory.getLogger((Class)Application.class);
    private boolean decodePlus;
    public static final WicketURLDecoder QUERY_INSTANCE = new WicketURLDecoder(true);
    public static final WicketURLDecoder PATH_INSTANCE = new WicketURLDecoder(false);

    private WicketURLDecoder(boolean decodePlus) {
        this.decodePlus = decodePlus;
    }

    public String decode(String s) {
        Application app = null;
        try {
            app = Application.get();
        }
        catch (WicketRuntimeException ignored) {
            log.warn("No current Application found - defaulting encoding to UTF-8");
        }
        return this.decode(s, app == null ? "UTF-8" : app.getRequestCycleSettings().getResponseRequestEncoding());
    }

    public String decode(String s, String enc) {
        boolean needToChange = false;
        int numChars = s.length();
        StringBuffer sb = new StringBuffer(numChars > 500 ? numChars / 2 : numChars);
        int i = 0;
        if (enc.length() == 0) {
            throw new WicketRuntimeException(new UnsupportedEncodingException("URLDecoder: empty string enc parameter"));
        }
        byte[] bytes = null;
        block8: while (i < numChars) {
            char c = s.charAt(i);
            switch (c) {
                case '+': {
                    sb.append(this.decodePlus ? (char)' ' : '+');
                    ++i;
                    needToChange = true;
                    continue block8;
                }
                case '%': {
                    try {
                        if (bytes == null) {
                            bytes = new byte[(numChars - i) / 3];
                        }
                        int pos = 0;
                        while (i + 2 < numChars && c == '%') {
                            bytes[pos++] = (byte)Integer.parseInt(s.substring(i + 1, i + 3), 16);
                            if ((i += 3) >= numChars) continue;
                            c = s.charAt(i);
                        }
                        if (i < numChars && c == '%') {
                            throw new IllegalArgumentException("URLDecoder: Incomplete trailing escape (%) pattern");
                        }
                        try {
                            sb.append(new String(bytes, 0, pos, enc));
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new WicketRuntimeException(e);
                        }
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("URLDecoder: Illegal hex characters in escape (%) pattern - " + e.getMessage());
                    }
                    needToChange = true;
                    continue block8;
                }
            }
            sb.append(c);
            ++i;
        }
        return needToChange ? sb.toString() : s;
    }
}

