/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http.portlet;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;

public class PortletServletRequestWrapper
extends HttpServletRequestWrapper {
    private String contextPath;
    private String servletPath;
    private String pathInfo;
    private String requestURI;
    private String queryString;
    private HttpSession session;

    private static String decodePathInfo(HttpServletRequest request, String filterPath) {
        String pathInfo = request.getRequestURI().substring(request.getContextPath().length() + filterPath.length());
        return pathInfo == null || pathInfo.length() < 2 ? null : pathInfo;
    }

    private static String makeServletPath(String filterPath) {
        return "/" + filterPath.substring(0, filterPath.length() - 1);
    }

    protected PortletServletRequestWrapper(ServletContext context, HttpSession proxiedSession, HttpServletRequest request, String filterPath) {
        super(request);
        this.session = proxiedSession;
        if (proxiedSession == null) {
            this.session = request.getSession(false);
        }
        this.servletPath = PortletServletRequestWrapper.makeServletPath(filterPath);
        this.contextPath = (String)request.getAttribute("javax.servlet.include.context_path");
        if (this.contextPath != null) {
            this.requestURI = (String)request.getAttribute("javax.servlet.include.request_uri");
            this.queryString = (String)request.getAttribute("javax.servlet.include.query_string");
        } else {
            this.contextPath = (String)request.getAttribute("javax.servlet.forward.context_path");
            if (this.contextPath != null) {
                this.requestURI = (String)request.getAttribute("javax.servlet.forward.request_uri");
                this.queryString = (String)request.getAttribute("javax.servlet.forward.query_string");
            } else {
                this.contextPath = request.getContextPath();
                this.requestURI = request.getRequestURI();
                this.queryString = request.getQueryString();
            }
        }
    }

    public PortletServletRequestWrapper(ServletContext context, HttpServletRequest request, HttpSession proxiedSession, String filterPath) {
        this(context, proxiedSession, request, filterPath);
        String pathInfo = this.requestURI.substring(this.contextPath.length() + filterPath.length());
        this.pathInfo = pathInfo == null || pathInfo.length() < 2 ? null : pathInfo;
    }

    public PortletServletRequestWrapper(ServletContext context, HttpServletRequest request, HttpSession proxiedSession, String filterPath, String pathInfo) {
        this(context, proxiedSession, request, filterPath);
        this.pathInfo = pathInfo;
        this.requestURI = this.contextPath + this.servletPath + (pathInfo != null ? pathInfo : "");
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public HttpSession getSession(boolean create) {
        return this.session != null ? this.session : super.getSession(create);
    }

    public Object getAttribute(String name) {
        if ("javax.servlet.error.request_uri".equals(name) || "javax.servlet.forward.servlet_path".equals(name)) {
            return null;
        }
        return super.getAttribute(name);
    }
}

