/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http.request;

import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.wicket.Application;
import org.apache.wicket.IRequestTarget;
import org.apache.wicket.Request;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.protocol.http.RequestUtils;
import org.apache.wicket.protocol.http.WicketURLDecoder;
import org.apache.wicket.protocol.http.WicketURLEncoder;
import org.apache.wicket.request.IRequestCodingStrategy;
import org.apache.wicket.request.RequestParameters;
import org.apache.wicket.request.target.coding.IRequestTargetUrlCodingStrategy;
import org.apache.wicket.util.crypt.ICrypt;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.value.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CryptedUrlWebRequestCodingStrategy
implements IRequestCodingStrategy {
    private static final Logger log = LoggerFactory.getLogger((Class)CryptedUrlWebRequestCodingStrategy.class);
    private final IRequestCodingStrategy defaultStrategy;

    public CryptedUrlWebRequestCodingStrategy(IRequestCodingStrategy defaultStrategy) {
        this.defaultStrategy = defaultStrategy;
    }

    public RequestParameters decode(Request request) {
        String url = request.decodeURL(request.getURL());
        String decodedQueryParams = this.decodeURL(url);
        if (decodedQueryParams != null) {
            DecodedUrlRequest fakeRequest = new DecodedUrlRequest(request, url, decodedQueryParams);
            return this.defaultStrategy.decode(fakeRequest);
        }
        return this.defaultStrategy.decode(request);
    }

    public CharSequence encode(RequestCycle requestCycle, IRequestTarget requestTarget) {
        CharSequence url = this.defaultStrategy.encode(requestCycle, requestTarget);
        url = this.encodeURL(url);
        return url;
    }

    public void mount(IRequestTargetUrlCodingStrategy urlCodingStrategy) {
        this.defaultStrategy.mount(urlCodingStrategy);
    }

    public void unmount(String path) {
        this.defaultStrategy.unmount(path);
    }

    public IRequestTargetUrlCodingStrategy urlCodingStrategyForPath(String path) {
        return this.defaultStrategy.urlCodingStrategyForPath(path);
    }

    public CharSequence pathForTarget(IRequestTarget requestTarget) {
        return this.defaultStrategy.pathForTarget(requestTarget);
    }

    public IRequestTarget targetForRequest(RequestParameters requestParameters) {
        return this.defaultStrategy.targetForRequest(requestParameters);
    }

    protected CharSequence encodeURL(CharSequence url) {
        int pos;
        ICrypt urlCrypt = Application.get().getSecuritySettings().getCryptFactory().newCrypt();
        if (urlCrypt != null && (pos = ((Object)url).toString().indexOf(63)) > -1) {
            CharSequence urlPrefix = url.subSequence(0, pos);
            String queryString = ((Object)url.subSequence(pos + 1, url.length())).toString();
            if (!queryString.startsWith("x=")) {
                queryString = ((Object)this.shortenUrl(queryString)).toString();
                String encryptedQueryString = urlCrypt.encryptUrlSafe(queryString);
                encryptedQueryString = WicketURLEncoder.QUERY_INSTANCE.encode(encryptedQueryString);
                return new AppendingStringBuffer(urlPrefix).append("?x=").append(encryptedQueryString);
            }
        }
        return url;
    }

    protected String decodeURL(String url) {
        int startIndex = url.indexOf("?x=");
        if (startIndex != -1) {
            try {
                int endIndex = url.indexOf("&", startIndex += 3);
                String secureParam = endIndex == -1 ? url.substring(startIndex) : url.substring(startIndex, endIndex);
                secureParam = WicketURLDecoder.QUERY_INSTANCE.decode(secureParam);
                ICrypt urlCrypt = Application.get().getSecuritySettings().getCryptFactory().newCrypt();
                String queryString = urlCrypt.decryptUrlSafe(secureParam);
                queryString = this.rebuildUrl(queryString);
                return queryString;
            }
            catch (Exception ex) {
                return this.onError(ex, url);
            }
        }
        return null;
    }

    protected String onError(Exception ex) {
        throw new HackAttackException("Invalid URL");
    }

    protected String onError(Exception ex, String url) {
        log.error("Invalid URL: " + url, (Throwable)ex);
        return this.onError(ex);
    }

    protected CharSequence shortenUrl(CharSequence queryString) {
        queryString = Strings.replaceAll(queryString, "wicket:behaviorId=", "1*");
        queryString = Strings.replaceAll(queryString, "wicket:interface=IRedirectListener", "2*");
        queryString = Strings.replaceAll(queryString, "wicket:interface=IFormSubmitListener", "3*");
        queryString = Strings.replaceAll(queryString, "wicket:interface=IOnChangeListener", "4*");
        queryString = Strings.replaceAll(queryString, "wicket:interface=ILinkListener", "5*");
        queryString = Strings.replaceAll(queryString, "wicket:interface=", "6*");
        queryString = Strings.replaceAll(queryString, "wicket:bookmarkablePage=", "7*");
        if (log.isDebugEnabled()) {
            Pattern words = Pattern.compile("\\w\\w\\w+");
            Matcher matcher = words.matcher(queryString);
            while (matcher.find()) {
                CharSequence word = queryString.subSequence(matcher.start(), matcher.end());
                log.debug("URL pattern NOT shortened: '" + word + "' - '" + queryString + "'");
            }
        }
        return queryString;
    }

    protected String rebuildUrl(CharSequence queryString) {
        queryString = Strings.replaceAll(queryString, "1*", "wicket:behaviorId=");
        queryString = Strings.replaceAll(queryString, "2*", "wicket:interface=IRedirectListener");
        queryString = Strings.replaceAll(queryString, "3*", "wicket:interface=IFormSubmitListener");
        queryString = Strings.replaceAll(queryString, "4*", "wicket:interface=IOnChangeListener");
        queryString = Strings.replaceAll(queryString, "5*", "wicket:interface=ILinkListener");
        queryString = Strings.replaceAll(queryString, "6*", "wicket:interface=");
        queryString = Strings.replaceAll(queryString, "7*", "wicket:bookmarkablePage=");
        return ((Object)queryString).toString();
    }

    public class HackAttackException
    extends WicketRuntimeException {
        private static final long serialVersionUID = 1L;

        public HackAttackException(String msg) {
            super(msg);
        }

        public StackTraceElement[] getStackTrace() {
            return new StackTraceElement[0];
        }

        public String toString() {
            return this.getMessage();
        }
    }

    private static class DecodedUrlRequest
    extends Request {
        private final Request request;
        private final String url;
        private final Map parameterMap;

        public DecodedUrlRequest(Request request, String url, String encodedParamReplacement) {
            this.request = request;
            this.parameterMap = this.request.getParameterMap();
            this.parameterMap.remove("x");
            String decodedParamReplacement = ((Object)Strings.replaceAll(encodedParamReplacement, "&amp;", "&")).toString();
            decodedParamReplacement = WicketURLDecoder.QUERY_INSTANCE.decode(decodedParamReplacement);
            ValueMap params = new ValueMap();
            RequestUtils.decodeParameters(decodedParamReplacement, params);
            this.parameterMap.putAll(params);
            int pos1 = url.indexOf("?x=");
            if (pos1 == -1) {
                throw new WicketRuntimeException("Programming error: we should come here");
            }
            int pos2 = url.indexOf("&");
            AppendingStringBuffer urlBuf = new AppendingStringBuffer(url.length() + encodedParamReplacement.length());
            urlBuf.append(url.subSequence(0, pos1 + 1));
            urlBuf.append(encodedParamReplacement);
            if (pos2 != -1) {
                urlBuf.append(url.substring(pos2));
            }
            this.url = urlBuf.toString();
        }

        public Locale getLocale() {
            return this.request.getLocale();
        }

        public String getParameter(String key) {
            if (key == null) {
                return null;
            }
            Object val = this.parameterMap.get(key);
            if (val == null) {
                return null;
            }
            if (val instanceof String[]) {
                String[] arrayVal = (String[])val;
                return arrayVal.length > 0 ? arrayVal[0] : null;
            }
            if (val instanceof String) {
                return (String)val;
            }
            return val.toString();
        }

        public Map getParameterMap() {
            return this.parameterMap;
        }

        public String[] getParameters(String key) {
            if (key == null) {
                return null;
            }
            Object val = this.parameterMap.get(key);
            if (val == null) {
                return null;
            }
            if (val instanceof String[]) {
                return (String[])val;
            }
            if (val instanceof String) {
                return new String[]{(String)val};
            }
            return new String[]{val.toString()};
        }

        public String getPath() {
            return this.request.getPath();
        }

        public String getRelativePathPrefixToContextRoot() {
            return this.request.getRelativePathPrefixToContextRoot();
        }

        public String getRelativePathPrefixToWicketHandler() {
            return this.request.getRelativePathPrefixToWicketHandler();
        }

        public String getURL() {
            return this.url;
        }
    }
}

