/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.io;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.wicket.util.io.ClassStreamHandler;
import org.apache.wicket.util.io.HandleArrayListStack;
import org.apache.wicket.util.io.WicketSerializeableException;

public final class WicketObjectOutputStream
extends ObjectOutputStream {
    private final HandleTable handledObjects = new HandleTable();
    private final HandleArrayListStack defaultWrite = new HandleArrayListStack();
    private final DataOutputStream out;
    private ClassStreamHandler classHandler;
    private ObjectOutputStream.PutField curPut;
    private Object curObject;
    static /* synthetic */ Class class$java$io$Serializable;

    public WicketObjectOutputStream(OutputStream out) throws IOException {
        this.out = new DataOutputStream(out);
    }

    public void close() throws IOException {
        this.classHandler = null;
        this.curObject = null;
        this.curPut = null;
        this.handledObjects.clear();
        this.defaultWrite.clear();
        this.out.close();
    }

    public void defaultWriteObject() throws IOException {
        if (!this.defaultWrite.contains(this.curObject)) {
            this.defaultWrite.add(this.curObject);
            this.classHandler.writeFields(this, this.curObject);
        }
    }

    public ObjectOutputStream.PutField putFields() throws IOException {
        if (this.curPut == null) {
            try {
                this.curPut = new PutFieldImpl();
            }
            catch (Exception e) {
                throw new WicketSerializeableException("Error reading put fields", e);
            }
        }
        return this.curPut;
    }

    public void write(byte[] buf) throws IOException {
        this.out.write(buf);
    }

    public void write(byte[] buf, int off, int len) throws IOException {
        this.out.write(buf, off, len);
    }

    public void write(int val) throws IOException {
        this.out.write(val);
    }

    public void writeBoolean(boolean val) throws IOException {
        this.out.writeBoolean(val);
    }

    public void writeByte(int val) throws IOException {
        this.out.writeByte(val);
    }

    public void writeBytes(String str) throws IOException {
        this.out.writeBytes(str);
    }

    public void writeChar(int val) throws IOException {
        this.out.writeChar(val);
    }

    public void writeChars(String str) throws IOException {
        this.out.writeChars(str);
    }

    public void writeDouble(double val) throws IOException {
        this.out.writeDouble(val);
    }

    public void writeFields() throws IOException {
        if (this.curPut != null) {
            try {
                this.curPut.write(this);
            }
            catch (Exception e) {
                throw new WicketSerializeableException("Error writing put fields", e);
            }
        }
    }

    public void writeFloat(float val) throws IOException {
        this.out.writeFloat(val);
    }

    public void writeInt(int val) throws IOException {
        this.out.writeInt(val);
    }

    public void writeLong(long val) throws IOException {
        this.out.writeLong(val);
    }

    public void writeShort(int val) throws IOException {
        this.out.writeShort(val);
    }

    public void writeUTF(String str) throws IOException {
        this.out.writeUTF(str);
    }

    protected final void writeObjectOverride(Object obj) throws IOException {
        if (obj == null) {
            this.out.write(0);
            return;
        }
        int handle = this.handledObjects.lookup(obj);
        if (handle != -1) {
            this.out.write(1);
            this.out.writeShort(handle);
        } else if (obj instanceof Class) {
            ClassStreamHandler classHandler = ClassStreamHandler.lookup((Class)obj);
            this.out.write(5);
            this.out.writeShort(classHandler.getClassId());
        } else {
            Class<?> cls = obj.getClass();
            this.handledObjects.assign(obj);
            if (cls.isArray()) {
                Class<?> componentType = cls.getComponentType();
                ClassStreamHandler classHandler = ClassStreamHandler.lookup(componentType);
                if (componentType.isPrimitive()) {
                    try {
                        this.out.write(4);
                        this.out.writeShort(classHandler.getClassId());
                        classHandler.writeArray(obj, this);
                    }
                    catch (WicketSerializeableException wse) {
                        wse.addTrace(componentType.getName() + "[" + Array.getLength(obj) + "]");
                        throw wse;
                    }
                    catch (Exception e) {
                        throw new WicketSerializeableException("Error writing primitive array of " + componentType.getName() + "[" + Array.getLength(obj) + "]", e);
                    }
                }
                int length = Array.getLength(obj);
                try {
                    this.out.write(3);
                    this.out.writeShort(classHandler.getClassId());
                    this.out.writeInt(length);
                    for (int i = 0; i < length; ++i) {
                        this.writeObjectOverride(Array.get(obj, i));
                    }
                }
                catch (WicketSerializeableException wse) {
                    wse.addTrace(componentType.getName() + "[" + length + "]");
                    throw wse;
                }
                catch (Exception e) {
                    throw new WicketSerializeableException("Error writing array of " + componentType.getName() + "[" + length + "]", e);
                }
                return;
            }
            Class<?> realClz = cls;
            this.classHandler = ClassStreamHandler.lookup(realClz);
            Object object = this.classHandler.writeReplace(obj);
            if (object != null) {
                obj = object;
                realClz = obj.getClass();
                this.classHandler = ClassStreamHandler.lookup(realClz);
            }
            this.out.write(2);
            this.out.writeShort(this.classHandler.getClassId());
            if (obj instanceof String) {
                this.out.writeUTF((String)obj);
            } else {
                ObjectOutputStream.PutField old = this.curPut;
                Object oldObject = this.curObject;
                this.curPut = null;
                this.curObject = obj;
                try {
                    if (!this.classHandler.invokeWriteMethod(this, obj)) {
                        this.classHandler.writeFields(this, obj);
                    }
                }
                catch (WicketSerializeableException wse) {
                    if (realClz != cls) {
                        wse.addTrace(realClz.getName() + "(ReplaceOf:" + cls.getName() + ")");
                    } else {
                        wse.addTrace(realClz.getName());
                    }
                    throw wse;
                }
                catch (Exception e) {
                    if (realClz != cls) {
                        throw new WicketSerializeableException("Error writing fields for " + realClz.getName() + "(ReplaceOf:" + cls.getName() + ")", e);
                    }
                    throw new WicketSerializeableException("Error writing fields for " + realClz.getName(), e);
                }
                finally {
                    this.curObject = oldObject;
                    this.curPut = old;
                }
            }
        }
    }

    private class PutFieldImpl
    extends ObjectOutputStream.PutField {
        private HashMap mapBytes;
        private HashMap mapChar;
        private HashMap mapDouble;
        private HashMap mapFloat;
        private HashMap mapInt;
        private HashMap mapLong;
        private HashMap mapShort;
        private HashMap mapBoolean;
        private HashMap mapObject;

        private PutFieldImpl() {
        }

        public void put(String name, boolean val) {
            if (this.mapBoolean == null) {
                this.mapBoolean = new HashMap(4);
            }
            this.mapBoolean.put(name, val ? Boolean.TRUE : Boolean.FALSE);
        }

        public void put(String name, byte val) {
            if (this.mapBytes == null) {
                this.mapBytes = new HashMap(4);
            }
            this.mapBytes.put(name, new Byte(val));
        }

        public void put(String name, char val) {
            if (this.mapChar == null) {
                this.mapChar = new HashMap(4);
            }
            this.mapChar.put(name, new Character(val));
        }

        public void put(String name, double val) {
            if (this.mapDouble == null) {
                this.mapDouble = new HashMap(4);
            }
            this.mapDouble.put(name, new Double(val));
        }

        public void put(String name, float val) {
            if (this.mapFloat == null) {
                this.mapFloat = new HashMap(4);
            }
            this.mapFloat.put(name, new Float(val));
        }

        public void put(String name, int val) {
            if (this.mapInt == null) {
                this.mapInt = new HashMap(4);
            }
            this.mapInt.put(name, new Integer(val));
        }

        public void put(String name, long val) {
            if (this.mapLong == null) {
                this.mapLong = new HashMap(4);
            }
            this.mapLong.put(name, new Long(val));
        }

        public void put(String name, Object val) {
            if (this.mapObject == null) {
                this.mapObject = new HashMap(4);
            }
            this.mapObject.put(name, val);
        }

        public void put(String name, short val) {
            if (this.mapShort == null) {
                this.mapShort = new HashMap(4);
            }
            this.mapShort.put(name, new Short(val));
        }

        public void write(ObjectOutput out) throws IOException {
            Map.Entry entry;
            Iterator it;
            ClassStreamHandler lookup;
            if (this.mapBoolean != null) {
                lookup = ClassStreamHandler.lookup(Boolean.TYPE);
                WicketObjectOutputStream.this.writeShort(lookup.getClassId());
                WicketObjectOutputStream.this.writeShort(this.mapBoolean.size());
                it = this.mapBoolean.entrySet().iterator();
                while (it.hasNext()) {
                    entry = it.next();
                    WicketObjectOutputStream.this.writeObjectOverride(entry.getKey());
                    WicketObjectOutputStream.this.writeBoolean((Boolean)entry.getValue());
                }
            }
            if (this.mapBytes != null) {
                lookup = ClassStreamHandler.lookup(Byte.TYPE);
                WicketObjectOutputStream.this.writeShort(lookup.getClassId());
                WicketObjectOutputStream.this.writeShort(this.mapBytes.size());
                it = this.mapBytes.entrySet().iterator();
                while (it.hasNext()) {
                    entry = it.next();
                    WicketObjectOutputStream.this.writeObjectOverride(entry.getKey());
                    WicketObjectOutputStream.this.writeByte(((Byte)entry.getValue()).byteValue());
                }
            }
            if (this.mapShort != null) {
                lookup = ClassStreamHandler.lookup(Short.TYPE);
                WicketObjectOutputStream.this.writeShort(lookup.getClassId());
                WicketObjectOutputStream.this.writeShort(this.mapShort.size());
                it = this.mapShort.entrySet().iterator();
                while (it.hasNext()) {
                    entry = it.next();
                    WicketObjectOutputStream.this.writeObjectOverride(entry.getKey());
                    WicketObjectOutputStream.this.writeShort(((Short)entry.getValue()).shortValue());
                }
            }
            if (this.mapChar != null) {
                lookup = ClassStreamHandler.lookup(Character.TYPE);
                WicketObjectOutputStream.this.writeShort(lookup.getClassId());
                WicketObjectOutputStream.this.writeShort(this.mapChar.size());
                it = this.mapChar.entrySet().iterator();
                while (it.hasNext()) {
                    entry = it.next();
                    WicketObjectOutputStream.this.writeObjectOverride(entry.getKey());
                    WicketObjectOutputStream.this.writeChar(((Character)entry.getValue()).charValue());
                }
            }
            if (this.mapInt != null) {
                lookup = ClassStreamHandler.lookup(Integer.TYPE);
                WicketObjectOutputStream.this.writeShort(lookup.getClassId());
                WicketObjectOutputStream.this.writeShort(this.mapInt.size());
                it = this.mapInt.entrySet().iterator();
                while (it.hasNext()) {
                    entry = it.next();
                    WicketObjectOutputStream.this.writeObjectOverride(entry.getKey());
                    WicketObjectOutputStream.this.writeInt((Integer)entry.getValue());
                }
            }
            if (this.mapLong != null) {
                lookup = ClassStreamHandler.lookup(Long.TYPE);
                WicketObjectOutputStream.this.writeShort(lookup.getClassId());
                WicketObjectOutputStream.this.writeShort(this.mapLong.size());
                it = this.mapLong.entrySet().iterator();
                while (it.hasNext()) {
                    entry = it.next();
                    WicketObjectOutputStream.this.writeObjectOverride(entry.getKey());
                    WicketObjectOutputStream.this.writeLong((Long)entry.getValue());
                }
            }
            if (this.mapFloat != null) {
                lookup = ClassStreamHandler.lookup(Float.TYPE);
                WicketObjectOutputStream.this.writeShort(lookup.getClassId());
                WicketObjectOutputStream.this.writeShort(this.mapFloat.size());
                it = this.mapFloat.entrySet().iterator();
                while (it.hasNext()) {
                    entry = it.next();
                    WicketObjectOutputStream.this.writeObjectOverride(entry.getKey());
                    WicketObjectOutputStream.this.writeFloat(((Float)entry.getValue()).floatValue());
                }
            }
            if (this.mapDouble != null) {
                lookup = ClassStreamHandler.lookup(Double.TYPE);
                WicketObjectOutputStream.this.writeShort(lookup.getClassId());
                WicketObjectOutputStream.this.writeShort(this.mapDouble.size());
                it = this.mapDouble.entrySet().iterator();
                while (it.hasNext()) {
                    entry = it.next();
                    WicketObjectOutputStream.this.writeObjectOverride(entry.getKey());
                    WicketObjectOutputStream.this.writeDouble((Double)entry.getValue());
                }
            }
            if (this.mapObject != null) {
                lookup = ClassStreamHandler.lookup(class$java$io$Serializable == null ? (class$java$io$Serializable = WicketObjectOutputStream.class$("java.io.Serializable")) : class$java$io$Serializable);
                WicketObjectOutputStream.this.writeShort(lookup.getClassId());
                WicketObjectOutputStream.this.writeShort(this.mapObject.size());
                it = this.mapObject.entrySet().iterator();
                while (it.hasNext()) {
                    entry = it.next();
                    WicketObjectOutputStream.this.writeObjectOverride(entry.getKey());
                    WicketObjectOutputStream.this.writeObjectOverride(entry.getValue());
                }
            }
            WicketObjectOutputStream.this.writeShort(0);
        }
    }

    private static final class HandleTable {
        private int size;
        private int threshold;
        private final float loadFactor;
        private int[] spine;
        private int[] next;
        private Object[] objs;

        HandleTable() {
            this(16, 0.75f);
        }

        HandleTable(int initialCapacity, float loadFactor) {
            this.loadFactor = loadFactor;
            this.spine = new int[initialCapacity];
            this.next = new int[initialCapacity];
            this.objs = new Object[initialCapacity];
            this.threshold = (int)((float)initialCapacity * loadFactor);
            this.clear();
        }

        private void growEntries() {
            int newLength = (this.next.length << 1) + 1;
            int[] newNext = new int[newLength];
            System.arraycopy(this.next, 0, newNext, 0, this.size);
            this.next = newNext;
            Object[] newObjs = new Object[newLength];
            System.arraycopy(this.objs, 0, newObjs, 0, this.size);
            this.objs = newObjs;
        }

        private void growSpine() {
            this.spine = new int[(this.spine.length << 1) + 1];
            this.threshold = (int)((float)this.spine.length * this.loadFactor);
            Arrays.fill(this.spine, -1);
            for (int i = 0; i < this.size; ++i) {
                this.insert(this.objs[i], i);
            }
        }

        private int hash(Object obj) {
            return System.identityHashCode(obj) & Integer.MAX_VALUE;
        }

        private void insert(Object obj, int handle) {
            int index = this.hash(obj) % this.spine.length;
            this.objs[handle] = obj;
            this.next[handle] = this.spine[index];
            this.spine[index] = handle;
        }

        int assign(Object obj) {
            if (this.size >= this.next.length) {
                this.growEntries();
            }
            if (this.size >= this.threshold) {
                this.growSpine();
            }
            this.insert(obj, this.size);
            return this.size++;
        }

        void clear() {
            Arrays.fill(this.spine, -1);
            Arrays.fill(this.objs, 0, this.size, null);
            this.size = 0;
        }

        boolean contains(Object obj) {
            return this.lookup(obj) != -1;
        }

        int lookup(Object obj) {
            if (this.size == 0) {
                return -1;
            }
            int index = this.hash(obj) % this.spine.length;
            int i = this.spine[index];
            while (i >= 0) {
                if (this.objs[i] == obj) {
                    return i;
                }
                i = this.next[i];
            }
            return -1;
        }

        int size() {
            return this.size;
        }
    }
}

