/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.wicket.util.resource.AbstractResourceStream;
import org.apache.wicket.util.resource.IFixedLocationResourceStream;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;
import org.apache.wicket.util.time.Time;

public class FileResourceStream
extends AbstractResourceStream
implements IFixedLocationResourceStream {
    private static final long serialVersionUID = 1L;
    private final org.apache.wicket.util.file.File file;
    private transient InputStream inputStream;

    public FileResourceStream(org.apache.wicket.util.file.File file) {
        this.file = file;
    }

    public FileResourceStream(File file) {
        this.file = new org.apache.wicket.util.file.File(file);
    }

    public void close() throws IOException {
        if (this.inputStream != null) {
            this.inputStream.close();
            this.inputStream = null;
        }
    }

    public String getContentType() {
        return null;
    }

    public org.apache.wicket.util.file.File getFile() {
        return this.file;
    }

    public InputStream getInputStream() throws ResourceStreamNotFoundException {
        if (this.inputStream == null) {
            try {
                this.inputStream = new FileInputStream(this.file);
            }
            catch (FileNotFoundException e) {
                throw new ResourceStreamNotFoundException("Resource " + this.file + " could not be found", e);
            }
        }
        return this.inputStream;
    }

    public Time lastModifiedTime() {
        if (this.file != null) {
            return this.file.lastModifiedTime();
        }
        return null;
    }

    public String toString() {
        if (this.file != null) {
            return this.file.toString();
        }
        return "";
    }

    public long length() {
        if (this.file != null) {
            return this.file.length();
        }
        return 0L;
    }

    public String locationAsString() {
        if (this.file != null) {
            return this.file.getAbsolutePath();
        }
        return null;
    }
}

