/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.watch;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.wicket.util.concurrent.ConcurrentHashMap;
import org.apache.wicket.util.listener.ChangeListenerSet;
import org.apache.wicket.util.listener.IChangeListener;
import org.apache.wicket.util.thread.ICode;
import org.apache.wicket.util.thread.Task;
import org.apache.wicket.util.time.Duration;
import org.apache.wicket.util.time.Time;
import org.apache.wicket.util.watch.IModifiable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ModificationWatcher {
    private static final Logger log = LoggerFactory.getLogger((Class)ModificationWatcher.class);
    private final Map modifiableToEntry = new ConcurrentHashMap();
    private Task task;

    public ModificationWatcher() {
    }

    public ModificationWatcher(Duration pollFrequency) {
        this.start(pollFrequency);
    }

    public final boolean add(IModifiable modifiable, IChangeListener listener) {
        Entry entry = (Entry)this.modifiableToEntry.get(modifiable);
        if (entry == null) {
            if (modifiable.lastModifiedTime() != null) {
                Entry newEntry = new Entry();
                newEntry.modifiable = modifiable;
                newEntry.lastModifiedTime = modifiable.lastModifiedTime();
                newEntry.listeners.add(listener);
                this.modifiableToEntry.put(modifiable, newEntry);
            } else {
                log.info("Cannot track modifications to resource " + modifiable);
            }
            return true;
        }
        return entry.listeners.add(listener);
    }

    public IModifiable remove(IModifiable modifiable) {
        Entry entry = (Entry)this.modifiableToEntry.remove(modifiable);
        if (entry != null) {
            return entry.modifiable;
        }
        return null;
    }

    public void start(Duration pollFrequency) {
        this.task = new Task("ModificationWatcher");
        this.task.run(pollFrequency, new ICode(){

            public void run(Logger log) {
                Iterator iterator = new ArrayList(ModificationWatcher.this.modifiableToEntry.values()).iterator();
                while (iterator.hasNext()) {
                    Entry entry = (Entry)iterator.next();
                    Time modifiableLastModified = entry.modifiable.lastModifiedTime();
                    if (!modifiableLastModified.after(entry.lastModifiedTime)) continue;
                    entry.listeners.notifyListeners();
                    entry.lastModifiedTime = modifiableLastModified;
                }
            }
        });
    }

    public void destroy() {
        if (this.task != null) {
            this.task.interrupt();
        }
    }

    public final Set getEntries() {
        return this.modifiableToEntry.keySet();
    }

    private static final class Entry {
        Time lastModifiedTime;
        final ChangeListenerSet listeners = new ChangeListenerSet();
        IModifiable modifiable;

        private Entry() {
        }
    }
}

