/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.validation.validator;

import java.util.Date;
import java.util.Map;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.validator.AbstractValidator;

public abstract class DateValidator
extends AbstractValidator {
    private static final long serialVersionUID = 1L;

    public static DateValidator range(Date minimum, Date maximum) {
        return new RangeValidator(minimum, maximum);
    }

    public static DateValidator minimum(Date minimum) {
        return new MinimumValidator(minimum);
    }

    public static DateValidator maximum(Date maximum) {
        return new MaximumValidator(maximum);
    }

    private static class MaximumValidator
    extends DateValidator {
        private static final long serialVersionUID = 1L;
        private final Date maximum;

        private MaximumValidator(Date maximum) {
            this.maximum = maximum;
        }

        protected Map variablesMap(IValidatable validatable) {
            Map map = super.variablesMap(validatable);
            map.put("maximum", this.maximum);
            return map;
        }

        protected String resourceKey() {
            return "DateValidator.maximum";
        }

        protected void onValidate(IValidatable validatable) {
            Date value = (Date)validatable.getValue();
            if (value.after(this.maximum)) {
                this.error(validatable);
            }
        }
    }

    private static class MinimumValidator
    extends DateValidator {
        private static final long serialVersionUID = 1L;
        private final Date minimum;

        private MinimumValidator(Date minimum) {
            this.minimum = minimum;
        }

        protected Map variablesMap(IValidatable validatable) {
            Map map = super.variablesMap(validatable);
            map.put("minimum", this.minimum);
            return map;
        }

        protected String resourceKey() {
            return "DateValidator.minimum";
        }

        protected void onValidate(IValidatable validatable) {
            Date value = (Date)validatable.getValue();
            if (value.before(this.minimum)) {
                this.error(validatable);
            }
        }
    }

    private static class RangeValidator
    extends DateValidator {
        private static final long serialVersionUID = 1L;
        private final Date minimum;
        private final Date maximum;

        private RangeValidator(Date minimum, Date maximum) {
            this.minimum = minimum;
            this.maximum = maximum;
        }

        protected Map variablesMap(IValidatable validatable) {
            Map map = super.variablesMap(validatable);
            map.put("minimum", this.minimum);
            map.put("maximum", this.maximum);
            return map;
        }

        protected String resourceKey() {
            return "DateValidator.range";
        }

        protected void onValidate(IValidatable validatable) {
            Date value = (Date)validatable.getValue();
            if (value.before(this.minimum) || value.after(this.maximum)) {
                this.error(validatable);
            }
        }
    }
}

