/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.base.genfiles;

public abstract class ObjectSorter {
    public abstract boolean less(Object var1, Object var2);

    public final void sort(Object[] data) {
        this.qsort(data, 0, data.length - 1);
    }

    public final void sort(Object[] data, int start, int n) {
        this.qsort(data, start, start + n - 1);
    }

    private void qsort(Object[] data, int left, int right) {
        while (right - left >= 8) {
            Object pivot = this.pick_pivot(data, left, right);
            int pa = left;
            int pb = left;
            int pc = right;
            int pd = right;
            while (true) {
                if (pb <= pc && !this.less(pivot, data[pb])) {
                    if (!this.less(data[pb], pivot)) {
                        ObjectSorter.swap(data, pa, pb);
                        ++pa;
                    }
                    ++pb;
                    continue;
                }
                while (pb <= pc && !this.less(data[pc], pivot)) {
                    if (!this.less(pivot, data[pc])) {
                        ObjectSorter.swap(data, pc, pd);
                        --pd;
                    }
                    --pc;
                }
                if (pb > pc) break;
                ObjectSorter.swap(data, pb, pc);
                ++pb;
                --pc;
            }
            int s = ObjectSorter.min(pa - left, pb - pa);
            ObjectSorter.swap_range(data, left, pb - s, s);
            s = ObjectSorter.min(pd - pc, right - pd);
            ObjectSorter.swap_range(data, pb, right + 1 - s, s);
            int l1 = left;
            int r1 = left + (pb - pa) - 1;
            int l2 = right + 1 - (pd - pc);
            int r2 = right;
            if (r1 - l1 < r2 - l2) {
                left = l2;
                right = r2;
            } else {
                left = l1;
                right = r1;
                l1 = l2;
                r1 = r2;
            }
            if (l1 >= r1) continue;
            this.qsort(data, l1, r1);
        }
        this.insertion_sort(data, left, right);
    }

    private static int min(int a, int b) {
        return a < b ? a : b;
    }

    private Object pick_pivot(Object[] data, int left, int right) {
        if (right - left + 1 > 100) {
            int d = (right - left) / 8;
            Object a = this.median(data[left + 0 * d], data[left + 1 * d], data[left + 2 * d]);
            Object b = this.median(data[left + 3 * d], data[left + 4 * d], data[left + 5 * d]);
            Object c = this.median(data[left + 6 * d], data[left + 7 * d], data[left + 8 * d]);
            return this.median(a, b, c);
        }
        return this.median(data[left], data[(left + right) / 2], data[right]);
    }

    private Object median(Object a, Object b, Object c) {
        return this.less(a, b) ? (this.less(b, c) ? b : (this.less(a, c) ? c : a)) : (this.less(c, b) ? b : (this.less(c, a) ? c : a));
    }

    private void insertion_sort(Object[] data, int left, int right) {
        for (int m = left + 1; m <= right; ++m) {
            for (int k = m; k > left && this.less(data[k], data[k - 1]); --k) {
                ObjectSorter.swap(data, k - 1, k);
            }
        }
    }

    private static void swap(Object[] data, int i, int j) {
        Object tmp = data[i];
        data[i] = data[j];
        data[j] = tmp;
    }

    private static void swap_range(Object[] data, int p1, int p2, int n) {
        for (int i = 0; i < n; ++i) {
            ObjectSorter.swap(data, p1 + i, p2 + i);
        }
    }

    public final void check(Object[] data, int left, int right) {
        for (int i = left + 1; i <= right; ++i) {
            if (!this.less(data[i], data[i - 1])) continue;
            System.err.println("ERROR at index " + i);
            ObjectSorter.dump("data", data, left, right);
            System.exit(1);
        }
    }

    private static void dump(String label, Object[] data, int left, int right) {
        System.err.print(label);
        for (int i = left; i <= right; ++i) {
            System.err.print(' ');
            System.err.print(i);
            System.err.print(':');
            System.err.print(data[i]);
        }
        System.err.println();
    }
}

