/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket;

import org.apache.wicket.AbstractRestartResponseException;
import org.apache.wicket.IPageMap;
import org.apache.wicket.Page;
import org.apache.wicket.PageMap;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.request.RequestParameters;

public class RestartResponseAtInterceptPageException
extends AbstractRestartResponseException {
    private static final long serialVersionUID = 1L;

    public RestartResponseAtInterceptPageException(Page interceptPage) {
        if (interceptPage == null) {
            throw new IllegalStateException("Argument interceptPage cannot be null");
        }
        this.redirectToInterceptPage(interceptPage);
    }

    public RestartResponseAtInterceptPageException(Class interceptPageClass) {
        if (interceptPageClass == null) {
            throw new IllegalStateException("Argument pageClass cannot be null");
        }
        this.redirectToInterceptPage(interceptPageClass);
    }

    private void redirectToInterceptPage(Page interceptPage) {
        Page requestPage = RequestCycle.get().getRequest().getPage();
        IPageMap pageMap = requestPage != null ? requestPage.getPageMap() : interceptPage.getPageMap();
        pageMap.redirectToInterceptPage(interceptPage);
    }

    private void redirectToInterceptPage(Class interceptPageClass) {
        IPageMap pageMap;
        RequestCycle cycle = RequestCycle.get();
        Page requestPage = cycle.getRequest().getPage();
        if (requestPage != null) {
            pageMap = requestPage.getPageMap();
        } else {
            RequestParameters parameters = cycle.getRequest().getRequestParameters();
            pageMap = PageMap.forName(parameters.getPageMapName());
        }
        pageMap.redirectToInterceptPage(interceptPageClass);
    }
}

