/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.ajax.markup.html.form;

import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.IAjaxCallDecorator;
import org.apache.wicket.ajax.form.AjaxFormSubmitBehavior;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.util.string.AppendingStringBuffer;

public abstract class AjaxButton
extends Button {
    private static final long serialVersionUID = 1L;
    private final Form form;

    public AjaxButton(String id) {
        this(id, (Form)null);
    }

    public Form getForm() {
        if (this.form != null) {
            return this.form;
        }
        return super.getForm();
    }

    public AjaxButton(String id, Form form) {
        super(id);
        this.form = form;
        this.add(new AjaxFormSubmitBehavior(form, "onclick"){
            private static final long serialVersionUID = 1L;

            protected void onSubmit(AjaxRequestTarget target) {
                AjaxButton.this.onSubmit(target, AjaxButton.this.getForm());
            }

            protected void onError(AjaxRequestTarget target) {
                AjaxButton.this.onError(target, AjaxButton.this.getForm());
            }

            protected CharSequence getEventHandler() {
                return new AppendingStringBuffer(super.getEventHandler()).append("; return false;");
            }

            protected IAjaxCallDecorator getAjaxCallDecorator() {
                return AjaxButton.this.getAjaxCallDecorator();
            }
        });
    }

    protected IAjaxCallDecorator getAjaxCallDecorator() {
        return null;
    }

    protected abstract void onSubmit(AjaxRequestTarget var1, Form var2);

    protected void onError(AjaxRequestTarget target, Form form) {
    }
}

