/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form;

import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.AbstractChoice;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.apache.wicket.util.string.Strings;

public abstract class AbstractSingleSelectChoice
extends AbstractChoice {
    private static final long serialVersionUID = 1L;
    private static final String CHOOSE_ONE = "Choose One";
    protected static final String NO_SELECTION_VALUE = "-1";
    private static final String EMPTY_STRING = "";
    private boolean nullValid = false;

    public AbstractSingleSelectChoice(String id) {
        super(id);
    }

    public AbstractSingleSelectChoice(String id, List choices) {
        super(id, choices);
    }

    public AbstractSingleSelectChoice(String id, List data, IChoiceRenderer renderer) {
        super(id, data, renderer);
    }

    public AbstractSingleSelectChoice(String id, IModel model, List data) {
        super(id, model, data);
    }

    public AbstractSingleSelectChoice(String id, IModel model, List data, IChoiceRenderer renderer) {
        super(id, model, data, renderer);
    }

    public AbstractSingleSelectChoice(String id, IModel choices) {
        super(id, choices);
    }

    public AbstractSingleSelectChoice(String id, IModel model, IModel choices) {
        super(id, model, choices);
    }

    public AbstractSingleSelectChoice(String id, IModel choices, IChoiceRenderer renderer) {
        super(id, choices, renderer);
    }

    public AbstractSingleSelectChoice(String id, IModel model, IModel choices, IChoiceRenderer renderer) {
        super(id, model, choices, renderer);
    }

    public String getModelValue() {
        Object object = this.getModelObject();
        if (object != null) {
            int index = this.getChoices().indexOf(object);
            return this.getChoiceRenderer().getIdValue(object, index);
        }
        return NO_SELECTION_VALUE;
    }

    public boolean isNullValid() {
        return this.nullValid;
    }

    public AbstractSingleSelectChoice setNullValid(boolean nullValid) {
        this.nullValid = nullValid;
        return this;
    }

    protected final Object convertValue(String[] value) {
        String tmp = value != null && value.length > 0 ? value[0] : null;
        return this.convertChoiceIdToChoice(tmp);
    }

    protected Object convertChoiceIdToChoice(String id) {
        List choices = this.getChoices();
        IChoiceRenderer renderer = this.getChoiceRenderer();
        for (int index = 0; index < choices.size(); ++index) {
            Object choice = choices.get(index);
            if (!renderer.getIdValue(choice, index).equals(id)) continue;
            return choice;
        }
        return null;
    }

    protected CharSequence getDefaultChoice(Object selected) {
        if (this.isNullValid()) {
            String option = this.getLocalizer().getString(this.getId() + ".nullValid", (Component)this, EMPTY_STRING);
            if (Strings.isEmpty(option)) {
                option = this.getLocalizer().getString("nullValid", (Component)this, EMPTY_STRING);
            }
            AppendingStringBuffer buffer = new AppendingStringBuffer(32 + option.length());
            buffer.append("\n<option");
            if (selected == null) {
                buffer.append(" selected=\"selected\"");
            }
            buffer.append(" value=\"\">").append(option).append("</option>");
            return buffer;
        }
        if (selected == null || selected.equals(NO_SELECTION_VALUE) || selected.equals(EMPTY_STRING)) {
            String option = this.getLocalizer().getString(this.getId() + ".null", (Component)this, EMPTY_STRING);
            if (Strings.isEmpty(option)) {
                option = this.getLocalizer().getString("null", (Component)this, CHOOSE_ONE);
            }
            return new AppendingStringBuffer("\n<option selected=\"selected\" value=\"\">").append(option).append("</option>");
        }
        return EMPTY_STRING;
    }

    protected boolean isSelected(Object object, int index, String selected) {
        return selected != null && selected.equals(this.getChoiceRenderer().getIdValue(object, index));
    }
}

