/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.resource;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import org.apache.wicket.Application;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.util.resource.AbstractResourceStream;
import org.apache.wicket.util.resource.IFixedLocationResourceStream;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;
import org.apache.wicket.util.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlResourceStream
extends AbstractResourceStream
implements IFixedLocationResourceStream {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger((Class)UrlResourceStream.class);
    private transient InputStream inputStream;
    private final URL url;
    private File file;
    private int contentLength;
    private String contentType;
    private long lastModified;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UrlResourceStream(URL url) {
        this.url = url;
        URLConnection connection = null;
        try {
            try {
                connection = url.openConnection();
                this.contentLength = connection.getContentLength();
                this.contentType = connection.getContentType();
                this.lastModified = connection.getLastModified();
                try {
                    this.file = new File(new URI(url.toExternalForm()));
                }
                catch (Exception ex) {
                    log.debug("cannot convert url: " + url + " to file (" + ex.getMessage() + "), falling back to the inputstream for polling");
                }
                if (this.file != null && !this.file.exists()) {
                    this.file = null;
                }
            }
            catch (IOException ex) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Invalid URL parameter " + url);
                illegalArgumentException.initCause(ex);
                throw illegalArgumentException;
            }
            Object var6_5 = null;
            if (connection == null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (connection == null) throw throwable;
            if (connection instanceof HttpURLConnection) {
                ((HttpURLConnection)connection).disconnect();
                throw throwable;
            }
            try {
                connection.getInputStream().close();
                throw throwable;
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw throwable;
        }
        if (connection instanceof HttpURLConnection) {
            ((HttpURLConnection)connection).disconnect();
            return;
        }
        try {}
        catch (Exception ex) {}
        connection.getInputStream().close();
        return;
    }

    public void close() throws IOException {
        if (this.inputStream != null) {
            this.inputStream.close();
            this.inputStream = null;
        }
    }

    public String getContentType() {
        this.testContentType();
        return this.contentType;
    }

    private void testContentType() {
        if (this.contentType == null || this.contentType.indexOf("unknown") != -1) {
            Application application = Application.get();
            if (application instanceof WebApplication) {
                this.contentType = ((WebApplication)application).getServletContext().getMimeType(this.url.getFile());
                if (this.contentType == null) {
                    this.contentType = URLConnection.getFileNameMap().getContentTypeFor(this.url.getFile());
                }
            } else {
                this.contentType = URLConnection.getFileNameMap().getContentTypeFor(this.url.getFile());
            }
        }
    }

    public InputStream getInputStream() throws ResourceStreamNotFoundException {
        if (this.inputStream == null) {
            try {
                this.inputStream = this.url.openStream();
            }
            catch (IOException e) {
                throw new ResourceStreamNotFoundException("Resource " + this.url + " could not be opened", e);
            }
        }
        return this.inputStream;
    }

    public URL getURL() {
        return this.url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Time lastModifiedTime() {
        if (this.file != null) {
            long lastModified = this.file.lastModified();
            if (lastModified == this.lastModified) return Time.milliseconds(this.lastModified);
            this.lastModified = lastModified;
            this.contentLength = (int)this.file.length();
            return Time.milliseconds(this.lastModified);
        }
        URLConnection urlConnection = null;
        boolean close = false;
        try {
            block22: {
                urlConnection = this.url.openConnection();
                long lastModified = this.lastModified;
                if (urlConnection instanceof JarURLConnection) {
                    JarURLConnection jarUrlConnection = (JarURLConnection)urlConnection;
                    URL jarFileUrl = jarUrlConnection.getJarFileURL();
                    URLConnection jarFileConnection = jarFileUrl.openConnection();
                    try {
                        lastModified = jarFileConnection.getLastModified();
                    }
                    finally {
                        jarFileConnection.getInputStream().close();
                    }
                } else {
                    close = true;
                    lastModified = urlConnection.getLastModified();
                }
                if (lastModified == this.lastModified) break block22;
                this.lastModified = lastModified;
                close = true;
                this.contentLength = urlConnection.getContentLength();
            }
            Object var10_10 = null;
            if (urlConnection == null) return Time.milliseconds(this.lastModified);
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            if (urlConnection == null) throw throwable;
            if (urlConnection instanceof HttpURLConnection) {
                ((HttpURLConnection)urlConnection).disconnect();
                throw throwable;
            }
            if (!close) throw throwable;
            try {
                urlConnection.getInputStream().close();
                throw throwable;
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw throwable;
        }
        if (urlConnection instanceof HttpURLConnection) {
            ((HttpURLConnection)urlConnection).disconnect();
            return Time.milliseconds(this.lastModified);
        } else {
            if (!close) return Time.milliseconds(this.lastModified);
            try {
                urlConnection.getInputStream().close();
                return Time.milliseconds(this.lastModified);
            }
            catch (Exception ex) {}
        }
        return Time.milliseconds(this.lastModified);
        {
            catch (IOException e) {
                if (this.url.toString().indexOf(".jar!") >= 0) {
                    if (log.isDebugEnabled()) {
                        log.debug("getLastModified for " + this.url + " failed: " + e.getMessage());
                    }
                } else {
                    log.error("getLastModified for " + this.url + " failed: " + e.getMessage());
                }
                Object var10_11 = null;
                if (urlConnection == null) return Time.milliseconds(this.lastModified);
                if (urlConnection instanceof HttpURLConnection) {
                    ((HttpURLConnection)urlConnection).disconnect();
                    return Time.milliseconds(this.lastModified);
                } else {
                    if (!close) return Time.milliseconds(this.lastModified);
                    try {
                        urlConnection.getInputStream().close();
                        return Time.milliseconds(this.lastModified);
                    }
                    catch (Exception ex) {}
                }
                return Time.milliseconds(this.lastModified);
            }
        }
    }

    public String toString() {
        return this.url.toString();
    }

    public long length() {
        return this.contentLength;
    }

    public String locationAsString() {
        return this.url.toExternalForm();
    }
}

