/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.expression;

import java.text.CharacterIterator;
import java.text.StringCharacterIterator;

public class MatchExpressionParser {
    private final String input;
    private final CharacterIterator ci;
    private final char zeroOrMoreChar;
    private final char anyChar;
    private final char escapeChar;

    public MatchExpressionParser(String input, char zeroOrMoreChar, char anyChar, char escapeChar) {
        this.input = input;
        this.zeroOrMoreChar = zeroOrMoreChar;
        this.anyChar = anyChar;
        this.escapeChar = escapeChar;
        this.ci = new StringCharacterIterator(input);
    }

    private boolean parseNextChar(char c) {
        int savedIdx = this.ci.getIndex();
        if (this.ci.next() == c) {
            return true;
        }
        this.ci.setIndex(savedIdx);
        return false;
    }

    public String parsePattern() {
        char c;
        StringBuffer lit = new StringBuffer();
        while ((c = this.ci.current()) != '\uffff') {
            if (c == '\\') {
                lit.append(this.parseEscapedCharacter());
            } else if (c == '.') {
                if (this.parseNextChar('*')) {
                    lit.append(this.zeroOrMoreChar);
                } else {
                    lit.append(this.anyChar);
                }
            } else if (c == this.anyChar) {
                lit.append("" + this.escapeChar + this.anyChar);
            } else if (c == this.zeroOrMoreChar) {
                lit.append("" + this.escapeChar + this.zeroOrMoreChar);
            } else {
                lit.append(c);
            }
            this.ci.next();
        }
        return lit.toString();
    }

    private String parseEscapedCharacter() {
        char c = this.ci.next();
        if (c == '\uffff') {
            return this.escapeChar + "\\";
        }
        if (c == '.') {
            return ".";
        }
        if (c == '\\') {
            return this.escapeChar + "\\" + this.escapeChar + c;
        }
        return this.escapeChar + "\\" + c;
    }

    public String toString() {
        return this.input;
    }
}

