/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.bootstrap;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.event.Observes;
import javax.inject.BindingType;
import javax.inject.DeploymentType;
import javax.inject.Disposes;
import javax.inject.Initializer;
import javax.inject.Produces;
import javax.inject.Realizes;
import javax.inject.UnsatisfiedDependencyException;
import org.jboss.webbeans.ManagerImpl;
import org.jboss.webbeans.bean.AbstractClassBean;
import org.jboss.webbeans.bean.DisposalMethodBean;
import org.jboss.webbeans.bean.EnterpriseBean;
import org.jboss.webbeans.bean.NewEnterpriseBean;
import org.jboss.webbeans.bean.NewSimpleBean;
import org.jboss.webbeans.bean.ProducerFieldBean;
import org.jboss.webbeans.bean.ProducerMethodBean;
import org.jboss.webbeans.bean.RIBean;
import org.jboss.webbeans.bean.SimpleBean;
import org.jboss.webbeans.bootstrap.BeanDeployerEnvironment;
import org.jboss.webbeans.ejb.EJBApiAbstraction;
import org.jboss.webbeans.ejb.EjbDescriptorCache;
import org.jboss.webbeans.event.ObserverFactory;
import org.jboss.webbeans.event.ObserverImpl;
import org.jboss.webbeans.introspector.AnnotatedClass;
import org.jboss.webbeans.introspector.AnnotatedField;
import org.jboss.webbeans.introspector.AnnotatedMethod;
import org.jboss.webbeans.introspector.WrappedAnnotatedField;
import org.jboss.webbeans.introspector.WrappedAnnotatedMethod;
import org.jboss.webbeans.jsf.JSFApiAbstraction;
import org.jboss.webbeans.log.LogProvider;
import org.jboss.webbeans.log.Logging;
import org.jboss.webbeans.persistence.spi.EntityDiscovery;
import org.jboss.webbeans.resources.ClassTransformer;
import org.jboss.webbeans.servlet.ServletApiAbstraction;
import org.jboss.webbeans.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanDeployer {
    private static final LogProvider log = Logging.getLogProvider(BeanDeployer.class);
    private final BeanDeployerEnvironment environment;
    private final Set<AnnotatedClass<?>> classes;
    private final ManagerImpl manager;
    private final ClassTransformer classTransformer;

    public BeanDeployer(ManagerImpl manager, EjbDescriptorCache ejbDescriptors) {
        this.manager = manager;
        this.environment = new BeanDeployerEnvironment(ejbDescriptors);
        this.classes = new HashSet();
        this.classTransformer = new ClassTransformer();
    }

    public <T> BeanDeployer addBean(RIBean<T> bean) {
        this.environment.addBean(bean);
        return this;
    }

    public BeanDeployer addBeans(Iterable<? extends RIBean<?>> beans) {
        for (RIBean<?> bean : beans) {
            this.addBean(bean);
        }
        return this;
    }

    public BeanDeployer addClass(Class<?> clazz) {
        if (!clazz.isAnnotation() && !clazz.isEnum()) {
            this.classes.add(this.classTransformer.classForName(clazz));
        }
        return this;
    }

    public BeanDeployer addClasses(Iterable<Class<?>> classes) {
        for (Class<?> clazz : classes) {
            this.addClass(clazz);
        }
        return this;
    }

    public BeanDeployer addClasses(Collection<AnnotatedClass<?>> classes) {
        classes.addAll(classes);
        return this;
    }

    public BeanDeployer createBeans() {
        for (AnnotatedClass<?> clazz : this.classes) {
            if (this.environment.getEjbDescriptors().containsKey(clazz.getRawType())) {
                this.createEnterpriseBean(clazz);
                continue;
            }
            if (!this.isTypeSimpleWebBean(clazz)) continue;
            this.createSimpleBean(clazz);
        }
        return this;
    }

    public BeanDeployer deploy() {
        Set<RIBean<?>> beans = this.environment.getBeans();
        for (RIBean<?> rIBean : beans) {
            rIBean.initialize(this.environment);
            log.debug("Bean: " + rIBean);
        }
        this.manager.setBeans(beans);
        for (ObserverImpl observerImpl : this.environment.getObservers()) {
            observerImpl.initialize();
            log.debug("Observer : " + observerImpl);
            this.manager.addObserver(observerImpl);
        }
        this.checkDisposalMethods();
        return this;
    }

    private void checkDisposalMethods() {
        HashSet all = new HashSet(this.environment.getAllDisposalBeans());
        HashSet resolved = new HashSet(this.environment.getResolvedDisposalBeans());
        if (all.size() > 0 && !resolved.containsAll(all)) {
            StringBuffer buff = new StringBuffer();
            buff.append("The following Disposal methods where not resolved\n");
            all.removeAll(resolved);
            for (DisposalMethodBean disposalMethodBean : all) {
                buff.append(disposalMethodBean.toString());
            }
            throw new UnsatisfiedDependencyException(buff.toString());
        }
    }

    public BeanDeployerEnvironment getBeanDeployerEnvironment() {
        return this.environment;
    }

    protected <T> void createBean(AbstractClassBean<T> bean, AnnotatedClass<T> annotatedClass) {
        this.addBean(bean);
        this.manager.getResolver().addInjectionPoints(bean.getInjectionPoints());
        this.createProducerMethods(bean, annotatedClass);
        this.createProducerFields(bean, annotatedClass);
        this.createObserverMethods(bean, annotatedClass);
        this.createDisposalMethods(bean, annotatedClass);
        if (annotatedClass.isAnnotationPresent(Realizes.class)) {
            this.createRealizedProducerMethods(bean, annotatedClass);
            this.createRealizedProducerFields(bean, annotatedClass);
            this.createRealizedObserverMethods(bean, annotatedClass);
        }
    }

    private void createProducerMethods(AbstractClassBean<?> declaringBean, AnnotatedClass<?> annotatedClass) {
        for (AnnotatedMethod<?> method : annotatedClass.getDeclaredAnnotatedMethods(Produces.class)) {
            this.createProducerMethod(declaringBean, method);
        }
    }

    private void createDisposalMethods(AbstractClassBean<?> declaringBean, AnnotatedClass<?> annotatedClass) {
        for (AnnotatedMethod<?> method : annotatedClass.getDeclaredMethodsWithAnnotatedParameters(Disposes.class)) {
            DisposalMethodBean<?> disposalBean = DisposalMethodBean.of(this.manager, method, declaringBean);
            this.environment.addAllDisposalBean(disposalBean);
            this.manager.getResolver().addInjectionPoints(disposalBean.getInjectionPoints());
            this.manager.addBean(disposalBean);
        }
    }

    private <T> void createProducerMethod(AbstractClassBean<?> declaringBean, AnnotatedMethod<T> annotatedMethod) {
        ProducerMethodBean<T> bean = ProducerMethodBean.of(annotatedMethod, declaringBean, this.manager);
        this.addBean(bean);
        this.manager.getResolver().addInjectionPoints(bean.getInjectionPoints());
    }

    private void createRealizedProducerMethods(AbstractClassBean<?> declaringBean, AnnotatedClass<?> realizingClass) {
        AnnotatedClass<?> realizedClass = realizingClass.getSuperclass();
        for (AnnotatedMethod<?> realizedMethod : realizedClass.getDeclaredAnnotatedMethods(Produces.class)) {
            this.createProducerMethod(declaringBean, BeanDeployer.realizeProducerMethod(realizedMethod, realizingClass));
        }
    }

    private void createRealizedProducerFields(AbstractClassBean<?> declaringBean, AnnotatedClass<?> realizingClass) {
        AnnotatedClass<?> realizedClass = realizingClass.getSuperclass();
        for (AnnotatedField<?> realizedField : realizedClass.getDeclaredAnnotatedFields(Produces.class)) {
            this.createProducerField(declaringBean, BeanDeployer.realizeProducerField(realizedField, realizingClass));
        }
    }

    private <T> void createProducerField(AbstractClassBean<?> declaringBean, AnnotatedField<T> field) {
        ProducerFieldBean<T> bean = ProducerFieldBean.of(field, declaringBean, this.manager);
        this.addBean(bean);
    }

    private void createProducerFields(AbstractClassBean<?> declaringBean, AnnotatedClass<?> annotatedClass) {
        for (AnnotatedField<?> field : annotatedClass.getDeclaredAnnotatedFields(Produces.class)) {
            this.createProducerField(declaringBean, field);
        }
    }

    private void createObserverMethods(AbstractClassBean<?> declaringBean, AnnotatedClass<?> annotatedClass) {
        for (AnnotatedMethod<?> method : annotatedClass.getDeclaredMethodsWithAnnotatedParameters(Observes.class)) {
            this.createObserverMethod(declaringBean, method);
        }
    }

    private void createRealizedObserverMethods(AbstractClassBean<?> declaringBean, AnnotatedClass<?> realizingClass) {
        this.createObserverMethods(declaringBean, realizingClass.getSuperclass());
    }

    private void createObserverMethod(AbstractClassBean<?> declaringBean, AnnotatedMethod<?> method) {
        ObserverImpl observer = ObserverFactory.create(method, declaringBean, this.manager);
        this.environment.getObservers().add(observer);
    }

    private <T> void createSimpleBean(AnnotatedClass<T> annotatedClass) {
        SimpleBean<T> bean = SimpleBean.of(annotatedClass, this.manager);
        this.createBean(bean, annotatedClass);
        this.addBean(NewSimpleBean.of(annotatedClass, this.manager));
    }

    private <T> void createEnterpriseBean(AnnotatedClass<T> annotatedClass) {
        EnterpriseBean<T> bean = EnterpriseBean.of(annotatedClass, this.manager, this.environment);
        this.createBean(bean, annotatedClass);
        this.addBean(NewEnterpriseBean.of(annotatedClass, this.manager, this.environment));
    }

    private boolean isTypeSimpleWebBean(AnnotatedClass<?> clazz) {
        Class rawType = clazz.getRawType();
        EJBApiAbstraction ejbApiAbstraction = this.manager.getServices().get(EJBApiAbstraction.class);
        JSFApiAbstraction jsfApiAbstraction = this.manager.getServices().get(JSFApiAbstraction.class);
        ServletApiAbstraction servletApiAbstraction = this.manager.getServices().get(ServletApiAbstraction.class);
        return !Reflections.isAbstract(rawType) && !Reflections.isParameterizedType(rawType) && !servletApiAbstraction.SERVLET_CLASS.isAssignableFrom(rawType) && !servletApiAbstraction.FILTER_CLASS.isAssignableFrom(rawType) && !servletApiAbstraction.SERVLET_CONTEXT_LISTENER_CLASS.isAssignableFrom(rawType) && !servletApiAbstraction.HTTP_SESSION_LISTENER_CLASS.isAssignableFrom(rawType) && !servletApiAbstraction.SERVLET_REQUEST_LISTENER_CLASS.isAssignableFrom(rawType) && !ejbApiAbstraction.ENTERPRISE_BEAN_CLASS.isAssignableFrom(rawType) && !jsfApiAbstraction.UICOMPONENT_CLASS.isAssignableFrom(rawType) && BeanDeployer.hasSimpleWebBeanConstructor(clazz) && !this.isEntity(clazz);
    }

    private boolean isEntity(AnnotatedClass<?> clazz) {
        if (this.manager.getServices().contains(EntityDiscovery.class)) {
            EntityDiscovery entityDiscovery = this.manager.getServices().get(EntityDiscovery.class);
            return entityDiscovery.discoverEntitiesFromAnnotations().contains(clazz.getRawType()) || entityDiscovery.discoverEntitiesFromPersistenceUnits().contains(clazz.getRawType()) || entityDiscovery.discoverEntitiesFromXml().contains(clazz.getRawType());
        }
        return false;
    }

    private static boolean hasSimpleWebBeanConstructor(AnnotatedClass<?> type) {
        return type.getNoArgsConstructor() != null || type.getAnnotatedConstructors(Initializer.class).size() > 0;
    }

    private static <T> AnnotatedMethod<T> realizeProducerMethod(AnnotatedMethod<T> method, final AnnotatedClass<?> realizingClass) {
        return new WrappedAnnotatedMethod<T>(method, realizingClass.getMetaAnnotations(BindingType.class)){

            @Override
            public Set<Annotation> getMetaAnnotations(Class<? extends Annotation> metaAnnotationType) {
                if (metaAnnotationType.equals(DeploymentType.class)) {
                    return realizingClass.getMetaAnnotations(DeploymentType.class);
                }
                return super.getMetaAnnotations(metaAnnotationType);
            }

            @Override
            public Set<Annotation> getDeclaredMetaAnnotations(Class<? extends Annotation> metaAnnotationType) {
                if (metaAnnotationType.equals(DeploymentType.class)) {
                    return realizingClass.getDeclaredMetaAnnotations(DeploymentType.class);
                }
                return super.getDeclaredMetaAnnotations(metaAnnotationType);
            }
        };
    }

    private static <T> AnnotatedField<T> realizeProducerField(AnnotatedField<T> field, final AnnotatedClass<?> realizingClass) {
        return new WrappedAnnotatedField<T>(field, realizingClass.getMetaAnnotations(BindingType.class)){

            @Override
            public Set<Annotation> getMetaAnnotations(Class<? extends Annotation> metaAnnotationType) {
                if (metaAnnotationType.equals(DeploymentType.class)) {
                    return realizingClass.getMetaAnnotations(DeploymentType.class);
                }
                return super.getMetaAnnotations(metaAnnotationType);
            }

            @Override
            public Set<Annotation> getDeclaredMetaAnnotations(Class<? extends Annotation> metaAnnotationType) {
                if (metaAnnotationType.equals(DeploymentType.class)) {
                    return realizingClass.getDeclaredMetaAnnotations(DeploymentType.class);
                }
                return super.getDeclaredMetaAnnotations(metaAnnotationType);
            }
        };
    }
}

