/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.persistence;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.jboss.webbeans.bootstrap.api.ServiceRegistry;
import org.jboss.webbeans.bootstrap.spi.WebBeanDiscovery;
import org.jboss.webbeans.log.Log;
import org.jboss.webbeans.log.Logging;
import org.jboss.webbeans.persistence.PersistenceApiAbstraction;
import org.jboss.webbeans.persistence.spi.EntityDiscovery;
import org.jboss.webbeans.resources.spi.ResourceLoader;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultEntityDiscovery
implements EntityDiscovery {
    private static final Log log = Logging.getLog(DefaultEntityDiscovery.class);
    private final ServiceRegistry serviceRegistry;
    private Set<Class<?>> entitiesFromAnnotations;
    private Set<Class<?>> entitiesFromOrmXml;
    private Set<Class<?>> entitiesFromPersistenceXml;

    public DefaultEntityDiscovery(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public void initialize() {
        this.entitiesFromAnnotations = new HashSet();
        this.entitiesFromOrmXml = new HashSet();
        this.entitiesFromPersistenceXml = new HashSet();
        PersistenceApiAbstraction jpaApiAbstraction = this.serviceRegistry.get(PersistenceApiAbstraction.class);
        for (Class<?> clazz : this.serviceRegistry.get(WebBeanDiscovery.class).discoverWebBeanClasses()) {
            if (!clazz.isAnnotationPresent(jpaApiAbstraction.ENTITY_CLASS) && !clazz.isAnnotationPresent(jpaApiAbstraction.EMBEDDABLE_CLASS) && !clazz.isAnnotationPresent(jpaApiAbstraction.MAPPED_SUPERCLASS_CLASS)) continue;
            this.entitiesFromAnnotations.add(clazz);
        }
        for (URL url : this.serviceRegistry.get(ResourceLoader.class).getResources("META-INF/orm.xml")) {
            try {
                this.parseOrmXml(DefaultEntityDiscovery.getRootElementSafely(url));
            }
            catch (Exception e) {
                log.warn((Object)"Error parsing {0}, entities defined there will be detected as simple beans", e, url.toString());
            }
        }
    }

    private void parseOrmXml(Element root) {
        String className;
        String packagePrefix = "";
        Element pkg = root.element("package");
        if (pkg != null) {
            packagePrefix = pkg.getTextTrim() + ".";
        }
        ResourceLoader resourceLoader = this.serviceRegistry.get(ResourceLoader.class);
        for (Element entity : root.elements("entity")) {
            className = packagePrefix + entity.attribute("class").getText();
            this.entitiesFromOrmXml.add(resourceLoader.classForName(className));
        }
        for (Element entity : root.elements("mapped-superclass")) {
            className = packagePrefix + entity.attribute("class").getText();
            this.entitiesFromOrmXml.add(resourceLoader.classForName(className));
        }
    }

    @Override
    public Collection<Class<?>> discoverEntitiesFromAnnotations() {
        if (this.entitiesFromAnnotations == null) {
            this.initialize();
        }
        return Collections.unmodifiableCollection(this.entitiesFromAnnotations);
    }

    @Override
    public Collection<Class<?>> discoverEntitiesFromPersistenceUnits() {
        if (this.entitiesFromPersistenceXml == null) {
            this.initialize();
        }
        return Collections.unmodifiableCollection(this.entitiesFromPersistenceXml);
    }

    @Override
    public Collection<Class<?>> discoverEntitiesFromXml() {
        if (this.entitiesFromOrmXml == null) {
            this.initialize();
        }
        return Collections.unmodifiableCollection(this.entitiesFromOrmXml);
    }

    public static Element getRootElementSafely(URL url) throws DocumentException, IOException {
        InputStream stream = url.openStream();
        SAXReader saxReader = new SAXReader();
        saxReader.setEntityResolver(new NullEntityResolver());
        saxReader.setMergeAdjacentText(true);
        return saxReader.read(stream).getRootElement();
    }

    private static class NullEntityResolver
    implements EntityResolver {
        private static final byte[] empty = new byte[0];

        private NullEntityResolver() {
        }

        public InputSource resolveEntity(String systemId, String publicId) throws SAXException, IOException {
            return new InputSource(new ByteArrayInputStream(empty));
        }
    }
}

