/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.resources;

import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import org.jboss.webbeans.bootstrap.api.Service;
import org.jboss.webbeans.introspector.AnnotatedAnnotation;
import org.jboss.webbeans.introspector.AnnotatedClass;
import org.jboss.webbeans.introspector.jlr.AnnotatedAnnotationImpl;
import org.jboss.webbeans.introspector.jlr.AnnotatedClassImpl;
import org.jboss.webbeans.util.collections.ConcurrentCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassTransformer
implements Service {
    private final ConcurrentCache<Class<?>, AnnotatedClass<?>> classes;
    private final ConcurrentCache<Class<?>, AnnotatedAnnotation<?>> annotations;
    private final ClassTransformer transformer = this;

    public ClassTransformer() {
        this.classes = new ConcurrentCache();
        this.annotations = new ConcurrentCache();
    }

    public <T> AnnotatedClass<T> classForName(final Class<T> clazz) {
        return (AnnotatedClass)this.classes.putIfAbsent(clazz, new Callable<AnnotatedClass<T>>(){

            @Override
            public AnnotatedClass<T> call() throws Exception {
                return AnnotatedClassImpl.of(clazz, ClassTransformer.this.transformer);
            }
        });
    }

    public <T extends Annotation> AnnotatedAnnotation<T> classForName(final Class<T> clazz) {
        return (AnnotatedAnnotation)this.annotations.putIfAbsent(clazz, new Callable<AnnotatedAnnotation<T>>(){

            @Override
            public AnnotatedAnnotation<T> call() throws Exception {
                return AnnotatedAnnotationImpl.of(clazz, ClassTransformer.this.transformer);
            }
        });
    }
}

