/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.repeater.data.table.filter;

import org.apache.wicket.Component;
import org.apache.wicket.extensions.markup.html.repeater.data.table.filter.ChoiceFilter;
import org.apache.wicket.extensions.markup.html.repeater.data.table.filter.FilterForm;
import org.apache.wicket.extensions.markup.html.repeater.data.table.filter.FilteredPropertyColumn;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;

public class ChoiceFilteredPropertyColumn
extends FilteredPropertyColumn {
    private static final long serialVersionUID = 1L;
    private IModel filterChoices;

    public ChoiceFilteredPropertyColumn(IModel displayModel, String sortProperty, String propertyExpression, IModel filterChoices) {
        super(displayModel, sortProperty, propertyExpression);
        this.filterChoices = filterChoices;
    }

    public ChoiceFilteredPropertyColumn(IModel displayModel, String propertyExpression, IModel filterChoices) {
        super(displayModel, propertyExpression);
        this.filterChoices = filterChoices;
    }

    public void detach() {
        super.detach();
        if (this.filterChoices != null) {
            this.filterChoices.detach();
        }
    }

    public Component getFilter(String componentId, FilterForm form) {
        ChoiceFilter filter = new ChoiceFilter(componentId, this.getFilterModel(form), form, this.filterChoices, this.enableAutoSubmit());
        IChoiceRenderer renderer = this.getChoiceRenderer();
        if (renderer != null) {
            filter.getChoice().setChoiceRenderer(renderer);
        }
        return filter;
    }

    protected IModel getFilterModel(FilterForm form) {
        return new PropertyModel((Object)form.getModel(), this.getPropertyExpression());
    }

    protected boolean enableAutoSubmit() {
        return true;
    }

    protected IChoiceRenderer getChoiceRenderer() {
        return null;
    }

    protected final IModel getFilterChoices() {
        return this.filterChoices;
    }
}

