/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */
 package jp.sourceforge.manganetwork.page;

import org.apache.wicket.markup.html.link.PageLink;

public class MenuApplicationPage extends ApplicationPage {

	public MenuApplicationPage()
	{
		PageLink loginLink = createPageLink("loginLink", HomePage.class);
		PageLink logoutLink = createPageLink("logoutLink", HomePage.class);
		if (getLoginUser() != null)
		{
			loginLink.setVisible(false);
			logoutLink.setVisible(true);
		}
		else
		{
			loginLink.setVisible(true);
			logoutLink.setVisible(false);
		}
		
		add(loginLink);
		add(logoutLink);
	}

	private PageLink createPageLink(String id, Class pageClass) {
		return new PageLink(id, pageClass);
	}
}
