/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.stat.descriptive;

import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.stat.descriptive.UnivariateStatistic;

public abstract class AbstractUnivariateStatistic
implements UnivariateStatistic {
    public double evaluate(double[] values) {
        this.test(values, 0, 0);
        return this.evaluate(values, 0, values.length);
    }

    public abstract double evaluate(double[] var1, int var2, int var3);

    public abstract UnivariateStatistic copy();

    protected boolean test(double[] values, int begin, int length) {
        if (values == null) {
            throw MathRuntimeException.createIllegalArgumentException("input values array is null", new Object[0]);
        }
        if (begin < 0) {
            throw MathRuntimeException.createIllegalArgumentException("start position cannot be negative ({0})", begin);
        }
        if (length < 0) {
            throw MathRuntimeException.createIllegalArgumentException("length cannot be negative ({0})", length);
        }
        if (begin + length > values.length) {
            throw MathRuntimeException.createIllegalArgumentException("subarray ends after array end", new Object[0]);
        }
        return length != 0;
    }
}

