/****************************************************************************
    BSch3V schematic capture
    Copyright (C) 1997-2005 H.Okada

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/

// BSchDoc.cpp : CBSchDoc NX̓̒`s܂B
//

#include "stdafx.h"

#include <stdio.h>
#include <assert.h>
#include <string>
#include <list>
using namespace std;


#include <memory.h>
#include "BSch.h"


//#include "xbschdoc.h"
//#include "xbschdocsch.h"
#include "BSchDoc.h"

//#include "PartLib.h"
#include "BSchFont.h"
#include "Global.h"
#include "MainFrm.h"

//#include "ReadERC.h"



#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CBSchDoc

IMPLEMENT_DYNCREATE(CBSchDoc, CDocument)

BEGIN_MESSAGE_MAP(CBSchDoc, CDocument)
	//{{AFX_MSG_MAP(CBSchDoc)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CBSchDoc NX̍\z/

CBSchDoc::CBSchDoc()
{
	// TODO: ̈ʒuɂP񂾂\zp̃R[hǉĂB
//	m_nTopData		=0;
//	m_nDataDepth	=0;
//	m_fTmpData		=0;
	//m_bSelectForDrag=FALSE;
	SetSheetSize(1,0,0);	//1997/02/03
//	m_wShowLayer	=0xFF;  //1998/06/27
//	m_nEditLayer	=0;		//1998/06/27
//	m_fEditHighLight=FALSE;	//1998/06/29
	// INIt@CɂO[oϐ̏
	bool bTidyUp = (AfxGetApp()->GetProfileInt("Option","AutoCorrect",1) ? true : false);
	AfxGetApp()->WriteProfileInt("Option","AutoCorrect",(bTidyUp?1:0));
	setTidyUpEnable(bTidyUp);
}

CBSchDoc::~CBSchDoc()
{
}

BOOL CBSchDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;

	// TODO: ̈ʒuɍďǉĂB
	// (SDI hLg͂̃hLgėp܂B)
	// SetSheetSize(1);
	CSize sz;
	IniReadSheetSize(&sz);
	SetSheetSize(-1,sz.cx,sz.cy);//}ʃTCYWXg瓾
	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CBSchDoc VAC[[V

void CBSchDoc::Serialize(CArchive& ar)
{
//	CFile* pf;
	if (ar.IsStoring())
	{
//		// TODO: ̈ʒuɕۑp̃R[hǉĂB
//		ar.Flush();
//		pf=ar.GetFile();
//		WriteCE2(pf);
//		pf->Flush();
//		DeleteContents();
//		pf->SeekToBegin();
//		ReadCE2(pf);
//		UpdateAllViews(NULL);
	}
	else
	{
		// TODO: ̈ʒuɓǂݍݗp̃R[hǉĂB
//		ar.Flush();
//		pf=ar.GetFile();
//		ReadCE2(pf);
	}
}



/////////////////////////////////////////////////////////////////////////////
// CBSchDoc NX̐ff

#ifdef _DEBUG
void CBSchDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CBSchDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CBSchDoc R}h

//}ʃTCY̔z
SIZE CBSchDoc::m_tablesizeSheet[MAX_SHEETSIZE]={ 640, 400,
												1000, 750,
												1550,1050,
												2250,1550,
												3250,2250};



////No operation in Qt-BSch
//void CBSchDoc::IncrementDataDepth()
//{
//}

//WXg}ʃTCY𓾂
//int  CBSchDoc::IniReadSheetSize()
//{
//	return AfxGetApp()->GetProfileInt("Option","SheetSize",1);
//}

//WXg}ʃTCY𓾂
void  CBSchDoc::IniReadSheetSize(CSize* psize)
{
	psize->cx = AfxGetApp()->GetProfileInt("Option","SheetSizeX",0);
	psize->cy = AfxGetApp()->GetProfileInt("Option","SheetSizeY",0);

	if(psize->cx < SHEETSIZE_X_MIN) psize->cx=SHEETSIZE_X_MIN;
	else if(psize->cx > SHEETSIZE_X_MAX) psize->cx=SHEETSIZE_X_MAX;
	if(psize->cy < SHEETSIZE_Y_MIN) psize->cy=SHEETSIZE_Y_MIN;
	else if(psize->cy > SHEETSIZE_Y_MAX) psize->cy= SHEETSIZE_Y_MAX;
}


//WXgɐ}ʃTCY
//void CBSchDoc::IniWriteSheetSize(int nSize)
//{
//	AfxGetApp()->WriteProfileInt("Option","SheetSize",nSize);
//}

//WXgɐ}ʃTCY
void CBSchDoc::IniWriteSheetSize(CSize* pSize)
{
	AfxGetApp()->WriteProfileInt("Option","SheetSizeX",pSize->cx);
	AfxGetApp()->WriteProfileInt("Option","SheetSizeY",pSize->cy);
}

//ꎞf[^̌_Ԃ
CPoint CBSchDoc::GetTmpOrigin()
{
	SPoint pt = xbschdocsch.tempSnapPoint();
	return CPoint(pt.x(),pt.y());
}

//ꎞf[^̐L͈͂Ԃ
CRect CBSchDoc::GetTmpRect()
{
	SRect rc= xbschdocsch.tempArea();
	return CRect(rc.l(),rc.t(),rc.r(),rc.b());
}

//IԂ̉
void CBSchDoc::FixSelection(int option)
{
	if(xbschdocsch.resetSelect(option)){
		SetModifiedFlag(TRUE);
	}
}	

//`͈͂ł̑I
//w肵`͈͂Ɉ̂obNAbvXgɈړāAɈꎞf[^ɕʂ
int CBSchDoc::SetSel(CRect* prc,SelectOption& refSelOption)
{
	SRect rect(prc->left,prc->top,prc->Width(),prc->Height());
	return xbschdocsch.select(rect,refSelOption);
}

//_wł̑I
//SetSel(CRect*)ƈāAudȂĂxvł傫̈I
int CBSchDoc::SetSel(CPoint* pp,SelectOption& refSelOption)
{
	SPoint point(pp->x,pp->y);
	return xbschdocsch.select(point,refSelOption);
}

//`͈͂ł̃hbO[hI
int CBSchDoc::SetDrag(CRect* prc,bool bCutOffPinWire)
{
	SRect rect(prc->left,prc->top,prc->Width(),prc->Height());
	return xbschdocsch.selectForDrag(rect,bCutOffPinWire);
}


//_wł̃hbO[hI
int CBSchDoc::SetDrag(CPoint* pp,bool bCutOffPinWire)
{
	CRect rc;
	rc.left  =pp->x-2;
	rc.top   =pp->y-2;
	rc.right =pp->x+2;
	rc.bottom=pp->y+2;
	
	return SetDrag(&rc,bCutOffPinWire);
}
	

//ꎞf[^̃Xg𓾂
XBSchObjList* CBSchDoc::GetTmpList()
{
	return &xbschdocsch.m_listTemp;
}

//ꎞf[^P}ʃIuWFNĝƂAԂ
SXBSchObj* CBSchDoc::GetTmp()
{
	if(GetTmpDataCount()==1){
		XBSchObjListIterator pObjIte = xbschdocsch.m_listTemp.begin();
		return *pObjIte;
	}else{ 
		return NULL;
	}
}

//w肵_ꎞf[^̏ォǂ
//hbO[hłȂPf[^̏ꍇ́A}ʃIuWFNgInAreaPoint()g
int CBSchDoc::IsOnTmpData(CPoint* pp,int nOption,SXBSchObj** ppObj,int* pRetOption)
{
	return xbschdocsch.isOnTempData(SPoint(pp->x,pp->y),nOption,ppObj,pRetOption);
}

//y[Xg
//̎菇ŃNbv{[h̃f[^𓾂
// 1.Nbv{[h烁ubN𓾂
// 2.̃ubN CMemFile
// 3.ReadCE2sB
void CBSchDoc::Paste(CPoint* pOrigin)
{
	SPoint pt(pOrigin->x,pOrigin->y);
	xbschdocsch.paste(pt);
	// >>> 2005/01/30 y[Xgf[^tBbNXꂽƂSetModifiedFlag()悤ɕύX
    //		SetModifiedFlag(TRUE);
	//		xbschdocsch.setDirty(true);
	// <<< 2005/01/30
}

//Rs[
void CBSchDoc::Copy()
{
	xbschdocsch.copy();
	//SetModifiedFlag(TRUE);
}

//Jbg
void CBSchDoc::Cut()
{
	Copy();
	Clear();
}


//NA
void CBSchDoc::Clear()
{
	if(xbschdocsch.del()){
		SetModifiedFlag(TRUE);
	}
	// >>> 2005/01/30
	//     _[eBtO̐ݒ xbschdocsch.del()̒ōs悤ɕύX
	//	xbschdocsch.setDirty(true);
	// <<< 2005/01/30
}

//AhD
void CBSchDoc::Undo()
{
	xbschdocsch.undo();
}

bool CBSchDoc::Redo()
{
	return xbschdocsch.redo();
}


//]
//ꎞf[^Pf[^ŁAAEditFlagENABLE_ROTATELłƂ
void CBSchDoc::Rotate()
{
	xbschdocsch.rotate();
	// >>> 2005/01/30 
	//	f[^tBbNXꂽƂSetModifiedFlag()悤ɕύX
	//  _[eBtOݒxbschdocsch.rotate()ōs
	//SetModifiedFlag(TRUE);
	//xbschdocsch.setDirty(true);
	// <<< 2005/01/30
}


//E]
//ꎞf[^Pf[^ŁAAEditFlagENABLE_MIRRORLłƂ
void CBSchDoc::Mirror()
{
	xbschdocsch.mirror();
	// >>> 2005/01/30 
	//	f[^tBbNXꂽƂSetModifiedFlag()悤ɕύX
	//  _[eBtOݒxbschdocsch.mirror()ōs
	//SetModifiedFlag(TRUE);
	//xbschdocsch.setDirty(true);
	// <<< 2005/01/30
}

//ړ
// CPoint*
//ꎞf[^ړ
//ړAꎞf[^̃_[eBtOZbgB
void CBSchDoc::Shift(CPoint* pOrigin)
{
	xbschdocsch.moveTempData(pOrigin->x,pOrigin->y);
	// >>> 2005/01/30 
	//	f[^tBbNXꂽƂSetModifiedFlag()悤ɕύX
	//  _[eBtOݒxbschdocsch.moveTempData()ōs
	//SetModifiedFlag(TRUE);
	//xbschdocsch.setDirty(true);
	// <<< 2005/01/30
}

//ړ
// Csize*
void CBSchDoc::Shift(CSize*  psizeOffset)
{
	xbschdocsch.moveTempData(psizeOffset->cx,psizeOffset->cy);
	// >>> 2005/01/30 
	//	f[^tBbNXꂽƂSetModifiedFlag()悤ɕύX
	//  _[eBtOݒxbschdocsch.moveTempData()ōs
	//SetModifiedFlag(TRUE);
	//xbschdocsch.setDirty(true);
	// <<< 2005/01/30
}



//_[eBtOZbg
void CBSchDoc::SetDirty()
{
	SetModifiedFlag(TRUE);
	xbschdocsch.setDirty(true);
}

//ꎞf[^̃_[eBtOZbg
void CBSchDoc::SetTempDirty()
{
	// >>> 2005/01/30
	//	f[^tBbNXꂽƂSetModifiedFlag()悤ɕύX
	//	SetModifiedFlag(TRUE);
	// <<< 2005/01/30
	xbschdocsch.setTempDirty(true);
}


//f[^󂩂ǂԂ
BOOL CBSchDoc::IsEmpty()
{
	return xbschdocsch.isEmpty();
}

//Iꂽ݂̂邩ǂ
//m_fTmpDatâATMPDATA_NEW܂TMPDATA_MOVED̃rbgĂāA
//                  TMPDATA_FOR_DRAG̃rbgOFF
BOOL CBSchDoc::CanEdit()
{
	return xbschdocsch.canCopy();
}

//y[Xg\ǂ
//BSchƎtH[}bg̃f[^Nbv{[hɑ݂Ή\ƂB
BOOL CBSchDoc::CanPaste()
{
	return xbschdocsch.canPaste();
}

//AhD\ǂ
//m_nDataDepth 1 ȏȂ\B
//m_nDataDepth 0 łꎞf[^LȂ\B
BOOL CBSchDoc::CanUndo()
{
	return xbschdocsch.canUndo();
}

BOOL CBSchDoc::CanRedo()
{
	return xbschdocsch.canRedo();
}


//Agr[g̕ύX\ǂ
//ꎞf[^Pf[^ŁAAEditFlagENABLE_ATTRIBUTELłƂ
BOOL CBSchDoc::CanAttribute()
{
	return xbschdocsch.canAttribute();
}

//]\ǂ
//ꎞf[^Pf[^ŁAAEditFlagENABLE_ROTATELłƂ
BOOL CBSchDoc::CanRotate()
{
	return xbschdocsch.canRotate();
}

//E]\ǂ
//ꎞf[^Pf[^ŁAAEditFlagENABLE_MIRRORLłƂ
BOOL CBSchDoc::CanMirror()
{
	return xbschdocsch.canMirror();
}

//_̕ҏW\
BOOL CBSchDoc::CanEditPoints()
{
	return xbschdocsch.canEditPoints();
}

//̕ύX\H
BOOL CBSchDoc::CanChangeOrder()
{
	return xbschdocsch.canChangeOrder();
}


//ǔv\ǂ
BOOL CBSchDoc::CanFindNext()
{
	return xbschdocsch.canFindNext();
}

const SXBSchObj* CBSchDoc::FindStart(const char* sz,bool bMatchWhole,bool bCaseSensitive,unsigned int targetFlags,bool selectWhenFound)
{
	return xbschdocsch.findStart(sz,bMatchWhole,bCaseSensitive,targetFlags,selectWhenFound);
}

//i1PƂőIĂ邩
const SXBSchComponent* CBSchDoc::isComponentSelectedSingly()
{
	return xbschdocsch.isComponentSelectedSingly();
}

//J[\ȉɂ邩ǂ
const SXBSchComponent* CBSchDoc::isOnComponent(CPoint *pp)
{
	SPoint point(pp->x,pp->y);
	return xbschdocsch.isOnComponent(point);
}





const SXBSchObj* CBSchDoc::Find()
{
	return xbschdocsch.find(false);
}

void CBSchDoc::GetFoundText(CString& str)
{
	str = xbschdocsch.m_foundString.c_str();
}


//}ʃIuWFNg̉ǉ
BOOL CBSchDoc::AddData(SXBSchObj* pObj)
{
	xbschdocsch.addSelect(pObj);
	// >>> 2005/01/30
	//	y[Xgf[^tBbNXꂽƂSetModifiedFlag()悤ɕύX
	//	SetModifiedFlag(TRUE);
	// <<< 2005/01/30
	//xbschdocsch.setDirty(true);
	return TRUE;
}

//擪nڂ̃f[^̃Xgւ̃|C^𓾂
//nLȃCf[^̐zĂNULLԂ
XBSchObjList* CBSchDoc::GetMainData(int /* =0*/)
{
	return &xbschdocsch.m_listMain;
}

//}ʃTCYԍŃZbg
void CBSchDoc::SetSheetSize(int n, int w, int h)
{
	if(w < SHEETSIZE_X_MIN) w=SHEETSIZE_X_MIN;
	else if(w > SHEETSIZE_X_MAX) w=SHEETSIZE_X_MAX;
	if(h < SHEETSIZE_Y_MIN) h=SHEETSIZE_Y_MIN;
	else if(h > SHEETSIZE_Y_MAX) h=SHEETSIZE_Y_MAX;

	
	if(n<0 || n>=MAX_SHEETSIZE){//͈͊OȂ0ɂ
		//TRACE("\nRange error (CBSchDoc::SetSheetSize)");//DEBUG[hŃbZ[W
		xbschdocsch.SetSheetSize(SSize(w,h));
	}else{
		xbschdocsch.SetSheetSize(SSize(m_tablesizeSheet[n].cx,m_tablesizeSheet[n].cy));
	}
	SetModifiedFlag(TRUE);
	//xbschdocsch.setDirty(true);
}


//}ʃTCYԂ
CSize CBSchDoc::GetSheetSize()
{
	SSize sz=xbschdocsch.SheetSize();
	return CSize(sz.w(),sz.h());
}

//}ʃTCYԂ
int	CBSchDoc::GetSheetSizeIndex()
{
	SSize sz=xbschdocsch.SheetSize();
	for(int i=0;i<MAX_SHEETSIZE;i++){
		SIZE ssz = m_tablesizeSheet[i];
		if(sz.w() == ssz.cx && sz.h() == ssz.cy) return i;
	}
	return -1;
}


//f[^̑S
//AvP[Vt[[N玟̏ꍇɌĂяo
//			VK쐬
//			t@Cǂݍ
//			vȌI
//Cf[^̃XgɊ܂܂邷ׂẴf[^DeleteB
//m_nTopDatam_nDataDepthZbgB
void CBSchDoc::DeleteContents() 
{
	// TODO: ̈ʒuɌŗL̏ǉ邩A܂͊{NXĂяoĂ
	xbschdocsch.init();
	SetModifiedFlag(FALSE);
	//CDocument::DeleteContents();	//{NX͉ȂAB
}


//C[̈ړ
void CBSchDoc::MoveLayer(int nLayer)
{
	xbschdocsch.moveToLayer(nLayer);
}



BOOL CBSchDoc::OnSaveDocument(LPCTSTR lpszPathName) 
{
	// TODO: ̈ʒuɌŗL̏ǉ邩A܂͊{NXĂяoĂ
	int result = xbschdocsch.writeFile(lpszPathName);
	if(result==0){
		SetModifiedFlag(FALSE);
		if(g_bDisplayNcPinMark) setNcPinFlag();
		UpdateAllViews(NULL);
		return TRUE;
	}else{
		return FALSE;
	}
	//return CDocument::OnSaveDocument(lpszPathName);
}

BOOL CBSchDoc::ReloadFile()
{
	BOOL result = OnOpenDocument(m_strPathName);
	UpdateAllViews(NULL);
	return result;
}

BOOL CBSchDoc::OnOpenDocument(LPCTSTR lpszPathName) 
{
	CWnd* pWndOpened=((CMainFrame*)AfxGetMainWnd())->CheckOpened(lpszPathName);
	if(pWndOpened){
		if(pWndOpened->IsIconic()){
			pWndOpened->ShowWindow(SW_RESTORE);
		}
		pWndOpened->SetForegroundWindow();
		AfxGetMainWnd()->PostMessage(WM_CLOSE);
		return TRUE;
	}

	//DeleteContents();
	int result = xbschdocsch.readFile(lpszPathName);
	if(result==0){
		SetModifiedFlag(FALSE);
		if(g_bDisplayNcPinMark) setNcPinFlag();
		if(xbschdocsch.createdLatestVersion()){
			AfxMessageBox(IDS_LATERVERSION,MB_ICONEXCLAMATION,MB_OK);
		}
		return TRUE;
	}else{
		return FALSE;
	}
		
//	if (!CDocument::OnOpenDocument(lpszPathName))
//		return FALSE;
	
	// TODO: ̈ʒuɌŗL̍쐬pR[hǉĂ
	
	//return TRUE;
}

BOOL CBSchDoc::IsModified()
{
	return xbschdocsch.isDirty();
}
