/****************************************************************************
    BSch3V schematic capture
    Copyright (C) 1997-2005 H.Okada

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/

// BSchDoc.h : CBSchDoc NX̐錾уC^[tFCX̒`܂B
//
/////////////////////////////////////////////////////////////////////////////
#ifndef BSCHDOC_H
#define BSCHDOC_H

#include "xbschdoc.h"
#include "xbschdocsch.h"

#define	MAX_MAINDATA	1	//Cf[^̐


//m_fTmpData̒l
//TMPDATA_SQAREA  TMPDATA_SINGLE	͔rI
//TMPDATA_MOVED   TMPDATA_NEW		͔rI	
#define	TMPDATA_SQAREA	1	//ꎞf[^͋`͈͂
#define	TMPDATA_SINGLE	2	//ꎞf[^͒P}ʃIuWFNg
#define	TMPDATA_MOVED	4	//ꎞf[^m_listMainDataړ
#define	TMPDATA_NEW		8	//ꎞf[^͐VKzuf[^
#define TMPDATA_DIRTY	16	//ꎞf[^ݒAړ]Ȃǂ̑s
#define TMPDATA_FOR_DRAG 32 //ꎞf[^̓hbÔ߂̂
#define TMPDATA_NO_FRAME 64 //ꎞf[^̕`̍ۂɓ_g\Ȃ
			
//IsOnTmpData()̕Ԓl
//#define ONTMPDATA		1	//w肵_͈ꎞf[^̏
//#define ONTMPDATA_NAME	2	//w肵_͕ȉ
//#define ONTMPDATA_NUM	4	//w肵_͕iԍ̏



#include "xbschdocsch.h"

class CBSchDoc : public CDocument
{
protected: // VACY@\݂̂쐬܂B
	CBSchDoc();
	DECLARE_DYNCREATE(CBSchDoc)

//////////////////////////////////////////////////////////////////
// vCx[gϐ
private:

	SXBSchDocSch xbschdocsch;
	static SIZE m_tablesizeSheet[MAX_SHEETSIZE];

public:
	//C[Ɋւ
	//WORD		m_wShowLayer;
	//int			m_nEditLayer;
	//BOOL		m_fEditHighLight;

	unsigned int visibleLayer(){return xbschdocsch.visibleLayer();}
	void setVisibleLayer(unsigned int n){xbschdocsch.setVisibleLayer(n);}
	int editLayer(){return xbschdocsch.editLayer();}
	void setEditLayer(int n){xbschdocsch.setEditLayer(n);}
	void setNcPinFlag(){xbschdocsch.setNcPinFlag();}

public:
	void setTotalPages(int n){xbschdocsch.setTotalPages(n);}
	void setPage(int n){xbschdocsch.setPage(n);}
	void setProjectName(const char* psz){xbschdocsch.setProjectName(psz);}
	void setInitPos(int n){xbschdocsch.setInitPos(n);}
	
	int totalPages(){return xbschdocsch.totalPages();}
	int page(){return xbschdocsch.page();}
	const char* projectName(){return xbschdocsch.projectName();}
	int dataVersion(){return xbschdocsch.dataVersion();}
	int initPos(){return xbschdocsch.initPos();}



private:


// Iy[V
public:
//	void	IncrementDataDepth();	//Lm_listMainData̐̃CNg
//									//ő吔ɂȂÂf[^̓ōs
	void	FixSelection(int option);			//Ỉ
	int		SetSel(CRect* prc,SelectOption& refSelOption);		//`͈͂ł̑I
	int		SetSel(CPoint* pp,SelectOption& refSelOption);		//_wł̑I
	int		SetDrag(CRect* prc,bool bCutOffPinWire);	//`͈͂ł̃hbO[hI
	int		SetDrag(CPoint* pp,bool bCutOffPinWire);	//_wł̃hbO[hI
	bool	isSelectedForDtag(){return xbschdocsch.isSelectedForDtag();}
	int		GetTmpDataCount(){return xbschdocsch.m_listTemp.size();} //ꎞf[^̐ԂB

//	UINT	GetTmpDataFlag(){return m_fTmpData;}//݂̈ꎞf[^̎ʃtOԂ
	XBSchObjList* GetTmpList();			//ꎞf[^̃Xg𓾂
	SXBSchObj* GetTmp();				//ꎞf[^P}ʃIuWFNĝƂAԂ
	CPoint  GetTmpOrigin();				//ꎞf[^̌_Ԃ
	CRect	GetTmpRect();				//ꎞf[^̐L͈͂Ԃ
	//void 	SetTmpRect(CRect* prc){m_rcTmpData=*prc;}	//ꎞf[^̐L͈͊Oݒ肷
	int		IsOnTmpData(CPoint* pp,int nOption,SXBSchObj** ppObj,int* pRetOption);//w肵_ꎞf[^̏ォǂ

	BOOL	IsEmpty();				//f[^󂩂ǂԂ
	void	Paste(CPoint* pOrigin); //y[Xg
	void	Cut();					//Jbg
	void	Copy();					//Rs[
	void	Clear();				//NA
	void	Undo();					//AhD
	bool	Redo();					//AhD
	void	Rotate();				//]
	void	Mirror();				//E]
	void	Shift(CPoint* pOrigin);	//ړ
	void	Shift(CSize*  psizeOffset);	//ړ
//	BOOL	DoAttributeDialog();	//Agr[gύX_CAŐN
	void	SetDirty();				//_[eBtOZbg
	void	SetTempDirty();				//ꎞf[^̃_[eBtOZbg
	BOOL	CanEdit();				//Iꂽ݂̂邩ǂ
	BOOL	CanPaste();				//y[Xg\ǂ
	BOOL	CanUndo();				//AhD\ǂ
	BOOL	CanRedo();				//AhD\ǂ
	BOOL	CanAttribute();			//Agr[g̕ύX\ǂ
	BOOL	CanRotate();			//]\ǂ
	BOOL	CanMirror();			//E]\ǂ
	BOOL	CanEditPoints();		//_̕ҏW\
	BOOL	CanChangeOrder();		//̕ύX\H

	//i1PƂőIĂ邩
	const SXBSchComponent* isComponentSelectedSingly();

	//J[\ȉɂ邩ǂ
	const SXBSchComponent* isOnComponent(CPoint *pp);


	//p[cIĂ邩
	bool isComponentSelected(){return xbschdocsch.isComponentSelected();}
	//}[J[CIĂ邩
	bool isMarkerlineSelected(){return xbschdocsch.isMarkerlineSelected();}
	//^OIĂ邩
	bool isTagSelected(){return xbschdocsch.isTagSelected();}
	//xIĂ邩
	bool isLabelSelected(){return xbschdocsch.isLabelSelected();}
	//RgIĂ邩
	bool isCommentSelected(){return xbschdocsch.isCommentSelected();}




	//܂͂͂炯B̋@\Q𗬗pB
	BOOL	CanFindNext();			//ǔv\ǂ
	const SXBSchObj* FindStart(const char* sz,bool bMatchWhole,bool bCaseSensitive,unsigned int targetFlags,bool selectWhenFound);
	const SXBSchObj* Find();
	void GetFoundText(CString& str);
	unsigned int GetFountType(){ return xbschdocsch.m_foundType;}
	SPoint GetFoundPoint(){ return xbschdocsch.m_foundPoint;}



	void setTidyUpEnable(bool en){xbschdocsch.m_bDoTidyUp = en;}
	bool tidyUp(){return xbschdocsch.m_bDoTidyUp;}

	//oNAgr[g i̒u
	void bulkAttributeReplaceComponentInfo(const SCompIndex* pPartIndex){xbschdocsch.bulkAttributeReplaceComponentInfo(pPartIndex);}

	//oNAgr[g i̔\ݒ
	void bulkAttributeHideComponentVal(bool hide){xbschdocsch.bulkAttributeHideComponentVal(hide);}

	//oNAgr[g iԍ̔\ݒ
	void bulkAttributeHideComponentNum(bool hide){xbschdocsch.bulkAttributeHideComponentNum(hide);}

	//oNAgr[g RgtHg̕ύX
	void bulkAttributeCommentFont(SXBSchComment& refComment){xbschdocsch.bulkAttributeCommentFont(refComment);}

	//oNAgr[g }[J[C̕ύX
	void bulkAttributeMarkerLine(int width,unsigned nColor){xbschdocsch.bulkAttributeMarkerLine(width,nColor);}

	//oNAgr[g ^Og̕ύX
	void bulkAttributeChangeTagFrameTo(int n){xbschdocsch.bulkAttributeChangeTagFrameTo(n);}

	//Rgxɕϊ
	void bulkConvertComment2Label(){xbschdocsch.bulkConvertComment2Label();}

	//Rgxɕϊ
	void bulkConvertComment2Tag(){xbschdocsch.bulkConvertComment2Tag();}

	//x^Oɕϊ
	void bulkConvertLabel2Tag(){xbschdocsch.bulkConvertLabel2Tag();}

	//xRgɕϊ
	void bulkConvertLabel2Comment(){xbschdocsch.bulkConvertLabel2Comment();}

	//^Oxɕϊ
	void bulkConvertTag2Label(){xbschdocsch.bulkConvertTag2Label();}

	//^ORgɕϊ
	void bulkConvertTag2Comment(){xbschdocsch.bulkConvertTag2Comment();}







	int		opCount(){return xbschdocsch.opCount();}

	BOOL	AddData(SXBSchObj* pObj);//}ʃIuWFNg̉ǉ
	XBSchObjList* GetMainData(int n=0);	//擪nڂ̃f[^̃Xgւ̃|C^𓾂
	

	void	SetSheetSize(int n,int w,int h);	//}ʃTCYԍŃZbg
	CSize	GetSheetSize();//}ʃTCYԂ
	int		GetSheetSizeIndex();//}ʃTCYԂ

	//WXg}ʃTCY𓾂
	void  IniReadSheetSize(CSize* psize);
	//int		IniReadSheetSize();		//WXg}ʃTCY𓾂
	//void	IniWriteSheetSize(int nSize);//WXgɐ}ʃTCY
	//WXgɐ}ʃTCY
	void IniWriteSheetSize(CSize* pSize);

	void	MoveLayer(int nLayer);	//C[̈ړ
	void	setupRcTempArea(){xbschdocsch.setupRcTempArea();}

	BOOL SaveFile(){return DoFileSave();}	//2005/10/16
	BOOL ReloadFile();

//	void	setPointTmpData(CPoint& point){m_pointTmpData=point;}

//I[o[Ch
	// ClassWizard ͉z֐𐶐I[o[Ch܂B
	//{{AFX_VIRTUAL(CBSchDoc)
	public:
	virtual BOOL OnNewDocument();
	virtual void Serialize(CArchive& ar);
	virtual void DeleteContents();
	virtual BOOL OnSaveDocument(LPCTSTR lpszPathName);
	virtual BOOL OnOpenDocument(LPCTSTR lpszPathName);
	//}}AFX_VIRTUAL

// Cve[V
public:
	virtual ~CBSchDoc();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:
public:
	BOOL IsModified();

// ꂽbZ[W }bv֐
protected:
	//{{AFX_MSG(CBSchDoc)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

#endif
