/****************************************************************************
    BSch3V schematic capture
    Copyright (C) 1997-2005 H.Okada

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/

///////////////////////////////////////////////////////////
// BSch̃tHgNX̃Cvg

#include "stdafx.h"
#include "BSch.h"
#include "BSchFont.h"
//#include "complib.h"
#include "Global.h"
#include <assert.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//extern bool g_bIsWin9x;


////////////////////////////////////////////////////////////////////////////////
// CBSchFont ̃RXgN^
CBSchFont::CBSchFont()
{
	//Init88Font();
	//InitWinFont();
	//m_pBmpBit=new unsigned char [4096];
	m_pFontH = NULL;
	m_pFontV = NULL;
	m_VExt =-1;
	m_WExt =-1;
}

////////////////////////////////////////////////////////////////////////////////
// CBSchFont ̃fXgN^
CBSchFont::~CBSchFont()
{
	delete m_pFontH;
	delete m_pFontV;
//	delete[]pFont88v;
//	delete[]m_pBmpBit;
}



LOGFONT CBSchFont::logfont()
{
	return m_logfont;
}

void  CBSchFont::setLogFont(LOGFONT lf)
{
	m_logfont = lf;
	m_VExt =-1;
	m_WExt =-1;
}



//	BSch̃x̕`
//  \̃Y[ɑΉ邽߁AO[oϐ g_nVExtAg_nWExt QƂĂ
//  kEg\(nVExt!=nWExt)̂Ƃ͕񑊓̕lp`ŕ\B
//      *BSchł͊g\T|[gĂȂB
CSize CBSchFont::PutFont(	
		CDC* pDC,						//o͐̃foCXReLXg
		int x,int y,					//o͈ʒu
		LPCSTR lpstr,					//o͕
		int nStrLen		/* =-1		*/,	//
		COLORREF col	/* =RGB(255,255,255) */,	//o͐F
		UINT nMode		/* =DRAW_ON */,	//`惂[h
		BOOL bVert		/* =FALSE 	*/,	//tO
		int  nPointPos	/* =0  		*/,	//w肵o͈ʒu 0:̑O 1:̌ 2:̒
										//					 0:̉ 4:̏   8:̒
		int  nVExt		/* =1		*/,	//\{(View)
		int  nWExt		/* =1		*/,//\{(Window)
		BOOL  bUseUpperLine	/* =TRUE */)	//̎gp

{
	COLORREF colOldText;//,colOldBk;
	CSize size,sizeLog;
	int      nOldBkMode;
	CFont *pFont;
	char buff[1024];

	bool upperLine=false;
	const char *pch;
	char ch;
	if(nStrLen<0)nStrLen = strlen(lpstr);
	if(nStrLen>1024 || nStrLen<0){
		nStrLen=1024;
	}
	if(bUseUpperLine){
		for(pch = lpstr,m_nStrLen = 0; *pch !='\0' && m_nStrLen<nStrLen;pch++, m_nStrLen++){
			ch = *pch;
			if(ch & 0x80){
				upperLine = true;
				ch &= 0x7f;
			}
			if(ch<0x20 || ch>0x7e) ch = ' ';
			buff[m_nStrLen]=ch;
		}
		buff[m_nStrLen]='\0';
	}else{
		for(pch = lpstr,m_nStrLen = 0; *pch !='\0' && m_nStrLen<nStrLen;pch++, m_nStrLen++){
			buff[m_nStrLen]=*pch;
		}
		buff[m_nStrLen]='\0';
		//TRACE("notUL %s\n",buff);
	}

	


//	if(nStrLen<0) m_nStrLen=lstrlen(lpstr);		//񒷂̐ݒ
//	else		  m_nStrLen=nStrLen;
	if(m_nStrLen==0) return CSize(0,0);		//񒷂OȂ牽Ȃ
//	if(m_nStrLen>255) m_nStrLen=255;//񒷂͍ő255
	



	if(nVExt != m_VExt || nWExt != m_WExt||m_pFontH==NULL||m_pFontV==NULL){
		delete m_pFontH;
		delete m_pFontV;
		m_pFontH = new CFont;
		m_pFontV = new CFont;
		LOGFONT lf = m_logfont;
		if(lf.lfHeight>0) lf.lfHeight = -lf.lfHeight;
		lf.lfOutPrecision = OUT_TT_ONLY_PRECIS;	
		lf.lfHeight = lf.lfHeight*nVExt/nWExt;
		lf.lfCharSet=DEFAULT_CHARSET;
		m_pFontH->CreateFontIndirect(&lf);	//tHgNX̏
		lf.lfEscapement = 900;
		lf.lfOrientation = 900;
		m_pFontV->CreateFontIndirect(&lf);	//tHgNX̏
		m_VExt = nVExt;
		m_WExt = nWExt;
		if(bVert){
			pFont=pDC->SelectObject(m_pFontV);			//tHg̑I
		}else{
			pFont=pDC->SelectObject(m_pFontH);			//tHg̑I
		}
		TEXTMETRIC tm;
		pDC->GetTextMetrics(&tm);
		m_vOffset = tm.tmHeight - tm.tmDescent;
	}else{
		if(bVert){
			pFont=pDC->SelectObject(m_pFontV);			//tHg̑I
		}else{
			pFont=pDC->SelectObject(m_pFontH);			//tHg̑I
		}
	}

	size=pDC->GetTextExtent(buff,m_nStrLen);			//`TCY𓾂
	x=x*nVExt/nWExt;
	y=y*nVExt/nWExt;

	int nPointPosH = nPointPos&3;
	int nPointPosV = (nPointPos>>2)&3;
	int vOffset;
	if(nPointPosV == 0){
		vOffset = m_vOffset;
	}else if(nPointPosV == 1){
		vOffset = 0;
	}else{
		vOffset = m_vOffset/2;
	}

	
	if(bVert){
		x-=vOffset;
		if(nPointPosH == 1){
			y+=size.cx;
		}else if(nPointPosH == 2){
			y+=size.cx/2;
		}
	}else{
		y-=vOffset;
		if(nPointPosH == 1){
			x-=size.cx;
		}else if(nPointPosH == 2){
			x-=size.cx/2;
		}
	}

	colOldText	= pDC->SetTextColor(col);			//TextColor̐ݒ
	nOldBkMode  = pDC->SetBkMode(TRANSPARENT);		//`͓߃[h
	pDC->TextOut(x,y,buff,m_nStrLen);				//`
	sizeLog=size;
//	if(!upperLine) TRACE("notUL %s\n",buff);
	if(upperLine){
		CPen penNew;
		CPen* ppenOld;
		int penWidth = nVExt/nWExt;
		//`惂[hɂăy̎ށEFCOPY or XORݒ肷
		penNew.CreatePen(PS_SOLID,penWidth,col);
		ppenOld=pDC->SelectObject(&penNew);			//쐬y̑I
		int i,begin,end;
		int lx,ly;
		if(bVert){
			lx = x;
		}else{
			ly = y;
		}
		i=0;
		while(i<m_nStrLen){
			if(lpstr[i]&0x80){
				size=pDC->GetTextExtent(buff,i);
				begin = size.cx;
				i++;
				while(i<m_nStrLen && lpstr[i]&0x80){
					i++;
				}
				size=pDC->GetTextExtent(buff,i);
				end = size.cx;	
				//TRACE("%d->%d\n",begin,end);
				if(bVert){
					pDC->MoveTo(lx,y-begin);
					pDC->LineTo(lx,y-end);
				}else{
					pDC->MoveTo(x+begin,ly);
					pDC->LineTo(x+end,ly);
				}
			}
			i++;
		}
		pDC->SelectObject(ppenOld);
	}

	

	pDC->SetBkMode(nOldBkMode);						//wi`惂[h̕A
	pDC->SetTextColor(colOldText);					//TextColor̕A
	pDC->SelectObject(pFont);						//tHg̕A
	
	return sizeLog;
}

/****************************************************************************
	RgpWindowstHg̕`
****************************************************************************/
CSize CBSchFont::PutWinFont(
		CDC* pDC,					//o͐̃foCXReLXg
		int x,int y,					//o͈ʒu
		LPCSTR lpstr,					//o͕
		int nStrLen /* =-1		*/,		//
		LOGFONT* plf,
		COLORREF col/* =RGB(255,255,255) */,		//o͐F
		UINT nMode	/* =DRAW_ON */,		//`惂[h
		BOOL bVert		/* =FALSE 	*/,	//tO
		int  nPointPos	/* =0  		*/,	//w肵o͈ʒu 0:̑O 1:̌ 2:̒
										//					 0:̉ 4:̏   8:̒
		int  nVExt	/* =1		*/,		//\{(View)
		int  nWExt	/* =1		*/)		//\{(Window)

{
	COLORREF colOldText;//,colOldBk;
	int      nOldBkMode;
	CSize	 size,sizeLog;

	int nLength;

	if(nStrLen<0) nLength=lstrlen(lpstr);		//񒷂̐ݒ
	else		  nLength=nStrLen;
	if(nLength==0) return CSize(0,0);			//񒷂OȂ牽Ȃ
	if(nLength>255) nLength=255;
	
	CFont*	pFont=new CFont;

	LOGFONT lf;
	if(!plf){
		assert(0);
		//lf = m_logfont;
	}else{
		lf = *plf;
	}

	lf.lfOutPrecision = OUT_TT_ONLY_PRECIS;
	
	lf.lfHeight = plf->lfHeight*nVExt/nWExt;
	if(bVert){
		lf.lfEscapement = 900;
		lf.lfOrientation = 900;
	}
	x=x*nVExt/nWExt;
	y=y*nVExt/nWExt;

	pFont->CreateFontIndirect(&lf);	//tHgNX̏
	pFont=pDC->SelectObject(pFont);					//tHg̑I
	size=pDC->GetTextExtent(lpstr,nLength);		//`TCY𓾂

	int nPointPosH = nPointPos&3;
	int nPointPosV = (nPointPos>>2)&3;
	int vOffset;

	if(nPointPosV == 0){
		vOffset = size.cy;
	}else if(nPointPosV == 1){
		vOffset = 0;
	}else{
		vOffset = size.cy/2;
	}

	if(bVert){
		x-=vOffset;
		if(nPointPosH == 1){
			y+=size.cx;
		}else if(nPointPosH == 2){
			y+=size.cx/2;
		}
	}else{
		y-=vOffset;
		if(nPointPosH == 1){
			x-=size.cx;
		}else if(nPointPosH == 2){
			x-=size.cx/2;
		}
	}



	if(nMode&DRAW_ON || nMode&DRAW_TEMP){
		colOldText	= pDC->SetTextColor(col);			//TextColor̐ݒ
		nOldBkMode  = pDC->SetBkMode(TRANSPARENT);		//`͓߃[h
		pDC->TextOut(x,y,lpstr,nLength);				//`
		pDC->SetBkMode(nOldBkMode);						//wi`惂[h̕A
		pDC->SetTextColor(colOldText);					//TextColor̕A
	}else if(nMode&DRAW_OFF){
		colOldText	= pDC->SetTextColor(0);				//TextColor̐ݒiŕ`j
		nOldBkMode  = pDC->SetBkMode(TRANSPARENT);		//`͓߃[h
		pDC->TextOut(x,y,lpstr,nLength);				//`
		pDC->SetBkMode(nOldBkMode);						//wi`惂[h̕A
		pDC->SetTextColor(colOldText);					//TextColor̕A
	}else{
		TRACE("\nsȕ`惂[h(CBSchFont::PutWinFont())");
	}
	pFont=pDC->SelectObject(pFont);					//tHg̕A
	sizeLog=size;
	delete pFont;
	return sizeLog;

}


CSize CBSchFont::PutWinFontML(
		CDC* pDC,					//o͐̃foCXReLXg
		int x,int y,				//o͈ʒu
		LPCSTR lpstr,				//o͕
		int nStrLen,				//
		LOGFONT* plf,
		int width,
		CSize& size1Line,
		COLORREF col/* =RGB(255,255,255) */,		//o͐F
		UINT nMode	/* =DRAW_ON */,		//`惂[h
		int  nVExt	/* =1		*/,		//\{(View)
		int  nWExt	/* =1		*/)		//\{(Window)

{
	COLORREF colOldText;//,colOldBk;
	int      nOldBkMode;
//	CSize	 size,sizeLog;
	CSize	 sizeLog;

	int nLength;

	if(nStrLen<0) nLength=lstrlen(lpstr);		//񒷂̐ݒ
	else		  nLength=nStrLen;
	if(nLength==0) return CSize(0,0);			//񒷂OȂ牽Ȃ
//	if(nLength>255) nLength=255;
	
	CFont*	pFont=new CFont;

	LOGFONT lf;
	if(!plf){
		assert(0);
		//lf = m_logfont;
	}else{
		lf = *plf;
	}

	lf.lfOutPrecision = OUT_TT_ONLY_PRECIS;
	
	lf.lfHeight = plf->lfHeight*nVExt/nWExt;
	//if(bVert){
	//	lf.lfEscapement = 900;
	//	lf.lfOrientation = 900;
	//}
	x=x*nVExt/nWExt;
	y=y*nVExt/nWExt;
	if(width<0)width=10000;
	width = width*nVExt/nWExt;

	pFont->CreateFontIndirect(&lf);	//tHgNX̏
	pFont=pDC->SelectObject(pFont);					//tHg̑I

	size1Line=pDC->GetTextExtent(lpstr,nLength);	//1C̕`TCY𓾂

	//int nPointPosH = nPointPos&3;
	//int nPointPosV = (nPointPos>>2)&3;
	int vOffset;

	vOffset = size1Line.cy;


	y-=vOffset;

	int right = x+width;
	int bottom = y+10000;

	//if(::g_bIsWin9x){
	//	if(right>32000) right=32000;
	//	if(bottom>32000) bottom=32000;
	//	if(x>right)x=right-100;
	//	if(y>bottom)y=bottom-100;
	//}

	CRect rc(x,y,right,bottom);


	UINT nFormat =DT_NOPREFIX|DT_TOP|DT_LEFT|DT_WORDBREAK|DT_CALCRECT;

	pDC->DrawText(lpstr,nLength,&rc,nFormat);	//`͂ȂB
	nFormat &= ~DT_CALCRECT;
	nFormat |= DT_NOCLIP;

	if(nMode&DRAW_ON || nMode&DRAW_TEMP){
		colOldText	= pDC->SetTextColor(col);			//TextColor̐ݒ
		nOldBkMode  = pDC->SetBkMode(TRANSPARENT);		//`͓߃[h
		//pDC->TextOut(x,y,lpstr,nLength);				//`
		pDC->DrawText(lpstr,nLength,&rc,nFormat);
		pDC->SetBkMode(nOldBkMode);						//wi`惂[h̕A
		pDC->SetTextColor(colOldText);					//TextColor̕A
	}else if(nMode&DRAW_OFF){
		colOldText	= pDC->SetTextColor(0);				//TextColor̐ݒiŕ`j
		nOldBkMode  = pDC->SetBkMode(TRANSPARENT);		//`͓߃[h
		//pDC->TextOut(x,y,lpstr,nLength);				//`
		pDC->DrawText(lpstr,nLength,&rc,nFormat);
		pDC->SetBkMode(nOldBkMode);						//wi`惂[h̕A
		pDC->SetTextColor(colOldText);					//TextColor̕A
	}else{
		TRACE("\nsȕ`惂[h(CBSchFont::PutWinFont())");
	}
	pFont=pDC->SelectObject(pFont);					//tHg̕A
	//if(width>size1Line.cx){
	//	width = size1Line.cx;
	//}
	sizeLog=rc.Size();//CSize(width,drawHeight);
	delete pFont;
	return sizeLog;

}



BOOL CBSchFont::IniReadFontInfo(const char* sectionName, LPLOGFONT lplf,const char* defFont,int defHeight)
{
	int n;
	char *p;
	CString rFaceName;
	
	p=(char*)lplf;	//LOGFONT\̂̂OCjVCY
	for(n=0;n<sizeof(LOGFONT);n++) *p++=0;

	lplf->lfHeight=AfxGetApp()->GetProfileInt(sectionName,"Height",defHeight); 	//tHg̍𓾂B
	lplf->lfWeight=AfxGetApp()->GetProfileInt(sectionName,"IsBold",FW_REGULAR);	//tHg̃EGCg𓾂BftHgl0
	lplf->lfItalic=AfxGetApp()->GetProfileInt(sectionName,"IsItalic",0);		//tHg̃C^bN𓾂BftHgl0
//	lplf->lfCharSet=AfxGetApp()->GetProfileInt(sectionName,"CharSet",SHIFTJIS_CHARSET);	//tHg̃LN^Zbg𓾂BftHglSHIFTJIS_CHARSET
	lplf->lfPitchAndFamily=0;//AfxGetApp()->GetProfileInt(sectionName,"PitchAndFamily",0);	//tHg̃sb`t@~𓾂BftHg0
	rFaceName=AfxGetApp()->GetProfileString(sectionName,"FaceName",defFont);	//tHgFaceName𓾂B
	strncpy(lplf->lfFaceName,rFaceName,LF_FACESIZE);
	lplf->lfFaceName[LF_FACESIZE-1]='\0';
	return TRUE;
}

//WXgɃtHg
BOOL CBSchFont::IniWriteFontInfo(const char* sectionName, LPLOGFONT lplf)
{
	AfxGetApp()->WriteProfileInt(sectionName,"Height",abs(lplf->lfHeight));		//tHg̍Zbg
	AfxGetApp()->WriteProfileInt(sectionName,"IsBold",lplf->lfWeight);			//tHg̃EGCgZbg
	AfxGetApp()->WriteProfileInt(sectionName,"IsItalic",lplf->lfItalic);		//tHg̃C^bNZbg
//	AfxGetApp()->WriteProfileInt(sectionName,"CharSet",lplf->lfCharSet);		//tHg̃LN^ZbgZbg
//	AfxGetApp()->WriteProfileInt(sectionName,"PitchAndFamily",lplf->lfPitchAndFamily);	//tHg̃sb`t@~Zbg
	AfxGetApp()->WriteProfileString(sectionName,"FaceName",lplf->lfFaceName);	//tHgFaceNameZbg
	return TRUE;
}

//////////////////////////////////////////////////////////////////////
//O[oϐ
CBSchFont* g_pFont;			//BSchtHg`NX
CBSchFont* g_pFontName;		//iAiԍ̕`


//////////////////////////////////////////////////////////////////////
//O[o֐

#define COMMENT_FONT_SECTION "CommentFont"
//WXgRg̃ftHg̃tHg𓾂
BOOL g_IniReadFontInfo(LPLOGFONT lplf)
{
	return CBSchFont::IniReadFontInfo(COMMENT_FONT_SECTION,lplf,"Tahoma",16);
}

//WXgɃRg̃ftHg̃tHg
BOOL g_IniWriteFontInfo(LPLOGFONT lplf)
{
	return CBSchFont::IniWriteFontInfo(COMMENT_FONT_SECTION,lplf);
}

#define LABEL_FONT_SECTION "LabelFont"
//WXg烉x̃tHg𓾂
BOOL g_IniReadLabelFontInfo(LPLOGFONT lplf)
{
	return CBSchFont::IniReadFontInfo(LABEL_FONT_SECTION,lplf,"Tahoma",9);
}

//WXgɃx̃tHg
BOOL g_IniWriteLabelFontInfo(LPLOGFONT lplf)
{
	return CBSchFont::IniWriteFontInfo(LABEL_FONT_SECTION,lplf);
}

#define NAME_FONT_SECTION "CompNameFont"
//WXg畔iԍ̃tHg𓾂
BOOL g_IniReadNameFontInfo(LPLOGFONT lplf)
{
	return CBSchFont::IniReadFontInfo(NAME_FONT_SECTION,lplf,"Tahoma",9);
}

//WXgɕiԍ̃tHg
BOOL g_IniWriteNameFontInfo(LPLOGFONT lplf)
{
	return CBSchFont::IniWriteFontInfo(NAME_FONT_SECTION,lplf);
}

#define QUICKPROP_FONT_SECTION "QuickPropFont"

//WXgAgr[gvr[̃tHg𓾂
BOOL g_IniReadQuickPropFontInfo(LPLOGFONT lplf)
{
	return CBSchFont::IniReadFontInfo(QUICKPROP_FONT_SECTION,lplf,"Tahoma",10);
}
//WXgɃAgr[gvr[̃tHg
BOOL g_IniWriteQuickPropFontInfo(LPLOGFONT lplf)
{
	return CBSchFont::IniWriteFontInfo(QUICKPROP_FONT_SECTION,lplf);
}
