/****************************************************************************
    BSch3V schematic capture
    Copyright (C) 1997-2006 H.Okada

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/

// BSchView.h : CBSchView NX̐錾уC^[tFCX̒`܂B
//
/////////////////////////////////////////////////////////////////////////////
#ifndef BSCHVIEW_H
#define BSCHVIEW_H




#define AUTOSCROLL_FRAME	2	//NCAgGA̓(AUTOSCROLL_FRAME)hbg
                                //OȂ玩XN[
//ȉ̂S̓vCx[g֐QueryAutoScroll()Ԃl
#define AUTOSCROLL_LEFT		1
#define AUTOSCROLL_TOP		2
#define AUTOSCROLL_RIGHT	4
#define AUTOSCROLL_BOTTOM	8

// DrawListData() dwOptionŎgl


//#define EXCEPT_DRAG_LINE	512
//#define DRAG_LINE_ONLY		1024
#define DRAW_ALL_LAYER		2048
#define DRAW_TEMP_DATA		1024

#define MAX_ZOOM_STEP_NUM 8


#include "BSchDrawColor.h"

class CBSchDoc;

class CQuickProp;

class CDlgObjFilter;

class CFind2;

class FindInfo
{
public:
	CString m_str;
	BOOL	m_bMatchWhole;
	BOOL	m_bCaseSensitive;
	unsigned int m_targetFlag;
};

class QuickPropSetting
{
public:
	bool m_enable;
	bool m_showOnMouseHover;
	bool m_num;
	bool m_val;
	bool m_mfr;
	bool m_mfrpn;
	bool m_package;
	bool m_note;
	bool m_nameinlib;
	QuickPropSetting(){
		m_num = false;
		m_val = false;
		m_enable = false;
		m_showOnMouseHover = false;
		m_mfr = false;
		m_mfrpn = false;
		m_package = false;
		m_note = false;
		m_nameinlib = false;
	};
	bool isEnabled(){
		return m_enable && (m_num || m_val || m_mfr || m_mfrpn || m_package || m_note || m_nameinlib);
	}

};




class CBSchView : public CScrollView
{
public:
	static SBSchDrawColor m_COL;

	//static COLORREF m_COL_BG;
	//static COLORREF m_COL_JUNC;
	//static COLORREF m_COL_WIRE;
	//static COLORREF m_COL_BUS;
	//static COLORREF m_COL_DASH;
	//static COLORREF m_COL_TAG;
	//static COLORREF m_COL_TAG_NAME;
	//static COLORREF m_COL_COMMENT;
	//static COLORREF m_COL_LABEL;
	//static COLORREF m_COL_XOR;
	//static COLORREF m_COL_PART;
	//static COLORREF m_COL_PART_PIN;
	//static COLORREF m_COL_PART_PINNAME;
	//static COLORREF m_COL_PART_PINNUM;
	//static COLORREF m_COL_PART_NAME;
	//static COLORREF m_COL_PART_NUM;
	//static COLORREF m_COL_PART_FRAME;
	//static COLORREF m_COL_SHEET_FRAME;
	//static COLORREF m_COL_SHEET_GRID;
	//static COLORREF m_COL_DARK;
	//static COLORREF m_COL_ZLPIN;
	//static COLORREF m_COL_NC_MARK;
	//static COLORREF m_COL_QUICKPROPVIEW;
	//static COLORREF m_COL_TEMPFRAME_FOCUSED;
	//static COLORREF m_COL_TEMPFRAME_NOT_FOCUSED;


	static void IniReadColor();
	static void IniWriteColor();


protected:
	void IniReadMarkerLineInitValue();
	void IniWriteMarkerLineInitValue();

//NCbNvpeB
protected:
	bool m_displayQuickPropComp;
	CQuickProp *m_pQuickPropComp;
	void ShowQuickPropComp(const SXBSchComponent* pObj);
	void HideQuickPropComp();
	CPoint m_ptDisplayQuickPropAt;
	QuickPropSetting m_quickPropSetting;
	void IniReadQuickPropSetting();
	void IniWriteQuickPropSetting();
	LOGFONT m_lfQuickPropFont;


//ǉI
protected:
	bool m_allowAppendSelect;
	BOOL IniReadAllowAppendSelect();
	void IniWriteAllowAppendSelect();




protected: // VACY@\݂̂쐬܂B
	CBSchView();
	DECLARE_DYNCREATE(CBSchView)

// Agr[g
public:
	CBSchDoc* GetDocument();

	void IniReadFindInfo(FindInfo& fi);
	void IniWriteFindInfo(FindInfo& fi);

//////////////////////////////////////////////////////////////////
// vCx[gϐ
private:

	////////////////////////////////////////////////////
	//W֘A
	CPoint m_ptMouseDP;		//foCXWŕ\}EX̍W(OnMouseMove(),OnLButtonDown(),OnLButtonUp()ŕύX)
	CPoint m_ptMouse;		//}ʍWŕ\}EX̍W(OnMouseMove(),OnLButtonDown(),OnLButtonUp()ŕύX)
	CPoint m_ptMoveFrom;	//Lv`n߂W
	CPoint m_ptMoveTo;		//Õ}EX̐}ʍW
	CRect m_rcClip;			//}ʍWŕ\NbsÖi}ʃIuWFNg̕`̑OɕKݒ)
							//OnPrepareDC()̒Őݒ肵Ă
	//CSize m_sizeClientArea;	//NCAgGÃTCY







	
	////////////////////////////////////////////////////
	//ȋȈԂɊւ
	int m_nLastSelectLibrary;	//ŌɑI񂾃CũXg{bNXł̏ԍ
	int m_nLastSelectPart;		//ŌɑI񂾕ĩXg{bNXł̏ԍ



	////////////////////////////////////////////////////
	// ĨtB^[
	unsigned m_ObjectFileterValue;
	CDlgObjFilter* m_pObjFilterDlg;

	////////////////////////////////////////////////////
	// 
	//_CAO
	CFind2* m_pFind2Dlg;
	//֌Wϐ
	bool m_FindMarkActive;
	CPoint m_ptFindMark;
	
	bool isFindMarkActive(); 



	//BOOL m_bUsePreview;

	BOOL m_fEditHighLight;
	////////////////////////////////////////////////////
	//c[IEE\̏ԂɊւ
	int m_nCurrentTool;		//ݑIĂc[
	BOOL m_bCaptureMouse;	//}EXLv`ĂTRUE
	BOOL m_bRBCaptureMouse;	//E{^Ń}EXLv`ĂTRUE


	BOOL m_bOnSelect;		//͈͑I𒆂ȂTRUE
	UINT m_nOnMove;			//ÔƂAړB
							//l CBSchDoc::IsOnTmpData()̕Ԓl
							// ONTMPDATA      (1)	w肵_͈ꎞf[^̏
							// ONTMPDATA_NAME (2)	w肵_͕ȉ
							// ONTMPDATA_NUM  (4)	w肵_͕iԍ̏
	
	BOOL m_bSetWireDirection;	//ꂪTRUÊƂ̓C[ʒûP{ڂ̕Zbgς
	BOOL m_bWireHorizon1st;		//ꂪTRUÊƂ̓C[ʒûP{ڂ

	CPoint m_pointOccasional;	//Վf[^̍W
	//m_bDrawXXXXXXXORŕ`悷IuWFNg̕`tO
	//ꂪTURÊƂAOnDraw()XOR̃IuWFNg`悷
	//`悵ꏊɍĕ`悵ďꍇ́AӐ}IFALSEݒ肷邱
	//u`̓xɃgOvƂ̂́Aĕ`L蓾̂炤܂Ȃ
	//OnInitialUpdate()ŃNAB
	BOOL m_bDrawSelectFrame;	//XORŕ`悷Ig			`TRUE
	BOOL m_bDrawTmpData;		//XORŕ`悷ꎞf[^		`TRUE
	BOOL m_bDrawOccasional;		//XORŕ`悷Վf[^		`TRUE
	BOOL m_bDrawTmpDataFrame;	//XORŕ`悷ꎞf[^̘g	`TRUE
	
	CBitmap* m_pBmpBuff;	//ItXN[obt@
//	CSize   m_sizeTmpCacheOffset;//LbVrbg}bṽItZbg

	BOOL m_bSnaptoGrid;			//Obhւ̃XibvBRXgN^TRUEɏB
	BOOL m_bTimerActive;		//ړɃ^C}[LȂƂTRUE
	BOOL m_bTimer2Active;		//XN[̃^C}[LȂƂTRUE

	int m_nWHEEL_DELTA;


	int m_oldContentsX;
	int m_oldContentsY;
	int m_oldOpCount;
	int m_oldViewScale;
	bool m_clearTempRect;

	SXBSchMarkerLine m_tempMarkerLine;
	SXBSchDash m_tempDecoLine;

	bool m_bEditPointsMode;
	SXBSchObj* m_pObjDetectedOnTempData;
	int m_nRetOptionOnTempData;


	bool m_bClickClickLineMode;	//0.69 NbNNbNŃCzu郂[h
	int m_nPlaceSequence;		//0.69 NbNNbNŔzuƂ̃V[PXԍ
	bool placeLineNow(){ return(m_bClickClickLineMode && m_nPlaceSequence>0); }


	////////////////////////////////////////////////////
	//IIuWFNg̃tH[JXɊւ
private:
	int m_nFocusedTo;
//public:
//	enum{
//		FOCUSED_TO_BODY = 0,
//		FOCUSED_TO_NUM = 1,
//		FOCUSED_TO_VAL = 2
//	};

	
public:
	////////////////////////////////////////////////////
	//ʂ̎wʒu}ʍWւ̃XN[
	void ScrollToFoundPos(CPoint pt);
	void OnCloseFind2Dialog();


	////////////////////////////////////////////////////
	//E{^XN[Ɋւ
private:
	int m_nRButtonMode;
	CPoint m_ptRBScrlStartMouse;
	CPoint m_ptRBScrlStartPosition;
	

	////////////////////////////////////////////////////
	//Y[Ɋւ
	int m_nVExt;			//\{(View)
	int m_nWExt;			//\{(Window)
	int m_nZoom;			//0`2̃Y[l o֐SetZoom̈
	CPoint m_pointUpdateCenter;
	BOOL m_bZoomUpdate;		//OnUpDate()ŃY[̂ƂTRUE 1997/01/26
				//ꂪTRUÊƂAOnUpDate()Ŏw_ւ̃XN[s



	////////////////////////////////////////////////////
	//\IvVɊւ
	BOOL m_bDisplayGrid;		//Obh̕\
	BOOL m_bUseCrossCursor;		//NXJ[\̎gp
	BOOL m_bCoarseStepZoom;		//eXebṽY[
//	BOOL m_bDisplayPartFrame;	//ig̕\   1997/01/01 O[oϐɈړ
	
	/////////////////////////////////////////////////////
	//Ɋւ
//	int m_nPrintMagX;			//{iqj
//	int m_nPrintMagY;			//{iqj
//	int m_nPrintMagX2;			//{ij
//	int m_nPrintMagY2;			//{ij
	int m_nPrintVExt;
	int m_nPrintWExt;
	bool m_bPrintColor;
	bool m_bPrintPageFit;


	CPoint m_pointPageLT;			//y[W̗̍p̃sNZ
	CSize m_sizePageDevicePixel;	//y[W̗p̃sNZTCY
	CPoint m_pointPrintOrigin;	//y[W̍̍W
	CSize m_sizePrintPixel;		//Py[Wɏo͉\Ȑ}ʏł̃TCY
	int m_nPageX;				//̃y[W
	int m_nPageY;				//̃y[W

	int m_bPrintFrame;			//̐}ʘgo

	//𑜓xݒ 1998/07/04
	//int	 m_nPrintRes;					//蓮ݒ̈𑜓x 0Ȃ玩ݒ
	BOOL m_bBitmapPrint;
	int GetDefaultPrintRes(CDC* pDC);	//W̉𑜓x𓾂

	bool m_bSetColor2Active;


	///////////////////////////////////////
	//L[Ɋւ
//	BOOL m_fShiftKeyDown;	//VtgL[̉ŃZbg
	int  m_nRepeatArrowKey;	//L[̃s[g

public:
	void updateBuff(bool bForce = true);

//////////////////////////////////////////////////////////////////
// vCx[g֐
private:
	void SetZoom(int n);			//Y[l̐ݒ
	void BSchPtoLP(LPPOINT pp,int nVExt,int nWExt);		//}ʍW_Wɕϊ(LPPOINT)
	void BSchPtoLP(LPSIZE psize,int nVExt,int nWExt);	//}ʍW_Wɕϊ(LPSIZE)
	void BSchPtoLP(LPRECT prc,int nVExt,int nWExt);		//}ʍW_Wɕϊ(LPRECT)
	void LPtoBSchP(LPPOINT pp,int nVExt,int nWExt);		//_W}ʍWɕϊ(LPPOINT)
	void LPtoBSchP(LPSIZE psize,int nVExt,int nWExt);	//_W}ʍWɕϊ(LPSIZE)
	void LPtoBSchP(LPRECT prc,int nVExt,int nWExt);		//_W}ʍWɕϊ(LPRECT)
	void SnapToGrid(LPPOINT pp);	//Obhւ̃Xibv
	CPoint GetClientCenter();		//NCAgGA̒̐}ʍW
	CPoint GetSheetLTforScroll(CPoint* ppointCenter);//w肵_𒆉ƂXN[|WV𓾂

	BOOL IniReadCoarseStepZoom(); //WXgeXebṽY[gǂ̐ݒǂݍ
	void IniWriteCoarseStepZoom(BOOL bCoarse);//WXgɑeXebṽY[gǂ̐ݒ

	BOOL IniReadUseCrossCursor();//WXgNXJ[\\̏𓾂
	void IniWriteUseCrossCursor(BOOL bDisplay);//WXgɃNXJ[\\̏
	BOOL IniReadDisplayGrid();		//WXgObh\̏𓾂
	void IniWriteDisplayGrid(BOOL bDisplay);//WXgɃObh\̏

	BOOL IniReadDisplayPartFrame();	//WXg畔ig\̏𓾂
	void IniWriteDisplayPartFrame(BOOL bDisplay);//WXgɕig\̏

	BOOL IniReadDisplayNcPinMark();	//WXgNCs}[N\̏𓾂
	void IniWriteDisplayNcPinMark(BOOL bDisplay);//WXgNCs}[N\̏

	BOOL IniReadDisplayHiddenPinNum();//WXg\sԍ\̏𓾂
	void IniWriteDisplayHiddenPinNum(BOOL bDisplay);//WXgɔ\sԍ\̏

	BOOL IniReadUsePreview();//WXg畔ivr[̏𓾂
	void IniWriteUsePreview(BOOL bUsePreview);//WXgɕivr[̏

	BOOL IniReadPrintPageFit();//WXgy[WtBbg̓ǂݍ
	void IniWritePrintPageFit(BOOL pagefit);//WXgɈy[WtBbg̏


	int  IniReadPrintRes();			//WXg𑜓x̓ǂݍ
	void IniWritePrintRes(int nRes);//WXgɈ𑜓x̏

	void IniReadPrintMargin(int& left,int& upper,int& right,int& lower);//WXg}[W̓ǂݍ
	void IniWritePrintMargin(int left,int upper,int right,int lower);//WXgɈ}[W̏

	BOOL CBSchView::IniReadClickClickLineMode();	//WXgNbNNbNC[h̏𓾂
	void CBSchView::IniWriteClickClickLineMode(BOOL bClickClick);	//WXgɃNbNNbNC[h̏


	//Rg̃NXɃftHg̃tHgݒ肷
	void SetDefaultFontSettingsToCommentClass();


	void OnSheetXXX(int n);			//CxgnhOnSheet640`3000()Ă΂
	
	void DrawSheetGrid(CDC* pDC,const CRect& rcClip);	//Obh̕` "BScView2.CPP"

	void DrawSheetFrameCharH(CDC* pDC,COLORREF col,int ny,int nWidth,UINT nMode,int nVExt,int nWExt);//}ʘg̐W̕`
	void DrawSheetFrameCharV(CDC* pDC,COLORREF col,int nx,int nWidth,UINT nMode,int nVExt,int nWExt);//}ʘg̐W̕`
	void DrawSheetFrame(CDC* pDC,DWORD dwMode,int nVExt,int nWExt,const CRect& rcClip);	//}ʘg̕` "BScView2.CPP"

	void DrawPrintBg(CDC* pDC,DWORD dwMode,int nVExt,int nWExt,const CRect* prc);	//̔wiF̕` "BScView2.CPP"


	//void updateBuff(bool bForce = true);
	void drawBuffer(int x,int y,int w,int h,int clipx,int clipy, int clipw, int cliph );

	void DrawObj(							//}ʗvf`悷
		CDC* pDC,							//`
		SXBSchObj* pObj,						//`IuWFNg
		DWORD dwMode,						//`惂[h
		int  nVExt,							//\{(View)
		int  nWExt,							//\{(Window)
		LPCRECT lprcClip=NULL);				//Nbv


	void DrawListData(CDC* pDC,XBSchObjList* pList,DWORD dwMode,
		int  nVExt,int  nWExt,
		const CRect& rcClip,DWORD dwOption,DWORD layerMask=0xFFFF);//w胊Xgf[^̕` "BScView2.CPP"
	void DrawMainData(CDC* pDC,CBSchDoc* pDoc,DWORD dwMode,
		int  nVExt,int  nWExt,
		const CRect& rcClip);//Cf[^̕` "BScView2.CPP"
	void DrawTmpData(CDC* pDC,CBSchDoc* pDoc,DWORD dwMode,
		int  nVExt,int  nWExt,
		const CRect& rcClip,BOOL bDraw=TRUE);	//ꎞf[^̕` "BScView2.CPP"
	void DrawTmpDataFrame(CDC* pDC,CBSchDoc* pDoc,BOOL bDraw=TRUE);//ꎞf[^̘g̕` "BScView2.CPP"
	void DrawSelectFrame(CDC* pDC,BOOL bDraw=TRUE);			//I𒆂̓_g̕` "BScView2.CPP"
//	BOOL PrepareBmpTmpCache();	//ꎞf[^`̂߂̃LbVrbg}bv̏ "BScView2.CPP"
	void DrawOccasional(CDC* pDC,BOOL bDraw=TRUE);	//Վf[^̕` "BScView2.CPP"

	void DrawCrossCursor(CDC* pDC);
	void DrawFindMark(CDC* pDC);

	void DisplayCurrentXY();		//m_ptMouse̒lc[o[ɔfB
	UINT QueryAutoScroll(CDC* pDC);	//XN[̕Kv₤
	void AutoScroll(CDC* pDC,UINT fScroll);	//XN[̔
	void ChangeTool(int nOldTool,int nNewTool);//c[ςƂ̋ʏ

	void OnZoomInOutProc(BOOL bZoomIn,BOOL bKey =FALSE);	//Y[CAEg̏

	void FixSelection(int option);	//Ỉ

	///////////////////////////////////////////////////
	//  j[ACẽCl[ủۂԂ
	//    j[ACẽCl[ủۂCj[ƃReLXgj[
	//  ƂŁÃWbNōs
	//    1997/01/23 ReLXgj[̒ǉƂƂɂ̊֐Qǉ
	BOOL MenuItemTest_Undo();		//ɖ߂  1997/01/27 ǉ
	BOOL MenuItemTest_Redo();		//Ȃ 2008/01/13 ǉ
	BOOL MenuItemTest_Cut();		//؂
	BOOL MenuItemTest_Copy();		//Rs[
	BOOL MenuItemTest_Paste();		//\t
	BOOL MenuItemTest_Attribute();	//Agr[g
	BOOL MenuItemTest_Mirror();		//~[
	BOOL MenuItemTest_Rotate();		//]

	BOOL MenuItemTest_MoveToLayer(int nLayer);	//C[̈ړ 1998/06/28
	
	//////////////////////////////////////
	//zu֘A
	BOOL PlaceJunction(CBSchDoc* pDoc);//WNV̔zu "PLACE.CPP"
	BOOL PlacePart(CBSchDoc* pDoc,CPoint* ppoint);//p[c̔zu "PLACE.CPP"
	BOOL PlaceEntry(CBSchDoc* pDoc);//Gg[̔zu "PLACE.CPP"
	BOOL PlaceLabel(CBSchDoc* pDoc,CPoint* ppoint);//x̔zu "PLACE.CPP"
	BOOL PlaceComment(CBSchDoc* pDoc,CPoint* ppoint);//Rg̔zu "PLACE.CPP"
	BOOL PlaceTag(CBSchDoc* pDoc,CPoint* ppoint);//^O̔zu "PLACE.CPP"
	BOOL PlaceWire(CBSchDoc* pDoc);//C[̔zu "PLACE.CPP"
	BOOL PlaceBus(CBSchDoc* pDoc);//oX̔zu "PLACE.CPP"
	BOOL PlaceDash(CBSchDoc* pDoc);//j̔zu "PLACE.CPP"
	BOOL PlaceMarkerLine(CBSchDoc* pDoc);//}[J[C̔zu "PLACE.CPP"
	
	//////////////////////////////////////
	//C[֘A
	void MoveLayer(int n);	//1998/06/30  I͈͂w背C[Ɉړ
	void OnUpdateDisplayLayer(CCmdUI *pCmdUI,int layer);
	void OnClickDisplayLayer(int layer);
	void OnUpdateEditLayer(CCmdUI *pCmdUI,int layer);
	void OnClickEditLayer(int layer);



	///////////////////////////////////////////////
	//֘A
	void SetPageSize(CDC* pDC,int nRes);	//̔{ATCY߂
	int  GetCountPage();		//y[W𓾂
	BOOL ExportBitmapFile(LPCSTR pszFileName);	//rbg}bvt@Co
	//BOOL ExportBidFile(LPCSTR pszFileName);		//BIDt@Co
	BOOL ExportEmf(LPCSTR pszFileName);

	BOOL CopyEmf();

	
	void PrepareDrawFlagForPrint(CDC* pDC);	//̂߂̕`tȌ
	void PopDrawFlagForPrint();		//OPrepareDrawFlagForPrint()ő삵
	                                //`tOɖ߂
	
	// Iy[V
	//Agr[gύX_CAŐN
	BOOL DoAttributeDialog();

	//Rg̃Agr[gύXp̃_CAON
	BOOL DoAttributeDialogComment(SXBSchComment* pObj);
	//x̃Agr[gύXp̃_CAON
	BOOL DoAttributeDialogLabel(SXBSchLabel* pObj);
	//^ÕAgr[gύXp̃_CAON
	BOOL DoAttributeDialogTag(SXBSchTag* pObj);
	//iAgr[gύXp̃_CAON
	BOOL DoAttributeDialogComponent(SXBSchComponent* pObj);
	//}[J[CAgr[gύXp̃_CAON
	BOOL DoAttributeDialogMarkerLine(SXBSchMarkerLine* pObj);
	//Agr[gύXp̃_CAON
	BOOL DoAttributeDialogDecoLine(SXBSchDash* pObj);
	//C[WIuWFNgAgr[gύXp̃_CAON
	BOOL DoAttributeDialogImageObj(SXBSchImageObj* pObj);

public:
	void DisplayMessageLine();

private:
	CString m_strMessageLine;


public:


// I[o[Ch
	// ClassWizard ͉z֐𐶐I[o[Ch܂B
	//{{AFX_VIRTUAL(CBSchView)
	public:
	virtual void OnDraw(CDC* pDC);  // ̃r[`悷ۂɃI[o[Ch܂B
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	virtual void OnPrepareDC(CDC* pDC, CPrintInfo* pInfo = NULL);
	protected:
	virtual void OnInitialUpdate(); // \z̍ŏ̂PxĂяo܂B
	virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
	virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnEndPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint);
	virtual BOOL OnScrollBy(CSize sizeScroll, BOOL bDoScroll = TRUE);
	virtual void OnPrint(CDC* pDC, CPrintInfo* pInfo);
	//}}AFX_VIRTUAL

// Cve[V
public:
	virtual ~CBSchView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:
	void OnExtMenuN(int n);

// ꂽbZ[W }bv֐
protected:
	//{{AFX_MSG(CBSchView)
	afx_msg void OnToolSelector();
	afx_msg void OnUpdateToolSelector(CCmdUI* pCmdUI);
	afx_msg void OnToolDrag();
	afx_msg void OnUpdateToolDrag(CCmdUI* pCmdUI);
	afx_msg void OnToolPart();
	afx_msg void OnUpdateToolPart(CCmdUI* pCmdUI);
	afx_msg void OnToolWire();
	afx_msg void OnUpdateToolWire(CCmdUI* pCmdUI);
	afx_msg void OnToolBus();
	afx_msg void OnUpdateToolBus(CCmdUI* pCmdUI);
	afx_msg void OnToolDash();
	afx_msg void OnUpdateToolDash(CCmdUI* pCmdUI);
	afx_msg void OnToolJunction();
	afx_msg void OnUpdateToolJunction(CCmdUI* pCmdUI);
	afx_msg void OnToolEntryWl();
	afx_msg void OnUpdateToolEntryWl(CCmdUI* pCmdUI);
	afx_msg void OnToolEntryBl();
	afx_msg void OnUpdateToolEntryBl(CCmdUI* pCmdUI);
	afx_msg void OnToolTag();
	afx_msg void OnUpdateToolTag(CCmdUI* pCmdUI);
	afx_msg void OnToolLabel();
	afx_msg void OnUpdateToolLabel(CCmdUI* pCmdUI);
	afx_msg void OnToolComment();
	afx_msg void OnUpdateToolComment(CCmdUI* pCmdUI);
	afx_msg void OnSetLibrary();
	afx_msg void OnSetCommentFont();
	afx_msg void OnUpdateZoomIn(CCmdUI* pCmdUI);
	afx_msg void OnZoomIn();
	afx_msg void OnUpdateZoomOut(CCmdUI* pCmdUI);
	afx_msg void OnZoomOut();
	afx_msg void OnSheet640();
	afx_msg void OnSheet1000();
	afx_msg void OnSheet1600();
	afx_msg void OnSheet2000();
	afx_msg void OnSheet3000();
	afx_msg void OnUpdateDispGrid(CCmdUI* pCmdUI);
	afx_msg void OnDispGrid();
	afx_msg void OnUpdatePartFrame(CCmdUI* pCmdUI);
	afx_msg void OnPartFrame();
	afx_msg void OnUpdateSnapGrid(CCmdUI* pCmdUI);
	afx_msg void OnSnapGrid();
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnUpdateEditUndo(CCmdUI* pCmdUI);
	afx_msg void OnEditUndo();
	afx_msg void OnUpdateEditDelete(CCmdUI* pCmdUI);
	afx_msg void OnEditDelete();
	afx_msg void OnUpdateEditCopy(CCmdUI* pCmdUI);
	afx_msg void OnEditCopy();
	afx_msg void OnUpdateEditPaste(CCmdUI* pCmdUI);
	afx_msg void OnEditPaste();
	afx_msg void OnUpdateEditCut(CCmdUI* pCmdUI);
	afx_msg void OnEditCut();
	afx_msg void OnTimer(UINT nIDEvent);
//	afx_msg void OnRefresh();
	afx_msg void OnUpdateRotate(CCmdUI* pCmdUI);
	afx_msg void OnRotate();
	afx_msg void OnUpdateMirror(CCmdUI* pCmdUI);
	afx_msg void OnMirror();
	afx_msg void OnUpdateEditAttribute(CCmdUI* pCmdUI);
	afx_msg void OnEditAttribute();
	afx_msg void OnFilePrint();
	afx_msg void OnFilePrintPreview();
	afx_msg void OnFileExpoBmp();
	afx_msg void OnContextMenu(CWnd* pWnd, CPoint point);
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnFilePrintOption();
//	afx_msg void OnUsePreview();
//	afx_msg void OnUpdateUsePreview(CCmdUI* pCmdUI);
	afx_msg void OnEditSetuplayer();
	afx_msg void OnUpdateEditMovetolayer0(CCmdUI* pCmdUI);
	afx_msg void OnUpdateEditMovetolayer1(CCmdUI* pCmdUI);
	afx_msg void OnUpdateEditMovetolayer2(CCmdUI* pCmdUI);
	afx_msg void OnUpdateEditMovetolayer3(CCmdUI* pCmdUI);
	afx_msg void OnUpdateEditMovetolayer4(CCmdUI* pCmdUI);
	afx_msg void OnUpdateEditMovetolayer5(CCmdUI* pCmdUI);
	afx_msg void OnUpdateEditMovetolayer6(CCmdUI* pCmdUI);
	afx_msg void OnUpdateEditMovetolayer7(CCmdUI* pCmdUI);
	afx_msg void OnEditMovetolayer0();
	afx_msg void OnEditMovetolayer1();
	afx_msg void OnEditMovetolayer2();
	afx_msg void OnEditMovetolayer3();
	afx_msg void OnEditMovetolayer4();
	afx_msg void OnEditMovetolayer5();
	afx_msg void OnEditMovetolayer6();
	afx_msg void OnEditMovetolayer7();
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnKillFocus(CWnd* pNewWnd);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnSheetFree();
	afx_msg BOOL OnMouseWheel(UINT nFlags, short zDelta, CPoint pt);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
public:
	afx_msg void OnUpdateMenuCrossCursor(CCmdUI *pCmdUI);
	afx_msg void OnMenuCrossCursor();
	afx_msg void OnFileExpoEmf();
	afx_msg void OnSetColor();
	afx_msg void OnEditFind();
	//afx_msg void OnEditFindnext();
	//afx_msg void OnUpdateEditFindnext(CCmdUI *pCmdUI);
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnRButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnExtMenu_0();
	afx_msg void OnExtMenu_1();
	afx_msg void OnExtMenu_2();
	afx_msg void OnExtMenu_3();
	afx_msg void OnExtMenu_4();
	afx_msg void OnExtMenu_5();
	afx_msg void OnExtMenu_6();
	afx_msg void OnExtMenu_7();
	afx_msg void OnExtMenu_8();
	afx_msg void OnExtMenu_9();

	afx_msg void OnEditEmfCopy();
	afx_msg void OnUpdateEditEmfCopy(CCmdUI *pCmdUI);
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
//	afx_msg void OnSetCoarseStepZoom();
//	afx_msg void OnUpdateSetCoarseStepZoom(CCmdUI *pCmdUI);
	afx_msg void OnDispNcmark();
	afx_msg void OnUpdateDispNcmark(CCmdUI *pCmdUI);
	afx_msg void OnUpdateDisplayLayer0(CCmdUI *pCmdUI);
	afx_msg void OnUpdateDisplayLayer1(CCmdUI *pCmdUI);
	afx_msg void OnUpdateDisplayLayer2(CCmdUI *pCmdUI);
	afx_msg void OnUpdateDisplayLayer3(CCmdUI *pCmdUI);
	afx_msg void OnUpdateDisplayLayer4(CCmdUI *pCmdUI);
	afx_msg void OnUpdateDisplayLayer5(CCmdUI *pCmdUI);
	afx_msg void OnUpdateDisplayLayer6(CCmdUI *pCmdUI);
	afx_msg void OnUpdateDisplayLayer7(CCmdUI *pCmdUI);
	afx_msg void OnClickDisplayLayer0();
	afx_msg void OnClickDisplayLayer1();
	afx_msg void OnClickDisplayLayer2();
	afx_msg void OnClickDisplayLayer3();
	afx_msg void OnClickDisplayLayer4();
	afx_msg void OnClickDisplayLayer5();
	afx_msg void OnClickDisplayLayer6();
	afx_msg void OnClickDisplayLayer7();
	afx_msg void OnUpdateEditLayer0(CCmdUI *pCmdUI);
	afx_msg void OnUpdateEditLayer1(CCmdUI *pCmdUI);
	afx_msg void OnUpdateEditLayer2(CCmdUI *pCmdUI);
	afx_msg void OnUpdateEditLayer3(CCmdUI *pCmdUI);
	afx_msg void OnUpdateEditLayer4(CCmdUI *pCmdUI);
	afx_msg void OnUpdateEditLayer5(CCmdUI *pCmdUI);
	afx_msg void OnUpdateEditLayer6(CCmdUI *pCmdUI);
	afx_msg void OnUpdateEditLayer7(CCmdUI *pCmdUI);
	afx_msg void OnClickEditLayer0();
	afx_msg void OnClickEditLayer1();
	afx_msg void OnClickEditLayer2();
	afx_msg void OnClickEditLayer3();
	afx_msg void OnClickEditLayer4();
	afx_msg void OnClickEditLayer5();
	afx_msg void OnClickEditLayer6();
	afx_msg void OnClickEditLayer7();
	afx_msg void OnUpdateSheetFree(CCmdUI *pCmdUI);
	afx_msg void OnUpdateSheet640(CCmdUI *pCmdUI);
	afx_msg void OnUpdateSheet1000(CCmdUI *pCmdUI);
	afx_msg void OnUpdateSheet1600(CCmdUI *pCmdUI);
	afx_msg void OnUpdateSheet2000(CCmdUI *pCmdUI);
	afx_msg void OnUpdateSheet3000(CCmdUI *pCmdUI);
	afx_msg void OnEditRedo();
	afx_msg void OnUpdateEditRedo(CCmdUI *pCmdUI);
	afx_msg void OnToolMarker();
	afx_msg void OnUpdateToolMarker(CCmdUI *pCmdUI);
	afx_msg void OnDispHiddenpinnum();
	afx_msg void OnUpdateDispHiddenpinnum(CCmdUI *pCmdUI);
	afx_msg void OnSetupQuick();
	afx_msg void OnMouseHover(UINT nFlags, CPoint point);
	afx_msg void OnSetupAllowappendselect();
	afx_msg void OnUpdateSetupAllowappendselect(CCmdUI *pCmdUI);
	afx_msg void OnConvertC2l();
	afx_msg void OnUpdateConvertC2l(CCmdUI *pCmdUI);
	afx_msg void OnConvertC2t();
	afx_msg void OnUpdateConvertC2t(CCmdUI *pCmdUI);
	afx_msg void OnConvertL2t();
	afx_msg void OnUpdateConvertL2t(CCmdUI *pCmdUI);
	afx_msg void OnConvertL2c();
	afx_msg void OnUpdateConvertL2c(CCmdUI *pCmdUI);
	afx_msg void OnConvertT2l();
	afx_msg void OnUpdateConvertT2l(CCmdUI *pCmdUI);
	afx_msg void OnConvertT2c();
	afx_msg void OnUpdateConvertT2c(CCmdUI *pCmdUI);
	afx_msg void OnBulkattributeTagframe();
	afx_msg void OnUpdateBulkattributeTagframe(CCmdUI *pCmdUI);
	afx_msg void OnBulkattributeMarkerline();
	afx_msg void OnUpdateBulkattributeMarkerline(CCmdUI *pCmdUI);
	afx_msg void OnBulkattributeCommentfont();
	afx_msg void OnUpdateBulkattributeCommentfont(CCmdUI *pCmdUI);
	afx_msg void OnBulkattributeReplacecomponentinfo();
	afx_msg void OnUpdateBulkattributeReplacecomponentinfo(CCmdUI *pCmdUI);
	afx_msg void OnInsertBitmap();
	afx_msg void OnUpdateBulkattributeHidenumbers(CCmdUI *pCmdUI);
	afx_msg void OnBulkattributeHidenumbers();
	afx_msg void OnToolUseobjectfilter();
	afx_msg void OnUpdateToolUseobjectfilter(CCmdUI *pCmdUI);
	afx_msg void OnUpdateEditPoints(CCmdUI *pCmdUI);
	afx_msg void OnEditPoints();
	afx_msg void OnSetupPlacelinebyclick();
	afx_msg void OnUpdateSetupPlacelinebyclick(CCmdUI *pCmdUI);
	afx_msg void OnUpdateOrderBringtofront(CCmdUI *pCmdUI);
	afx_msg void OnOrderBringtofront();
	afx_msg void OnOrderBringtoback();
	afx_msg void OnUpdateReloadReload(CCmdUI *pCmdUI);
	afx_msg void OnReloadReload();
	afx_msg void OnUpdateEditFind(CCmdUI *pCmdUI);
};

#ifndef _DEBUG  // BSchView.cpp t@CfobO̎gp܂B
inline CBSchDoc* CBSchView::GetDocument()
   { return (CBSchDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////

#endif
