/****************************************************************************
    BSch3V schematic capture
    Copyright (C) 1997-2005 H.Okada

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/

// SetFont.cpp : t@C
//

#include "stdafx.h"
#include "BSch.h"
#include "SetFont.h"
#include ".\setfont.h"


// CSetFont _CAO

IMPLEMENT_DYNAMIC(CSetFont, CDialog)
CSetFont::CSetFont(CWnd* pParent /*=NULL*/)
	: CDialog(CSetFont::IDD, pParent)
{
	m_bChangedCommentFont = false;
	m_bChangedLabelFont = false;
	m_bChangedNameFont = false;
	m_bChangedQuickPropFont = false;
}

CSetFont::~CSetFont()
{
}

void CSetFont::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}


BEGIN_MESSAGE_MAP(CSetFont, CDialog)
	ON_BN_CLICKED(IDC_SET_COMFONT, OnBnClickedSetComfont)
	ON_BN_CLICKED(IDC_SET_LBLFONT, OnBnClickedSetLblfont)
	ON_BN_CLICKED(IDC_SET_NAMEFONT, OnBnClickedSetNamefont)
	ON_BN_CLICKED(IDC_SET_QUICKPROPFONT, &CSetFont::OnBnClickedSetQuickpropfont)
END_MESSAGE_MAP()


// CSetFont bZ[W nh

const char* CSetFont::StyleString(bool bold,bool italic)
{
	static char* styleString[4]=
	{
		"Regular",
		"Bold",
		"Italic",
		"Bold-Italic"
	};
	if(!bold && !italic)return styleString[0];
	else if(bold && !italic)return styleString[1];
	else if(!bold && italic)return styleString[2];
	else return styleString[3];
}

int CSetFont::PointToPixel(int point)
{
	CWindowDC dc(this);
	return MulDiv(point, GetDeviceCaps(dc.m_hDC, LOGPIXELSY), 72);
}

int CSetFont::PixelToPoint(int pixel)
{
	if(pixel<0) pixel = -pixel;
	CWindowDC dc(this);
	return MulDiv(pixel, 72,GetDeviceCaps(dc.m_hDC, LOGPIXELSY));
}


void CSetFont::SetCommentFontInfo(LOGFONT& lf)
{
	CEdit* pEdit;
	const char* csz;
	char szSizeText[16];
	pEdit=(CEdit*)GetDlgItem(IDC_COM_FONTNAME);
	pEdit->SetWindowText(lf.lfFaceName);
	pEdit=(CEdit*)GetDlgItem(IDC_COM_FONTSTYLE);
	csz = StyleString(lf.lfWeight>=FW_BOLD,lf.lfItalic!=0);
	pEdit->SetWindowText(csz);
	pEdit=(CEdit*)GetDlgItem(IDC_COM_FONTSIZE);
	sprintf(szSizeText,"%d",PixelToPoint(lf.lfHeight));
	pEdit->SetWindowText(szSizeText);
}
void CSetFont::SetLabelFontInfo(LOGFONT& lf)
{
	CEdit* pEdit;
	const char* csz;
	char szSizeText[16];
	pEdit=(CEdit*)GetDlgItem(IDC_LBL_FONTNAME);
	pEdit->SetWindowText(lf.lfFaceName);
	pEdit=(CEdit*)GetDlgItem(IDC_LBL_FONTSTYLE);
	csz = StyleString(lf.lfWeight>=FW_BOLD,lf.lfItalic!=0);
	pEdit->SetWindowText(csz);
	pEdit=(CEdit*)GetDlgItem(IDC_LBL_FONTSIZE);
	sprintf(szSizeText,"%d",PixelToPoint(lf.lfHeight));
	pEdit->SetWindowText(szSizeText);
}

void CSetFont::SetNameFontInfo(LOGFONT& lf)
{
	CEdit* pEdit;
	const char* csz;
	char szSizeText[16];
	pEdit=(CEdit*)GetDlgItem(IDC_NAME_FONTNAME);
	pEdit->SetWindowText(lf.lfFaceName);
	pEdit=(CEdit*)GetDlgItem(IDC_NAME_FONTSTYLE);
	csz = StyleString(lf.lfWeight>=FW_BOLD,lf.lfItalic!=0);
	pEdit->SetWindowText(csz);
	pEdit=(CEdit*)GetDlgItem(IDC_NAME_FONTSIZE);
	sprintf(szSizeText,"%d",PixelToPoint(lf.lfHeight));
	pEdit->SetWindowText(szSizeText);
}


void CSetFont::SetQuickPropFontInfo(LOGFONT& lf)
{
	CEdit* pEdit;
	const char* csz;
	char szSizeText[16];
	pEdit=(CEdit*)GetDlgItem(IDC_QUICKPROP_FONTNAME);
	pEdit->SetWindowText(lf.lfFaceName);
	pEdit=(CEdit*)GetDlgItem(IDC_QUICKPROP_FONTSTYLE);
	csz = StyleString(lf.lfWeight>=FW_BOLD,lf.lfItalic!=0);
	pEdit->SetWindowText(csz);
	pEdit=(CEdit*)GetDlgItem(IDC_QUICKPROP_FONTSIZE);
	sprintf(szSizeText,"%d",PixelToPoint(lf.lfHeight));
	pEdit->SetWindowText(szSizeText);
}

BOOL CSetFont::OnInitDialog()
{
	CDialog::OnInitDialog();
	// TODO :  ɏǉĂ
	SetCommentFontInfo(m_lfComment);
	SetLabelFontInfo(m_lfLabel);
	SetNameFontInfo(m_lfName);
	SetQuickPropFontInfo(m_lfQuickProp);

	return TRUE;  // return TRUE unless you set the focus to a control
	// O : OCX vpeB y[W͕K FALSE Ԃ܂B
}

void CSetFont::OnBnClickedSetComfont()
{
	// TODO : ɃRg[ʒmnh R[hǉ܂B
	LOGFONT lf = m_lfComment; 
	lf.lfOutPrecision = OUT_TT_ONLY_PRECIS;
	CFontDialog fontdlg(&lf,CF_TTONLY | CF_SCREENFONTS);
	if(fontdlg.DoModal()==IDOK){
		m_lfComment = lf;
		SetCommentFontInfo(m_lfComment);
		m_bChangedCommentFont = true;
	}
}

void CSetFont::OnBnClickedSetLblfont()
{
	// TODO : ɃRg[ʒmnh R[hǉ܂B
	LOGFONT lf = m_lfLabel; 
	lf.lfOutPrecision = OUT_TT_ONLY_PRECIS;
	CFontDialog fontdlg(&lf,CF_TTONLY | CF_SCREENFONTS);
	if(fontdlg.DoModal()==IDOK){
		m_lfLabel = lf;
		SetLabelFontInfo(m_lfLabel);
		m_bChangedLabelFont = true;
	}
}

void CSetFont::OnBnClickedSetNamefont()
{
	// TODO : ɃRg[ʒmnh R[hǉ܂B
	LOGFONT lf = m_lfName; 
	lf.lfOutPrecision = OUT_TT_ONLY_PRECIS;
	CFontDialog fontdlg(&lf,CF_TTONLY | CF_SCREENFONTS);
	if(fontdlg.DoModal()==IDOK){
		m_lfName = lf;
		SetNameFontInfo(m_lfName);
		m_bChangedNameFont = true;
	}
}

void CSetFont::OnBnClickedSetQuickpropfont()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	// TODO : ɃRg[ʒmnh R[hǉ܂B
	LOGFONT lf = m_lfQuickProp; 
	lf.lfOutPrecision = OUT_TT_ONLY_PRECIS;
	CFontDialog fontdlg(&lf,CF_TTONLY | CF_SCREENFONTS);
	if(fontdlg.DoModal()==IDOK){
		m_lfQuickProp = lf;
		SetQuickPropFontInfo(m_lfQuickProp);
		m_bChangedQuickPropFont = true;
	}
}
