// Copyright (C) 2002 H.Okada(suigyodo) All rights reserved.
//XBSch̃hLg̊ǗsB

//#include <qapplication.h>
//#include <qwidget.h>
//#include <SSize.h>
//#include <SPoint.h>
//#include <qclipboard.h>
#include "stdafx.h"
#include <stdio.h>
#include <assert.h>
#include <string>
#include <list>
using namespace std;
#include "ce3io.h"
#include "xbschobj.h"
#include "xbschjunc.h"
#include "xbschlabel.h"
#include "xbschcomment.h"
#include "xbschtag.h"
#include "xbschcomponent.h"

#include "xbschline.h"
#include "xbschentry.h"
#include "xbschdelobj.h"
#include "xbschsheetinfo.h"
#include "xbschdoc.h"




SXBSchDoc::SXBSchDoc()
{
	m_bDirty = false;
	m_sizeSheet = SSize(1500,1000);
//	m_pView = NULL;
	m_bSelectForDrag = false;
	init();
}

SXBSchDoc::~SXBSchDoc()
{
	init();
}

bool SXBSchDoc::isEmpty()
{
	if( (m_listMain.size() > 0) || (m_listTemp.size() > 0 )) return false;
	else return true;
}


//V[gTCY̐ݒ
void SXBSchDoc::SetSheetSize(const SSize& size)
{
	if(size.w()<500||size.w()>3000||size.h()<400||size.h()>2000)return;
	m_sizeSheet = size;
}

//}ʗvf̒ǉ ԍԂ
int SXBSchDoc::add(SXBSchObj* pObj)
{
	if(pObj == NULL) return m_nOpCount;
	m_nOpCount++;
	m_bDirty = true;	
	pObj->setPlaceNum(m_nOpCount);	
	m_listMain.push_back(pObj);
	return m_nOpCount;
}

//IԂŒǉ}ʗvf̒ǉ ԍԂ
int  SXBSchDoc::addSelect(SXBSchObj* pObj)
{
	m_listTemp.push_back(pObj);
	setupRcTempArea();
	m_bDirty = true;	
	return m_nOpCount;
}

//_w肵Ă̑I
//_w肵Ă̑Ił́A1̃IuWFNgI΂ȂB
int SXBSchDoc::select(const SPoint& pt)
{
	resetSelect();
	SXBSchObj* pObjSelected = NULL;
	int maxSelectWeight=0;
	XBSchObjListIterator pObjIte = m_listMain.begin();
	while(pObjIte !=  m_listMain.end()){
		if((*pObjIte)->refObj()==NULL){	//QƃIuWFNĝ݂͖ł
			int SelectWeight = (*pObjIte)->qSelectWeight(pt) & 0xFFFF;
			if(SelectWeight > maxSelectWeight){
				maxSelectWeight = SelectWeight;
				pObjSelected = (*pObjIte);
			}
		}
		pObjIte++;
	}
	if(pObjSelected != NULL){
		SXBSchObj* pNewObj = pObjSelected->duplicate();
		pObjSelected->setRefObj(pNewObj);
		pNewObj->setRefObj(pObjSelected);
		pNewObj->setSelection(SXBSchObj::SELECT_ALL);
		m_listTemp.push_back(pNewObj);
	}
	setupRcTempArea();
	setupRotateRect();
	m_bSelectForDrag = false;
	return m_listTemp.size();
}

//͈͂w肵Ă̑I
//IƂ́A
//  C̃XgŶA
//  ꎞIuWFNgɒǉ
//IԂ
int SXBSchDoc::select(const SRect& rc)
{
	resetSelect();
	XBSchObjListIterator pObjIte = m_listMain.begin();
	while(pObjIte != m_listMain.end()){
		if((*pObjIte)->refObj()==NULL){	//QƃIuWFNĝ݂͖ł
			unsigned nSelStatus = (*pObjIte)->testSelection(rc);
			if(nSelStatus){
				SXBSchObj* pNewObj = (*pObjIte)->duplicate();
				(*pObjIte)->setRefObj(pNewObj);
				pNewObj->setRefObj(*pObjIte);
				pNewObj->setSelection(nSelStatus);
				m_listTemp.push_back(pNewObj);
			}
		}
		*pObjIte++;
	}
	setupRcTempArea();
	setupRotateRect();

	m_bSelectForDrag = false;
	return m_listTemp.size();
}



bool SXBSchDoc::resetSelect_1(bool bDel)
{
	//ꎞIuWFNg̃XgȂ牽Ȃ
	if(m_listTemp.size() == 0) return false;

	m_nOpCount++;
	m_bDirty = true;	

	XBSchObjListIterator pObjIte = m_listTemp.begin();
	while(pObjIte != m_listTemp.end()){
		if((*pObjIte)->refObj()){ //ꎞIuWFNgQƃIuWFNgꍇAQƃIuWFNg͌̃f[^wB
			SXBSchObj* pOldObj = (*pObjIte)->refObj();
			//폜IuWFNg̒ǉ
			SXBSchDelObj* pDelObj = new SXBSchDelObj;
			//qDebug("Add DeleteObj");
			pDelObj->setPlaceNum(m_nOpCount);	
			pDelObj->setRefObj(pOldObj); //폜IuWFNgrefObj()ɂ͑ΏۃIuWFNgւ̃|C^Zbg
			pOldObj->setRefObj(pDelObj); //̃IuWFNgɂ͍폜IuWFNgւ̃|C^Zbg
			m_listMain.push_back(pDelObj);
		}
		if(!bDel){
			//ꎞf[^C̃Xgɒǉ
			if((*pObjIte)->qValid()){
				(*pObjIte)->setPlaceNum(m_nOpCount);		//ԍXV
				(*pObjIte)->setRefObj(NULL);				//QƃIuWFNg͋ɂiLf[^ɂȂj
				(*pObjIte)->resetSelection();				//ItONAB
				m_listMain.push_back(*pObjIte);
			}
		}else{
			//ꎞf[^
			delete (*pObjIte);
		}
		*pObjIte++;
	}
	m_listTemp.clear();
	m_bSelectForDrag = false;

	delOldData(m_nOpCount-10);		//Undo񐔂̐

	return true;
}

//m_rcTempArea  m_ptTempSnapPoint ꎞIuWFNg̃Xgݒ肷B
void SXBSchDoc::setupRcTempArea()
{
	if(m_listTemp.size() == 0)return;
	m_rcTempArea = SRect(SPoint(INT_MAX,INT_MAX),SPoint(INT_MIN,INT_MIN));

	XBSchObjListIterator pObjIte = m_listTemp.begin();
	bool bFind1st = true;
	while(pObjIte != m_listTemp.end()){
		m_rcTempArea |= (*pObjIte)->area();
		if(bFind1st){
			m_ptTempSnapPoint = (*pObjIte)->snapPoint();
			bFind1st = false;
		}
		pObjIte++;
	}
}

void SXBSchDoc::setupRotateRect()
{
	if(m_listTemp.size() == 0)return;
	m_rcRotateRect = SRect(SPoint(INT_MAX,INT_MAX),SPoint(INT_MIN,INT_MIN));

	XBSchObjListIterator pObjIte = m_listTemp.begin();
	while(pObjIte != m_listTemp.end()){
		m_rcRotateRect |= (*pObjIte)->rotateRect();
		pObjIte++;
	}
	//qDebug("%d,%d\n",m_rcRotateRect.l(),m_rcRotateRect.r());
}



bool SXBSchDoc::writeMinimumLb3(SWriteCE3& wce3,XBSchObjList* pList,bool bOwnOnly)
{
//typedef list<SCompIndex*> SCompIndexList;
//typedef list<SCompIndex*>::iterator SCompIndexListIterator;

	return true;
}


bool SXBSchDoc::writeCe3(SWriteCE3& wce3,XBSchObjList* pList,bool bAllObj,const SPoint* pptOrigin)
{
	SRect rcSheet(0,0,m_sizeSheet.w(),m_sizeSheet.h());
	if(pList){
		XBSchObjListIterator pObjIte = pList->begin();
		while(pObjIte != pList->end()){
			if(bAllObj || !(*pObjIte)->refObj()){
				if(rcSheet.intersect((*pObjIte)->area())){
					(*pObjIte)->writeCe3(wce3,pptOrigin);
				}
			}
			pObjIte++;
		}
	}
	return true;
}


bool SXBSchDoc::readCe3(SReadCE3& rce3,XBSchObjList* pList,const SPoint* pptOrigin,SXBSchSheetInfo* pSheetInfo)
{

	assert(pList!=NULL);
	string str;
	bool bFirstSheetInfo = true;
	SXBSchObj* pObj;
	while(rce3.ReadRecord(str)!=EOF){
		if(str == "") break;		//̃R[h͖
		pObj = NULL;
		if(str == "+SHEETINFO" && bFirstSheetInfo && pSheetInfo){
			bFirstSheetInfo = false;
			if(! pSheetInfo->readCe3(rce3,pptOrigin,this)) return false;
		}else if(str == "+JUNCTION"){
				pObj = new SXBSchJunc;
		}else if(str == "+LABEL"){
				pObj = new SXBSchLabel;
		}else if(str == "+COMMENT"){
				pObj = new SXBSchComment;
		}else if(str == "+TAG"){
				pObj = new SXBSchTag;
		}else if(str == "+WIRE"){
				pObj = new SXBSchWire;
		}else if(str == "+BUS"){
				pObj = new SXBSchBus;
		}else if(str == "+DASH"){
				pObj = new SXBSchDash;
		}else if(str == "+ENTRY"){
				pObj = new SXBSchEntry;
		}else if(str == "+BENTRY"){
				pObj = new SXBSchBusEntry;
		}else if(str == "+COMPONENT"){
				pObj = new SXBSchComponent;
		}else if(str == "-BSCH3_DATA_V.1.0"){
			return true;
		}else{
			if(str[0] != '+') return false;
			str[0]='-';
			if(rce3.SkipTo(str)==EOF) return false;
			//if(rce3.SkipTo(str.replace(1,1,"-")) != SCsvIStream::GETRECORD_NORMAL)return false;
		}
		if(pObj){
			if(pObj->readCe3(rce3,pptOrigin,this)){
				if(pObj->qValid()){
					pList->push_back(pObj);
				}else{
					delete pObj;
				}
			}else{
				delete pObj;
				return false;
			}
		}
	}		
	return true;
}





//Ỉ
//ỈƂ́A
//  ꎞf[^w̃IuWFNgwu폜IuWFNgvC̃Xgɒǉ
//                      ꎞf[^C̃Xgɒǉ邱
bool SXBSchDoc::resetSelect()
{
	return resetSelect_1(false);
}


//
void SXBSchDoc::init()
{
	m_bDirty = false;
	m_nOpCount = 0;
	m_nOldestOpCount = 0;

	XBSchObjListIterator pObjIte;

	pObjIte = m_listMain.begin();

	while(pObjIte != m_listMain.end()){
		delete (*pObjIte);
		pObjIte++;
	}
	m_listMain.clear();

 	pObjIte = m_listTemp.begin();
	while(pObjIte != m_listTemp.end()){
		delete (*pObjIte);
		pObjIte++;
	}
	m_listTemp.clear();

//printf("\n");
//printf("SXBSchDoc::init() m_listMain.count()=%d,m_listTemp.count()=%d\n",m_listMain.count(),m_listTemp.count());
}

//t@C̓ǂݍ
//I0Ԃ
//  1:t@Cǂݍ݃G[
//  2:BSCH3t@Cł͂Ȃ
int SXBSchDoc::readFile(const char* fname)
{
	init();
	m_bDirty = false;
	FILE* fp;
	if((fp = fopen(fname,"r"))==NULL) return 1;
	SReadCE3 rce3;
	rce3.Attach(fp);

	string str;
	if(rce3.ReadRecord(str)==EOF){	//̃t@ĈƂ̏
		fclose(fp);
		return 0;
	}
	SXBSchSheetInfo sheetInfo;
	if(str != "+BSCH3_DATA_V.1.0") return 2;
	if(readCe3(rce3,&m_listMain,NULL,&sheetInfo)){
		m_sizeSheet.setW(sheetInfo.width());
		m_sizeSheet.setH(sheetInfo.height());
		fclose(fp);
		return 0;
	}else{
		fclose(fp);
		return 1;
	}		
}

//t@Cւ̏
//I0Ԃ
int SXBSchDoc::writeFile(const char* fname)
{
	resetSelect();
	FILE* fp;
	if((fp = fopen(fname,"w"))==NULL) return 1;
	SWriteCE3 wce3;
	wce3.Attach(fp);
	SXBSchSheetInfo sheetInfo;
	sheetInfo.setWidth( m_sizeSheet.w() );
	sheetInfo.setHeight( m_sizeSheet.h() );

	wce3.WriteRecord("+BSCH3_DATA_V.1.0");
	wce3.WriteEOL();
	sheetInfo.writeCe3(wce3,NULL);
	writeCe3(wce3,&m_listMain,false,NULL);
	wce3.WriteRecord("-BSCH3_DATA_V.1.0");
	if(wce3.WriteEOL()==EOF){
		fclose(fp);
		return 1;
	}else{		
		fclose(fp);
		init();
		readFile(fname);
		m_bDirty = false;
		return 0;
	}
}

/*
// ***** Qtˑ *****
//Rs[
//Rs[sꂽƂtrueԂ
bool SXBSchDoc::copy()
{
	if(!m_listTemp.size())return false;
	SPoint ptOrigin = SPoint(m_rcTempArea.l(),m_rcTempArea.t());
	ptOrigin.setX(((ptOrigin.x()+5)/10)*10);
	ptOrigin.setY(((ptOrigin.y()+5)/10)*10);

	string str;
	SWriteCE3 wce3;
	wce3.Attach(&str);

	wce3.WriteRecord("+BSCH3_DATA_V.1.0");
	wce3.WriteEOL();
	writeCe3(wce3,&m_listTemp,true,&ptOrigin);
	wce3.WriteRecord("-BSCH3_DATA_V.1.0");
	wce3.WriteEOL();

    QClipboard *cb = QApplication::clipboard();
    cb->setText(QString::fromLocal8Bit(str.c_str()));
	
	return true;
}
*/

//폜
//hLgɕύXƂtrueԂ
bool SXBSchDoc::del()
{
	m_bDirty = true;	
	return resetSelect_1(true);
}

//؂
//hLgɕύXƂtrueԂ
bool SXBSchDoc::cut()
{
	if(copy()){
		return del();
	}
	return false;
}

/*
// ***** Qtˑ *****
//\t
//hLgɕύXƂtrueԂ
bool SXBSchDoc::paste(const SPoint& pt)
{
	if(!canPaste()) return false;
    QClipboard *cb = QApplication::clipboard();
	string cbbuff=string(cb->text().local8Bit());

	SReadCE3 rce3;
	rce3.Attach(cbbuff.c_str());

	string str;

	rce3.ReadRecord(str);
	if(str != "+BSCH3_DATA_V.1.0") return false;

	readCe3(rce3,&m_listTemp,&pt,NULL);
	if(!m_listTemp.size()) return false;
	
	setupRcTempArea();

	m_bDirty = true;	
	return true;
}
*/


//Undo
//hLgɕύXƂtrueԂ
bool SXBSchDoc::undo()
{
//printf("SXBSchDoc::undo() %d %d\n",m_nOpCount, m_nOldestOpCount);
	bool bResult = 	resetSelect();
	if(m_nOpCount <= m_nOldestOpCount){
		return bResult;
	}

	int nCount = m_listMain.size();
	if(nCount==0) return bResult;

	XBSchObjListIterator pObjIte =m_listMain.begin();
	while(nCount && pObjIte!=m_listMain.end()){
		if((*pObjIte)->placeNum() == m_nOpCount){ //UndoΏۂ̃IuWFNgȂ...
			if((*pObjIte)->id() == SXBSchObj::ID_DELETEOBJ){		//   ꂪA폜IuWFNgȂ
				(*pObjIte)->refObj()->setRefObj(NULL);				//		폜IuWFNg̎QƂĂIuWFNg폜Ô
			}														//   Ȃ̂ŁA𕜊
			delete (*pObjIte);										//UndoΏۂ̃IuWFNg
			pObjIte = m_listMain.erase(pObjIte);					//erase()ŃJgm[h͈i
		}else{
			pObjIte++;
		}
		nCount--;
	}

	m_nOpCount--;
	return true;
}

//AttributeύX\?
bool SXBSchDoc::canAttribute()
{
	int n=m_listTemp.size();
	if(n!=1) return false;
	XBSchObjListIterator pObjIte =m_listTemp.begin();
	return (*pObjIte)->canAttribute();
}

//Rs[\H
bool SXBSchDoc::canCopy()
{
	return (m_listTemp.size()>0);
}

//폜\H
bool SXBSchDoc::canDel()
{
	return (m_listTemp.size()>0);
}

//؂\H
bool SXBSchDoc::canCut()
{
	return (m_listTemp.size()>0);
}

/*
//\t\H
bool SXBSchDoc::canPaste()
{
	QString strID("+BSCH3_DATA_V.1.0");
	QClipboard *cb = QApplication::clipboard();
    QString str = cb->text().left(strID.length());	
	return (str == strID);
}
*/

//Undo\H
bool SXBSchDoc::canUndo()
{
	return (m_nOpCount > m_nOldestOpCount);
}



//Rotate
bool SXBSchDoc::rotate()
{
	if(!canRotate()) return false;

	setupRotateRect();

	int n = m_listTemp.size();
	XBSchObjListIterator pObjIte = m_listTemp.begin();
	if(n == 1){
		(*pObjIte)->rotate();
	}else{
		SPoint ptCenter = m_rcRotateRect.center();
		ptCenter.setX(((ptCenter.x()+5)/10)*10);
		ptCenter.setY(((ptCenter.y()+5)/10)*10);
		//int x=(m_rcRotateRect.l()+m_rcRotateRect.r())/2;
		//int y=(m_rcRotateRect.t()+m_rcRotateRect.bottom())/2;
		//SPoint ptCenter(x,y);
		while(pObjIte != m_listTemp.end()){
			(*pObjIte)->rotate(ptCenter);
			pObjIte++;
		}
	}
	setupRcTempArea();

	m_bDirty = true;	
	return true;
}

//Mirror
bool SXBSchDoc::mirror()
{
	if(!canMirror()) return false;

	setupRotateRect();

	int n = m_listTemp.size();
	XBSchObjListIterator pObjIte = m_listTemp.begin();
	if(n == 1){
		(*pObjIte)->mirrorH();
	}else{
		int nCenter = (m_rcRotateRect.l()+m_rcRotateRect.r())/2;
		while(pObjIte != m_listTemp.end()){
			(*pObjIte)->mirrorH(nCenter);
			pObjIte++;
		}
	}
	setupRcTempArea();
	m_bDirty = true;	
	return true;
}


//Rotate\H
bool SXBSchDoc::canRotate()
{
	if(m_listTemp.size() == 0) return false;
	if(m_bSelectForDrag) return false;
	return true;
}

//Mirror\H
bool SXBSchDoc::canMirror()
{
	if(m_listTemp.size() == 0) return false;
	if(m_bSelectForDrag) return false;
	return true;
}



//Âf[^̍폜
//   C̃Xg̐擪XLāAw肵l̑JEgl
// 菬Ȓlł̍폜sIuWFNgB
//   폜IuWFNgƂɑΉ폜IuWFNg̃Xgł
// ʒuɒڂƁAȂ炸A폜IuWFNg̕擪ɋ߂
// ɑ݂B
void SXBSchDoc::delOldData(int nOpCount)
{
	bool bDel;
	resetSelect();
	if(nOpCount <= m_nOldestOpCount) return;
	
	int nDelObj=0;
	int nDelDelObj=0;


	XBSchObjListIterator pObjIte = m_listMain.begin();
	while(pObjIte!=m_listMain.end()){
		bDel = false;
		if((*pObjIte)->id() != SXBSchObj::ID_DELETEOBJ){
			if((*pObjIte)->refObj()!=NULL){
				SXBSchObj* pDelObj = (*pObjIte)->refObj();
				if(pDelObj->placeNum() < nOpCount){
					bDel = true;
					nDelObj++;
				}
			}
		}else{
			if((*pObjIte)->placeNum() < nOpCount){
				bDel = true;
				nDelDelObj++;
			}
		}
		if(bDel){
			delete (*pObjIte);						//UndoΏۂ̃IuWFNg
			pObjIte = m_listMain.erase(pObjIte);	//erase()ŃJgm[h͈i
		}else{
			pObjIte++;
		}
	}
	if(nOpCount > m_nOpCount) nOpCount = m_nOpCount;
	m_nOldestOpCount = nOpCount;

	//qDebug("delOldData(%d)   %d   %d",nOpCount,nDelObj,nDelDelObj);

	return;
}

//w肵Wꎞf[^̏ォǂ
int SXBSchDoc::isOnTempData(const SPoint& pt)
{
	if(m_listTemp.size() == 0) return 0;
	if(m_listTemp.size() == 1){
		XBSchObjListIterator pObjIte = m_listTemp.begin();
		int val= (*pObjIte)->qSelectWeight(pt) & (ON_OBJ|ON_NAME|ON_NUM);
		if(val)return val;
	}
	if(m_rcTempArea.intersect(pt)) 	return ON_OBJ;
	return 0;
}

//ꎞf[^ړ
void SXBSchDoc::moveTempData(int offsetx,int offsety)
{
	XBSchObjListIterator pObjIte = m_listTemp.begin();
	while(pObjIte != m_listTemp.end()){
		(*pObjIte)->move(offsetx,offsety);
		pObjIte++;
	}
	m_rcTempArea+=SPoint(offsetx,offsety);
	m_ptTempSnapPoint.setX(m_ptTempSnapPoint.x()+offsetx);
	m_ptTempSnapPoint.setY(m_ptTempSnapPoint.y()+offsety);
	m_bDirty = true;	
}

//͈͓̐ڍ_̑IBׂĂ̐ڍ_ m_listWorkJunc ɒoB
//
void SXBSchDoc::selectForDragJunction(int scanMax,const SRect& rc)
{
	XBSchObjListIterator pObjIte = m_listMain.begin();
	while(scanMax>0 && pObjIte != m_listMain.end()){
		if((*pObjIte)->id()==SXBSchObj::ID_JUNCTION && (*pObjIte)->refObj()==NULL){	//QƃIuWFNĝ݂͖ł
			unsigned nSelStatus = (*pObjIte)->testSelection(rc);
			if(nSelStatus){
				SXBSchObj* pNewObj = (*pObjIte)->duplicate();	//IIuWFNg̕
				(*pObjIte)->setRefObj(pNewObj);					//IuWFNgɕIuWFNgݒ
				pNewObj->setRefObj(*pObjIte);					//VIuWFNgɌIuWFNgݒ
				pNewObj->setSelection(nSelStatus);				//VIuWFNgɑItOݒ
				m_listTemp.push_back(pNewObj);					//VIuWFNgꎞf[^ɕۊ
			}
		}
		*pObjIte++;
		scanMax--;
	}
}

//ׂĂ̐ڍ_ m_listWorkJunc ɒoB
void SXBSchDoc::pickupJunction(const SRect& )
{
	XBSchObjListIterator pObjIte = m_listMain.begin();
	while(pObjIte != m_listMain.end()){
		if((*pObjIte)->id()==SXBSchObj::ID_JUNCTION && (*pObjIte)->refObj()==NULL){	//QƃIuWFNĝ݂͖ł
			m_listWorkJunc.push_back(*pObjIte);					//IO̐ڍ_ƃGAɕۊ
		}
		*pObjIte++;
	}
}



//hbÔ߂̐ڍ_C[ȊȎI
void SXBSchDoc::selectForDragExceptJuncWire(int scanMax,const SRect& rc)
{
	int scan=0;
	XBSchObjListIterator pObjIte = m_listMain.begin();
	while(scan<scanMax && pObjIte != m_listMain.end()){
		if( (*pObjIte)->id()!=SXBSchObj::ID_JUNCTION && 
			(*pObjIte)->id()!=SXBSchObj::ID_WIRE && 
			(*pObjIte)->refObj()==NULL){
			unsigned nSelStatus = (*pObjIte)->testSelectionForDrag(rc);
			if(nSelStatus){
				SXBSchObj* pNewObj = (*pObjIte)->duplicate();	//IIuWFNg̕
				(*pObjIte)->setRefObj(pNewObj);					//IuWFNgɕIuWFNgݒ
				pNewObj->setRefObj(*pObjIte);					//VIuWFNgɌIuWFNgݒ
				pNewObj->setSelection(nSelStatus);				//VIuWFNgɑItOݒ
				m_listTemp.push_back(pNewObj);					//VIuWFNgꎞf[^ɕۊ
				int pincount=pNewObj->pinCount();
				//qDebug("SXBSchDoc::selectForDragExceptJuncWire()  PINCOUNT=%d",pincount);
				for(int n=0;n<pincount;n++){
					SPoint pt=pNewObj->pinPosition(n);
					if(!rc.intersect(pt)){
						SRect rcPin(pt,pt);
						selectForDragJunction(scanMax,rcPin);
						selectForDragWire(scanMax,rcPin);
					}
				}
			}
		}
		*pObjIte++;
		scan++;
	}
}


//hbÔ߂̃C[IB
void SXBSchDoc::selectForDragWire(int scanMax,const SRect& rc)
{
	SXBSchWire* pNewWire[5];

	int workWireCount= m_listWorkWire.size();	//m_listWorkWire͑邪A rcŒǉ͍̂ăXLȂB
												//selectForDragōŏ͈͎̔wł̃C[IłworkWireCount0ɂȂB

	XBSchObjListIterator pObjIte = m_listMain.begin();
	while(scanMax>0 && pObjIte != m_listMain.end()){
		if((*pObjIte)->id()==SXBSchObj::ID_WIRE && (*pObjIte)->refObj()==NULL){	//QƃIuWFNĝ݂͖ł
			SXBSchWire* pObj= (SXBSchWire*)(*pObjIte);
			int divcount = divideWire(pObj,rc,pNewWire);
			if(divcount>0){
				SXBSchDelObj* pDelObj = new SXBSchDelObj;		//IuWFNg邽߂̏IuWFNg쐬
				(*pObjIte)->setRefObj(pDelObj);					//IuWFNgɏIuWFNgݒ
				pDelObj->setRefObj(*pObjIte);					//IuWFNgɋIuWFNgݒ
				pDelObj->setPlaceNum(m_nOpCount+1);				
				m_listMain.push_back(pDelObj);					//IuWFNgCf[^ɕۊ
				for(int n=0;n<divcount;n++){
					m_listWorkWire.push_back(pNewWire[n]);
				}
			}
		}
		*pObjIte++;
		scanMax--;
	}

	pObjIte = m_listWorkWire.begin();
	while(workWireCount>0 && pObjIte != m_listWorkWire.end()){
		if((*pObjIte)->refObj()==NULL){	//QƃIuWFNĝ݂͖ł
			SXBSchWire* pObj= (SXBSchWire*)(*pObjIte);
			int divcount = divideWire(pObj,rc,pNewWire);
			if(divcount>0){
				(*pObjIte)->setRefObj(pNewWire[0]);
				for(int n=0;n<divcount;n++){
					m_listWorkWire.push_back(pNewWire[n]);
				}
			}
		}
		*pObjIte++;
		workWireCount--;
	}

}


//hbOIł̓C[̕duplicate()ł͂ȂAdivideWire()ōsB
// ꂽIuWFNgɂ͑ItOݒ肳B
//C[hbOΏۂłȂꍇ͕ȂB
//hbOΏۂƔhbOΏۂɕꍇ̓hbOΏۂ̂̂擪Ɋi[B
int SXBSchDoc::divideWire(SXBSchWire* swire,const SRect& rc,SXBSchWire** dwire)
{
	int retval=0;
	bool vFlag;
	int fixval,jfix,jp;
	int p0,p1,p2,p3,p4,p5;
	int	boundaryMin,boundaryMax;
	unsigned int nSelStatus;
	unsigned int nOldSelStatus;

	if(!swire->qValid()) return 0;

	nOldSelStatus = (swire->selection() & (SXBSchObj::SELECT_P1|SXBSchObj::SELECT_P2));
	nSelStatus = swire->testSelectionForDrag(rc);

	//xÎăXL邷ꍇ̃`FbN
	if(nOldSelStatus){
		swire->setSelection(nOldSelStatus | nSelStatus);
		return 0;
	}

	nSelStatus = swire->testSelectionForDrag(rc);
	if((nSelStatus&(SXBSchObj::SELECT_P1|SXBSchObj::SELECT_P2)) ==SXBSchObj::SELECT_ALL){	//[_͈͓̂Ƃ
		dwire[0] = (SXBSchWire*)(swire->duplicate());
		dwire[0]->setSelection(nSelStatus);
		return 1;
	}
	if(swire->x1()==swire->x2()){	//̂Ƃ
		if(swire->x1()<rc.l() || swire->x1()>rc.r()) return 0;	//E͈͊O
		if(swire->y1()<rc.t() && swire->y2()<rc.t()) return 0;	//ɔ͈͊O
		if(swire->y1()>rc.b() && swire->y2()>rc.b()) return 0;	//ɔ͈͊O
		vFlag = true;
		fixval = swire->x1();
		p0 = swire->y1();
		p5 = swire->y2();
		boundaryMin = rc.t();
		boundaryMax = rc.b();
	}else if(swire->y1()==swire->y2()){	//̂Ƃ
		if(swire->y1()<rc.t() || swire->y1()>rc.b()) return 0;	//㉺͈͊O
		if(swire->x1()<rc.l() && swire->x2()<rc.l()) return 0;	//ɔ͈͊O
		if(swire->x1()>rc.r() && swire->x2()>rc.r()) return 0;	//Eɔ͈͊O
		vFlag = false;
		fixval = swire->y1();
		p0 = swire->x1();
		p5 = swire->x2();
		boundaryMin = rc.l();
		boundaryMax = rc.r();
	}else{	//΂ߐ̂Ƃ͕ȂB
		if(nSelStatus!=0){
			dwire[0]=(SXBSchWire*)(swire->duplicate());
			dwire[0]->setSelection(nSelStatus);
			return 1;
		}else{
			return 0;
		}
	}
	if(p0>p5){ int i=p5; p5=p0; p0=i; }

	p3=p1=p0;
	p2=p4=p5;

	if(p0>=boundaryMin) p2=p0;
	if(p5<=boundaryMax) p3=p5;
	XBSchObjListIterator pObjIte = m_listWorkJunc.begin();
	while(pObjIte != m_listWorkJunc.end()){
		SXBSchJunc* pJunc = (SXBSchJunc*)(*pObjIte);
		if(vFlag){  jfix = pJunc->x1();	jp	 = pJunc->y1();	}
		else{		jfix = pJunc->y1();	jp	 = pJunc->x1();	}
		if(jfix==fixval && jp>p1 && jp<p4){
			if(jp<boundaryMin){			//p1XV`FbN(boundaryMin菬čő)
				p1=jp;
			}else if(jp>boundaryMax){	//p4XV`FbN(boundaryMax傫čŏ)
				p4=jp;
			}else{	//ڍ_͔͈͓
				if(jp>p3) p3=jp;
				if(jp<p2) p2=jp;
			}
		}
		pObjIte++;
	}
	if(p2>p3){//͈͓ɒ[_ڍ_Ȃꍇ͕Ȃ
		return 0;
	}
	if(p2<p3){//͈͓ɗ[_C[
		dwire[retval]=new SXBSchWire;
		if(vFlag){
			dwire[retval]->setP1(SPoint(fixval,p2));
			dwire[retval]->setP2(SPoint(fixval,p3));
		}else{
			dwire[retval]->setP1(SPoint(p2,fixval));
			dwire[retval]->setP2(SPoint(p3,fixval));
		}
		dwire[retval]->setSelection(SXBSchObj::SELECT_ALL);
		retval++;
	}
	if(p1<p2){//͈͓P2[_C[
		dwire[retval]=new SXBSchWire;
		if(vFlag){
			dwire[retval]->setP1(SPoint(fixval,p1));
			dwire[retval]->setP2(SPoint(fixval,p2));
		}else{
			dwire[retval]->setP1(SPoint(p1,fixval));
			dwire[retval]->setP2(SPoint(p2,fixval));
		}
		dwire[retval]->setSelection(SXBSchObj::SELECT_P2);
		retval++;
	}
	if(p3<p4){//͈͓P1[_C[
		dwire[retval]=new SXBSchWire;
		if(vFlag){
			dwire[retval]->setP1(SPoint(fixval,p3));
			dwire[retval]->setP2(SPoint(fixval,p4));
		}else{
			dwire[retval]->setP1(SPoint(p3,fixval));
			dwire[retval]->setP2(SPoint(p4,fixval));
		}
		dwire[retval]->setSelection(SXBSchObj::SELECT_P1);
		retval++;
	}
	if(p0<p1){//͈͊OɃC[
		dwire[retval]=new SXBSchWire;
		if(vFlag){
			dwire[retval]->setP1(SPoint(fixval,p0));
			dwire[retval]->setP2(SPoint(fixval,p1));
		}else{
			dwire[retval]->setP1(SPoint(p0,fixval));
			dwire[retval]->setP2(SPoint(p1,fixval));
		}
		retval++;
	}
	if(p4<p5){//͈͊OɃC[
		dwire[retval]=new SXBSchWire;
		if(vFlag){
			dwire[retval]->setP1(SPoint(fixval,p4));
			dwire[retval]->setP2(SPoint(fixval,p5));
		}else{
			dwire[retval]->setP1(SPoint(p4,fixval));
			dwire[retval]->setP2(SPoint(p5,fixval));
		}
		retval++;
	}
	return retval;
}


int SXBSchDoc::selectForDrag(const SRect& rc)
{
	//ꎞf[^̉
	resetSelect();
	m_listWorkJunc.clear();
	m_listWorkWire.clear();

	int scanMax = m_listMain.size();

	//ڍ_̑Iƒo
	pickupJunction(rc);
	selectForDragJunction(scanMax,rc);

	//C[̑I
	//͈͓Oɂ܂̂̓WNVɂ镪s
	selectForDragWire(scanMax,rc);

	//ڍ_AC[ȊȎI
	selectForDragExceptJuncWire(scanMax,rc);

	XBSchObjListIterator pObjIte = m_listWorkWire.begin();
	while(pObjIte != m_listWorkWire.end()){
		if((*pObjIte)->refObj()==NULL){	//QƃIuWFNgȂ̂L
			if((*pObjIte)->selection()!=0){	//ItOtĂ͈̂ꎞf[^ɃRs[
				m_listTemp.push_back(*pObjIte);
			}else{
				(*pObjIte)->setPlaceNum(m_nOpCount+1);
				m_listMain.push_back(*pObjIte);
			}
		}else{
			delete(*pObjIte);
		}
		pObjIte++;
	}

	
	setupRcTempArea();
	setupRotateRect();
	m_listWorkJunc.clear();
	m_listWorkWire.clear();
	m_bSelectForDrag = true;
	return m_listTemp.size();
}
