/****************************************************************************
    BSch3V and utility
    Copyright (C) 2004-2006 H.Okada (http://www.suigyodo.com/online)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/

#include "stdafx.h"
#include "sptnobjpolygon.h"

SPtnObjPolygon::SPtnObjPolygon(void)
{
	m_nCount = 0;			//_̐
	m_pPt = NULL;			//_W
	//m_nFill = -1;
}

SPtnObjPolygon::~SPtnObjPolygon(void)
{
	delete[]m_pPt;
}

//K אڂ_ŴƂɒ_폜
void SPtnObjPolygon::normalize()
{
	int i,j,n,m;
	m=m_nCount-1;
	n=0;
	//אڂ_̃XL
	for(i=0;i<m;i++){
		if(m_pPt[i]==m_pPt[i+1]) n++;
	}
	if(m_pPt[m]==m_pPt[0]) n++;
	if(n==0) return;

	//V|S̒_̊m
	int newCount = m_nCount - n;
	if(newCount<=1){
		m_nCount = 0;
		delete[]m_pPt;
		m_pPt = NULL;
		return;
	}
	SPoint* pPt = new SPoint[newCount];

	//_̃Rs[
	j=0;
	for(i=0;i<m;i++){
		if(m_pPt[i]!=m_pPt[i+1]){
			pPt[j++] = m_pPt[i];
		}
	}
	if(m_pPt[m]!=m_pPt[0]) pPt[j] = m_pPt[m];

	m_nCount = newCount;
	delete[]m_pPt;
	m_pPt = pPt;
}

//L͈͂Ԃ
SRect SPtnObjPolygon::area()
{

	int left = INT_MAX;
	int top	= INT_MAX;
	int right = INT_MAX;
	int bottom = INT_MAX;
	if(m_nCount>0){
		left = right = m_pPt[0].x();
		top = bottom = m_pPt[0].y();
		int i;
		for(i=1;i<m_nCount;i++){
			int x = m_pPt[i].x();
			int y = m_pPt[i].y();
            if(left>x)		left = x;
			if(right<x)		right =x;
			if(top>y)		top	= y;
			if(bottom<y)	bottom = y;
		}
	}
	return SRect(left,top,(right-left),(bottom-top));
}


//Rs[RXgN^
SPtnObjPolygon::SPtnObjPolygon(const SPtnObjPolygon& obj)
{
	m_pPt = NULL;
	*this = obj;
}

//Zq
SPtnObjPolygon& SPtnObjPolygon::operator=(const SPtnObjPolygon& obj)
{
	if(this != &obj){
		(SPtnObj&)*this = obj;	//{NX̃o[̃Rs[
		m_nFill = obj.m_nFill;
		delete[]m_pPt;
		m_nCount = obj.m_nCount;
		if(m_nCount>0){
			m_pPt = new SPoint[m_nCount];
			int i;
			for(i=0;i<m_nCount;i++){
				m_pPt[i] = obj.m_pPt[i];
			}
		}else{
			m_pPt = NULL;
		}
	}
	return *this;
}

//
SPtnObj* SPtnObjPolygon::duplicate()
{
	return new SPtnObjPolygon(*this);
}

//Obv̈ʒuԂ
SPoint SPtnObjPolygon::gripPos(int grip)
{
	if(m_nCount==0 || m_pPt==NULL) return SPoint(0,0);
	if(grip<0) grip = 0;
	else if(grip>=m_nCount) grip = m_nCount;
	return m_pPt[grip];
}

//Obv̈ʒu𓮂
void SPtnObjPolygon::setGripPos(int grip,int x,int y)
{
	if(m_nCount==0 || m_pPt==NULL) return;
	if(grip<0) grip = 0;
	else if(grip>=m_nCount) grip = m_nCount;
	m_pPt[grip] = SPoint(x,y);
}

//Lȃf[^ǂԂB
bool SPtnObjPolygon::qValid()
{
	normalize();
	if(m_nCount>0) return true;
	else return false;
}

//ʒu𓮂
void SPtnObjPolygon::move(int offsetx,int offsety)
{
	SPoint ptOffset(offsetx,offsety);
	int i;
	for(i=0;i<m_nCount;i++){
		m_pPt[i]+=ptOffset;
	}
}

//XWw肵čE]s
void SPtnObjPolygon::mirrorH(int x)
{
	int i;
	for(i=0;i<m_nCount;i++){
		m_pPt[i] = mirrorPoint(m_pPt[i],x);
	}
}

//E]s
void SPtnObjPolygon::mirrorH()
{
	SRect rc = area();
	int x = rc.center().x();
	mirrorH(x);
}

//XYSWw肵āA]s
void SPtnObjPolygon::rotate(const SPoint& p)
{
	int i;
	for(i=0;i<m_nCount;i++){
		m_pPt[i] = rotatePoint(m_pPt[i],p);
	}
}

//]s
void SPtnObjPolygon::rotate()
{
	SRect rc = area();
	SPoint p = rc.center();
	rotate(p);
}

//͈͂w肵đI`FbNs
bool SPtnObjPolygon::testIntersect(const SRect& rc)
{
	SRect rc1 = area();
	if(!rc.intersect( SPoint(rc1.l(),rc1.t()) ) ) return false;
	if(!rc.intersect( SPoint(rc1.r(),rc1.b()) ) ) return false;
	return true;
}

//_w肵đI`FbNs
//2_̂Ƃ͐Ɩʐς_Ƃ̌Ŕ
//3_ȏ̂Ƃ́A(p.x(),INT_MIN)(p.x(),p.y()) ̐p`̐Ɗ邩ǂŔ
bool SPtnObjPolygon::testIntersect(const SPoint& p)
{
	int x,y,x0,y0,x1,y1;
	normalize();
	if(m_nCount<2) return false;
	if(m_nCount==2){
		return testIntersectLinePoint(m_pPt[0],m_pPt[1],p);
	}

	SRect rc=area();
	if(!rc.intersect(p)) return false;

	int i,j;
	unsigned acrossFlag=0;
	x=p.x();
	y=p.y();
	for(i=0;i<m_nCount;i++){
		j=i+1;
		if(j==m_nCount)j=0;
		if(testIntersectLinePoint(m_pPt[i],m_pPt[j],p))return true;	//_ɂtrue
		if(m_nFill<0)continue;
		x0 = m_pPt[i].x();
		y0 = m_pPt[i].y();
		x1 = m_pPt[j].x();
		y1 = m_pPt[j].y();
		if(x0==x1) continue;							//͔̐ɉeȂ
		if((x0<x && x1<x)||(x0>x && x1>x)) continue;	//xʂ鐂A܂Ȃ͔̂ɉeȂB
		if(y0>y && y1>y) continue;						//[_p_ɂ͔̂ɉeȂB
		if(y0<y && y1<y){								//[_p_ɂ͔̂萂ƌ
				acrossFlag ^=3;
				continue;
		}
		if(x==x0 && y>y0){			//p0_萂ɂꍇ
			if(x1>x){
				acrossFlag ^=1;
			}else{
				acrossFlag ^=2;
			}
			continue;
		}
		if(x==x1 && y>y1){			//p1_萂ɂꍇ
			if(x0>x){
				acrossFlag ^=1;
			}else{
				acrossFlag ^=2;
			}
			continue;
		}
		if(((y1-y0)*(x-x0))/(x1-x0)+y0 < y) acrossFlag ^=3;
	}
	if(acrossFlag == 3) return true;
	else return false;
}
			

bool SPtnObjPolygon::readCe3(SReadCE3& rce3)
{
	SPoint ptbuff[VECTPLOYGON_MAXNODE];

	delete[]m_pPt;
	m_pPt = NULL;
	m_nCount=0;

	int width = 1;
	int style = 0;
	int fill = -1;
	int x,y,prevX,prevY;
	int sety = 0;

	int node,realnode;

	realnode=0;

	node = 0;
	x=0;
	y=0;
	prevX=INT_MIN;	//Kȏl
	prevY=INT_MIN;	//Kȏl
	string str("");

	while(rce3.ReadRecord(str)!=EOF){
		if(str[0] == '-'){
			if(str != "-PG"){
				return false;
			}else{
				break;
			}
		}else if(str[0] == '+'){
			str[0]='-';
			if(rce3.SkipTo(str) == EOF) return false;
		}else{
			int n;
			int l=str.length();
			for(n=0;n<l;n++){
				if(str[n]==':') break;
			}
			if(0<n && n<(l-1)){	// : ŕꂽR[hł
				string var = str.substr(0,n);				//擪:̎O܂
				if(var=="W"){
					width = atoi(str.substr(n+1).c_str()); //:I[܂ł𐔒lɕϊ
				}else
				if(var=="S"){
					style = atoi(str.substr(n+1).c_str()); //:I[܂ł𐔒lɕϊ
				}else
				if(var=="F"){
					fill = atoi(str.substr(n+1).c_str()); //:I[܂ł𐔒lɕϊ
				}else
				if(var=="N"){
					node = atoi(str.substr(n+1).c_str()); //:I[܂ł𐔒lɕϊ
					if(node<2 || node>VECTPLOYGON_MAXNODE) goto PARAMERR;
				}
				if(var=="X"){
					if(node==0) goto PARAMERR;
					if(sety<node){
						x = atoi(str.substr(n+1).c_str()); //:I[܂ł𐔒lɕϊ
					}
				}else
				if(var=="Y"){
					if(node==0) goto PARAMERR;
					if(sety<node){
						y = atoi(str.substr(n+1).c_str()); //:I[܂ł𐔒lɕϊ
						if(sety==0|| x!=prevX || y!=prevY){
							ptbuff[realnode].setX(x);
							ptbuff[realnode].setY(y);
							prevX=x;
							prevY=y;
							realnode++;
							if(sety==(node-1)){
								if(x==ptbuff[0].x() && y==ptbuff[0].y()) realnode--;
							}
						}
						sety++;
					}
				}
			}
		}
	}
	

	if(realnode<2){
		return false;
	}else{
		m_width=width;
		m_style=style;
		m_nFill=fill;
		m_nCount=realnode;
		m_pPt=new SPoint[realnode];
		for(int i=0;i<realnode;i++){
			m_pPt[i] = ptbuff[i];
		}
		return true;
	}
PARAMERR:
	rce3.SkipTo("-PG");
	return false;

}

bool SPtnObjPolygon::writeCe3(SWriteCE3& wce3,SPoint* pOrigin)
{
	int i;
	if(m_nCount<2 || m_nCount>VECTPLOYGON_MAXNODE)return false;
	wce3.WriteRecord("+PG");
	wce3.WriteRecordInt("W",m_width);
	wce3.WriteRecordInt("S",m_style);
	wce3.WriteRecordInt("F",m_nFill);
	wce3.WriteRecordInt("N",m_nCount);
	for(i=0;i<m_nCount;i++){
		if(pOrigin!=NULL){
			wce3.WriteRecordInt("X",m_pPt[i].x() - pOrigin->x());
			wce3.WriteRecordInt("Y",m_pPt[i].y() - pOrigin->y());
		}else{
			wce3.WriteRecordInt("X",m_pPt[i].x());
			wce3.WriteRecordInt("Y",m_pPt[i].y());
		}
	}
	wce3.WriteRecord("-PG");
	wce3.WriteEOL();
	return true;
}






