/****************************************************************************
    LCoV library editor for BSch3V
    Copyright (C) 2004-2005 H.Okada (http://www.suigyodo.com/online)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/

#pragma once
#include "sptnobj.h"
#include <string>
using namespace std;

class SPtnObjText :	public SPtnObj
{
public:
	//ʂ̃C^[tF[X
	SPtnObjText(void);
	~SPtnObjText(void);
	int id(){return VECTPTN_TXT;}
	SPtnObjText(const SPtnObjText&);					//Rs[RXgN^
	SPtnObjText& operator=(const SPtnObjText&);		//Zq
	SPtnObj* duplicate();							//
	bool qValid();									//Lȃf[^ǂԂB

	//Obv̐Ԃ
	int gripCount(){return 1;}
	//Obv̈ʒuԂ
	SPoint gripPos(int grip){return m_p0;}
	//Obv̈ʒu𓮂
	void setGripPos(int grip,int x,int y);

	void move(int offsetx,int offsety);				//ʒu𓮂
	void mirrorH(int x); 							//XWw肵čE]s
	void mirrorH();									//E]s
	void rotate(const SPoint& p);					//XYSWw肵āA]s
	void rotate();									//]s
	bool testIntersect(const SRect& );				//͈͂w肵đI`FbNs
	bool testIntersect(const SPoint& );				//_w肵đI`FbNs
	SRect area();									//L͈͂Ԃ
	void setDrawSize(SSize size);
	void setText(const char* csz);
	bool readCe3(SReadCE3& rce3);
	bool writeCe3(SWriteCE3& wce3,SPoint* pOrigin=NULL);
public:
	SPoint m_p0;
	bool m_bHoriz;
	string m_strText;
	int m_align;
	bool m_drawSizeIsValid;
	SSize m_drawSize;

};
