/****************************************************************************
    BSch3V schematic capture
    Copyright (C) 1997-2005 H.Okada

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/

// Preview.cpp : Cve[V t@C
//

#include "stdafx.h"
#include <assert.h>
#include <string>
#include <list>
using namespace std;
#include "bsch.h"
#include "complib.h"
//#include "BSchObj.h"
//#include "BSchPart.h"

#include "xbschcomponent.h"
#include "BSchDoc.h"
#include "BSchView.h"
#include "Preview.h"

#include "drawobj.h"
#include "coord2.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPreview

CPreview::CPreview()
{
	m_pPartIndex=NULL;
}

CPreview::~CPreview()
{
}


BEGIN_MESSAGE_MAP(CPreview, CWnd)
	//{{AFX_MSG_MAP(CPreview)
	ON_WM_PAINT()
	ON_WM_HSCROLL()
	ON_WM_VSCROLL()
	ON_WM_SIZE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////
//vr[镔ĩCũCfbNXݒ
//    ĩTCYɉXN[o[̐ݒĂInvalidate()čĕ`
void CPreview::SetPartIndex(const SCompIndex* pPartIndex)
{
	if(!pPartIndex)
	{
		m_pPartIndex=NULL;
		return;
	}
	m_pPartIndex=pPartIndex;
	m_sizePart=SSize2CSize(m_pPartIndex->size());
	TRACE("%d,%d\n",m_sizePart.cx,m_sizePart.cy);
	CRect rcClient;
	GetClientRect(&rcClient);
	SendMessage(WM_SIZE,0,MAKELONG(rcClient.right,rcClient.bottom));
/*
	//XN[o[̐ݒ
	int nMax;
	nMax=(m_sizePart.cy*10+80)-rcClient.bottom;
	if(nMax<0) nMax=0;
	SetScrollPos(SB_VERT,0,FALSE);
	SetScrollRange(SB_VERT,0,nMax);
	//XN[o[
	nMax=(m_sizePart.cx*10+80)-rcClient.right;
	if(nMax<0) nMax=0;
	SetScrollPos(SB_HORZ,0,FALSE);
	SetScrollRange(SB_HORZ,0,nMax);


	Invalidate();
*/
}


/////////////////////////////////////////////////////////////////////////////
// CPreview bZ[W nh

void CPreview::OnPaint() 
{
	CPaintDC dc(this); // `p̃foCX ReLXg
	TRACE("OnPaint\n");

	// TODO: ̈ʒuɃbZ[W nhp̃R[hǉĂ
	if(!m_pPartIndex) return;
	CRect rcArea;
	GetClientRect(&rcArea);

	dc.FillSolidRect(&rcArea,CBSchView::m_COL.colBG);

	int nXoffset,nYoffset;
	nXoffset=GetScrollPos(SB_HORZ);
	nYoffset=GetScrollPos(SB_VERT);
	SXBSchComponent part;
	SPoint	        point;
	part.setCompInfoIndex(m_pPartIndex);
	part.setName(m_pPartIndex->name());
	part.setRefnum(m_pPartIndex->number());
	point.setX(40+m_sizePart.cx*10-nXoffset);
	point.setY(40+m_sizePart.cy*10-nYoffset);
	part.setP1(point);
	g_DrawComponent(&dc,&part,DRAW_ON,1);
	// `pbZ[WƂ CWnd::OnPaint() ĂяoĂ͂܂
}

void CPreview::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	// TODO: ̈ʒuɃbZ[W nhp̃R[hǉ邩܂̓ftHg̏ĂяoĂ
		int nCurrentPos,nNewPos;
	int nMin,nMax;
	BOOL bChange=FALSE;
	nCurrentPos=GetScrollPos(SB_HORZ);
	GetScrollRange(SB_HORZ,&nMin,&nMax);
	switch(nSBCode){
	case SB_THUMBPOSITION:
		SetScrollPos(SB_HORZ,nPos);
		bChange=TRUE;
		break;
	case SB_LINEUP:
		nNewPos=nCurrentPos-10;
		if(nNewPos<nMin) nNewPos=nMin;
		SetScrollPos(SB_HORZ,nNewPos);
		if(nNewPos!=nCurrentPos) bChange=TRUE;
		break;
	case SB_LINEDOWN:
		nNewPos=nCurrentPos+10;
		if(nNewPos>nMax) nNewPos=nMax;
		SetScrollPos(SB_HORZ,nNewPos);
		if(nNewPos!=nCurrentPos) bChange=TRUE;
		break;
	case SB_PAGEUP:
		nNewPos=nCurrentPos-50;
		if(nNewPos<nMin) nNewPos=nMin;
		SetScrollPos(SB_HORZ,nNewPos);
		if(nNewPos!=nCurrentPos) bChange=TRUE;
		break;
	case SB_PAGEDOWN:
		nNewPos=nCurrentPos+50;
		if(nNewPos>nMax) nNewPos=nMax;
		SetScrollPos(SB_HORZ,nNewPos);
		if(nNewPos!=nCurrentPos) bChange=TRUE;
		break;
	}
	if(bChange)Invalidate();

	//CWnd::OnHScroll(nSBCode, nPos, pScrollBar);
}

void CPreview::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	// TODO: ̈ʒuɃbZ[W nhp̃R[hǉ邩܂̓ftHg̏ĂяoĂ
	int nCurrentPos,nNewPos;
	int nMin,nMax;
	BOOL bChange=FALSE;
	nCurrentPos=GetScrollPos(SB_VERT);
	GetScrollRange(SB_VERT,&nMin,&nMax);
	switch(nSBCode){
	case SB_THUMBPOSITION:
		SetScrollPos(SB_VERT,nPos);
		bChange=TRUE;
		break;
	case SB_LINEUP:
		nNewPos=nCurrentPos-10;
		if(nNewPos<nMin) nNewPos=nMin;
		SetScrollPos(SB_VERT,nNewPos);
		if(nNewPos!=nCurrentPos) bChange=TRUE;
		break;
	case SB_LINEDOWN:
		nNewPos=nCurrentPos+10;
		if(nNewPos>nMax) nNewPos=nMax;
		SetScrollPos(SB_VERT,nNewPos);
		if(nNewPos!=nCurrentPos) bChange=TRUE;
		break;
	case SB_PAGEUP:
		nNewPos=nCurrentPos-50;
		if(nNewPos<nMin) nNewPos=nMin;
		SetScrollPos(SB_VERT,nNewPos);
		if(nNewPos!=nCurrentPos) bChange=TRUE;
		break;
	case SB_PAGEDOWN:
		nNewPos=nCurrentPos+50;
		if(nNewPos>nMax) nNewPos=nMax;
		SetScrollPos(SB_VERT,nNewPos);
		if(nNewPos!=nCurrentPos) bChange=TRUE;
		break;
	}
	if(bChange)Invalidate();
//	CWnd::OnVScroll(nSBCode, nPos, pScrollBar);
}

//////////////////////////////////////////////////////////////////
//OnSize()ŃXN[o[̐ݒs
//XN[o[ON/OFFŃEChETCY͕ς
void CPreview::OnSize(UINT nType, int cx, int cy) 
{
	static int ncx=cx;
	static int ncy=cy;
	//CWnd::OnSize(nType, cx, cy);

	// TODO: ̈ʒuɃbZ[W nhp̃R[hǉĂ
	if(!m_pPartIndex) return; //iݒ
	//XN[o[̐ݒ
	int nMax;
	nMax=(m_sizePart.cy*10+80)-ncy;
	if(nMax<0) nMax=0;
	SetScrollPos(SB_VERT,0,FALSE);
	SetScrollRange(SB_VERT,0,nMax);

	//XN[o[
	nMax=(m_sizePart.cx*10+80)-ncx;
	if(nMax<0) nMax=0;
	SetScrollPos(SB_HORZ,0,FALSE);
	SetScrollRange(SB_HORZ,0,nMax);
	Invalidate();
}	
