/****************************************************************************
    NL3W netlist utility for BSch3V
    Copyright (C) 2004-2005 H.Okada

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/

#include "stdafx.h"
#include "cmdlineparam.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

SCmdLineParam::SCmdLineParam(){
	m_forceExecute	= FALSE;
	m_flag3sMfr = 0;
	m_flag3sMfrPn = 0;
	m_flag3sPackage = 0;
	m_flag3sNote = 0;
	m_flag = 's';
}

void SCmdLineParam::ParseParam(
				const char* pszParam,
				BOOL bFlag,
				BOOL bLast){
	if(bFlag){
		m_flag = pszParam[0];
		switch(m_flag){
		case 'F':
			m_forceExecute=TRUE;
			m_flag = 's';
			break;
		case 'M':
			if(pszParam[1] == 'N' || pszParam[1] == 'n'){	//2ڂN܂n̂Ƃ͐Ҍ^
				m_flag3sMfrPn = 1;
			}else{
				m_flag3sMfr = 1;
			}
			m_flag = 's';
			break;
		case 'm':
			if(pszParam[1] == 'N' || pszParam[1] == 'n'){	//2ڂN܂n̂Ƃ͐Ҍ^
				m_flag3sMfrPn = -1;
			}else{
				m_flag3sMfr = -1;
			}
			m_flag = 's';
			break;
		case 'P':
			m_flag3sPackage = 1;
			m_flag = 's';
			break;
		case 'p':
			m_flag3sPackage = -1;
			m_flag = 's';
			break;
		case 'N':
			m_flag3sNote = 1;
			m_flag = 's';
			break;
		case 'n':
			m_flag3sNote = -1;
			m_flag = 's';
			break;


		default:
			break;
		}

	}else if(pszParam[0]){
		switch(m_flag){
		case 's':
			m_strListSrcFiles.AddTail(pszParam);
			break;
		case 'o':
			m_strList = pszParam;
			m_flag = 's';
			break;
		default:
			m_flag = 's';
			break;
		}
	}
}
