/****************************************************************************
    BSch3V and Utility common file.
    Copyright (C) 2002-2005 H.Okada

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/


/****************************************************************************
** XBSch}ʗvfNX
****************************************************************************/
#ifndef XBSCHOBJ_H
#define XBSCHOBJ_H

#include "xbsch.h"
//#include <SPoint.h>
//#include <SRect.h>
#include "coord.h"
#include "ce3io.h"

class SXBSchDoc;

/*
#define		NOT_SELECT	0
#define		SELECT_P1	1
#define		SELECT_P2	2
#define		SELECT_ALL	3

#define		OUTCODE_LEFT		0x0001
#define		OUTCODE_UPPER		0x0002
#define		OUTCODE_RIGHT		0x0004
#define		OUTCODE_LOWER		0x0008
*/

enum BSCH_TOOL_MODE
{
	TOOL_SELECTOR,
	TOOL_DRAG,
	TOOL_COMPONENT,
	TOOL_BUS,
	TOOL_WIRE,
	TOOL_DASH,
	TOOL_JUNCTION,
	TOOL_BENTRY,
	TOOL_ENTRY,
	TOOL_TAG,
	TOOL_LABEL,
	TOOL_COMMENT
};

enum ON_OBJECT
{
	ON_OBJ		=0x10000,
	ON_NAME		=0x20000,
	ON_NUM		=0x40000
};

class SXBSchObj
{
public:
	enum BSCHOBJ_ID
	{
		ID_JUNCTION		=0,
		ID_ENTRY		=1,
		ID_BENTRY		=2,
		ID_BUS			=3,
		ID_WIRE			=4,
		ID_DASH			=5,
		ID_LABEL		=6,
		ID_TAG			=7,
		ID_COMPONENT	=8,
		ID_SHEETINFO	=9,
		ID_COMMENT		=10,
		ID_DELETEOBJ	=254,
		ID_ENDOFDATA	=255
	};

	enum SELECTION
	{
		NOT_SELECTED	=0,
		SELECT_P1		=1,
		SELECT_P2		=2,
		SELECT_ALL		=3
	};

	enum OUTCODE
	{
		OUTCODE_CENTER	=	0x0000,
		OUTCODE_LEFT	=	0x0001,
		OUTCODE_UPPER	=	0x0002,
		OUTCODE_RIGHT	=	0x0004,
		OUTCODE_LOWER	=	0x0008
	};

protected:
	//zuƂ̑ԍ
	int m_PlaceNum;
	//QƃIuWFNgւ̃|C^
	//	ID_DELETEOBJ ł́ȀIuWFNgĂƂ̑ΏۃIuWFNgw
	//  ȊÕIuWFNgł́AIuWFNgwBNULL̂Ƃ́ÃIuWFNgL
	//  邱Ƃ\B
	SXBSchObj* m_pRefObj;
	//zuC[
	int m_Layer;
	//IuWFNg̍W
	SPoint m_p1;
	SPoint m_p2;
	//I
	unsigned m_Selection;

	bool isValidLayer(int n){return (n>=0 && n<8);}

public:
	//RXgN^
	SXBSchObj();
	//fXgN^
	virtual ~SXBSchObj(){};

//	virtual bool readStream(SCsvIStream* ,const SPoint* ){return false;}
//	virtual bool writeStream(SCsvOStream* ,const SPoint* ){return false;}

	virtual bool readCe3(SReadCE3&,const SPoint* ,SXBSchDoc* ){return false;}
//	virtual bool readCe3(SReadCE3&,const SPoint* ){return false;}
	virtual bool writeCe3(SWriteCE3& ,const SPoint* ){return false;}

	//ID̎擾
	virtual unsigned id()=0;
	//zuƂ̑ԍ
	void setPlaceNum(int n){m_PlaceNum = n;}
	//zuƂ̑ԍ̎擾
	int placeNum(){return m_PlaceNum;}
	//QƃIuWFNgւ̃|C^̐ݒ
	void setRefObj(SXBSchObj* pObj){m_pRefObj = pObj;}
	//QƃIuWFNgւ̃|C^擾
	SXBSchObj* refObj(){return m_pRefObj;}
	//C[̐ݒ
	void setLayer(int n){m_Layer=n;}
	//C[̎擾
	int layer(){return m_Layer;}
	//W̐ݒ
	virtual void setX1(int x1){m_p1.setX(x1);}
	virtual void setY1(int y1){m_p1.setY(y1);}
	virtual void setX2(int x2){m_p2.setX(x2);}
	virtual void setY2(int y2){m_p2.setX(y2);}
	virtual void setP1(const SPoint& p){m_p1 = p;}
	virtual void setP2(const SPoint& p){m_p2 = p;}
	//W̎擾
	int x1(){return m_p1.x();}
	int y1(){return m_p1.y();}
	virtual int x2(){return m_p2.x();}
	virtual int y2(){return m_p2.y();}
	SPoint p1(){return m_p1;}
	virtual SPoint p2(){return m_p2;}
	virtual SPoint snapPoint(){return m_p1;}
	//IԂ̎擾
	unsigned selection(){return m_Selection;}
public:
	//s
	virtual SXBSchObj* duplicate(){return NULL;}
	//ʒu𓮂
	virtual void move(int offsetx,int offsety);
	//XWw肵čE]s
	virtual void mirrorH(int x);
	//E]s
	virtual void mirrorH();
	//XYSWw肵āA]s
	virtual void rotate(const SPoint& p);
	//]s
	virtual void rotate();
	//_w肵đIdvxԂ
	virtual int qSelectWeight(const SPoint&){return 0;}
	//ItOZbg
	virtual void setSelection(unsigned sel);
	//I
	virtual void resetSelection();
	//͈͂w肵đIs
	virtual unsigned testSelection(const SRect& ){return 0;}
	//͈͂IăhbOIs
	virtual unsigned testSelectionForDrag(const SRect& ){return 0;}
	//`悪KvǂԂ
	virtual bool qRedraw(const SRect& ){return 0;}
	//sԂ
	virtual int pinCount()const {return 0;}
	//nԖڂ̃s̈ʒu𓾂B
	virtual SPoint pinPosition(int) const {return SPoint(-1,-1);}
	virtual SRect area(){return SRect(-1,-1,0,0);}
	virtual SRect rotateRect(){return SRect(-1,-1,0,0);}
	//LȃIuWFNgȂtrueԂB̂ȂeLXgÂȂ͗Lł͂ȂB
	virtual bool qValid(){return true;}
	//Agr[g̕ύX\ȏꍇtrueԂB
	virtual bool canAttribute() {return false;}
public:
	//prcArea̓OR[hԂ
	static unsigned SetOutCode(const SPoint& p,const SRect& rcArea);
	//_Ƌ`̏dȂAdݏtŕԂ
	static int PointAndRectMag(const SPoint& p,const SRect& rcArea);
};

#endif
