/****************************************************************************
    LCoV library editor for BSch3V
    Copyright (C) 2004-2005 H.Okada (http://www.suigyodo.com/online)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/

// PinProperty.cpp : t@C
//

#include "stdafx.h"
#include "LCoV.h"
#include "PinProperty.h"
#include ".\pinproperty.h"
#include <list>
#include <string>
using namespace std;
#include "complib.h"


// PinProperty _CAO

IMPLEMENT_DYNAMIC(CPinProperty, CDialog)
CPinProperty::CPinProperty(CWnd* pParent /*=NULL*/)
	: CDialog(CPinProperty::IDD, pParent)
{
	m_arrayNum = NULL;
	//m_pPin = NULL;
	m_currentBlock = 0;
	//m_bChanged = false;
	m_hideNum = false;
	m_pinType = 0;

}

CPinProperty::~CPinProperty()
{
	delete[]m_arrayNum;
	//delete m_pPin;
}

void CPinProperty::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

void CPinProperty::setBlock(int block)
{
	delete[]m_arrayNum;
	m_arrayNum = NULL;
	if(block>0){
		m_arrayNum = new CString[block];
	}
	m_block = block;
}

void CPinProperty::setName(const char* name)
{
	if(!name) return;
	m_name = "";
	while(*name){
		char cc = *name;
		cc &= 0x7f;
		if(*name & 0x80){
			m_name += '\\';
		}
		m_name += cc;
		name++;
	}
}




BEGIN_MESSAGE_MAP(CPinProperty, CDialog)
//	ON_BN_CLICKED(IDC_RADIO_NORM, OnBnClickedRadioNorm)
ON_EN_CHANGE(IDC_EDIT_BLOCK, OnEnChangeEditBlock)
END_MESSAGE_MAP()


// PinProperty bZ[W nh

BOOL CPinProperty::OnInitDialog()
{
	CDialog::OnInitDialog();

	int nPinType = 0;

	// TODO :  ɏǉĂ
	CEdit* pEdit;

	pEdit = (CEdit*)GetDlgItem(IDC_EDIT_PIN_NAME);
	pEdit->SetWindowText(m_name);

	if(m_block>0){
		pEdit = (CEdit*)GetDlgItem(IDC_EDIT_PIN_NUM);
		pEdit->SetWindowText(m_arrayNum[0]);
	}

	pEdit = (CEdit*)GetDlgItem(IDC_EDIT_BLOCK);
	pEdit->SetWindowText("1");
		
	CSpinButtonCtrl* pSpin=(CSpinButtonCtrl*)GetDlgItem(IDC_SPIN_BLOCK);
	pSpin->SetRange(1,m_block);
	if(m_block<=1) pSpin->EnableWindow(FALSE);
	else	 pSpin->EnableWindow(TRUE);
		
	CButton* pButton;
	pButton = (CButton*)GetDlgItem(IDC_CHECK_HIDE_NUM);
	pButton->SetCheck(m_hideNum!=false);



	CBitmap bm;
	pButton = (CButton*)GetDlgItem(IDC_RADIO_NORM);
	pButton->SetBitmap(::LoadBitmap(AfxGetApp()->m_hInstance,MAKEINTRESOURCE(IDB_BMP_PIN_NORM)));
	pButton->SetCheck(m_pinType == PIN_TYPE_NOMAL);

	pButton = (CButton*)GetDlgItem(IDC_RADIO_CK);
	pButton->SetBitmap(::LoadBitmap(AfxGetApp()->m_hInstance,MAKEINTRESOURCE(IDB_BMP_PIN_CK)));
	pButton->SetCheck(m_pinType == PIN_TYPE_CLOCK);

	pButton = (CButton*)GetDlgItem(IDC_RADIO_NEGA);
	pButton->SetBitmap(::LoadBitmap(AfxGetApp()->m_hInstance,MAKEINTRESOURCE(IDB_BMP_PIN_NEGA)));
	pButton->SetCheck(m_pinType == PIN_TYPE_NEGATIVE);

	pButton = (CButton*)GetDlgItem(IDC_RADIO_NEGACK);
	pButton->SetBitmap(::LoadBitmap(AfxGetApp()->m_hInstance,MAKEINTRESOURCE(IDB_BMP_PIN_NEGACK)));
	pButton->SetCheck(m_pinType == (PIN_TYPE_NEGATIVE | PIN_TYPE_CLOCK));

	pButton = (CButton*)GetDlgItem(IDC_RADIO_SMALL);
	pButton->SetBitmap(::LoadBitmap(AfxGetApp()->m_hInstance,MAKEINTRESOURCE(IDB_BMP_PIN_SMALL)));
	pButton->SetCheck(m_pinType == PIN_TYPE_SMALL);

	pButton = (CButton*)GetDlgItem(IDC_RADIO_ZLENG);
	pButton->SetBitmap(::LoadBitmap(AfxGetApp()->m_hInstance,MAKEINTRESOURCE(IDB_BMP_PIN_ZLENG)));
	pButton->SetCheck(m_pinType == PIN_TYPE_ZLENG);

	return TRUE;  // return TRUE unless you set the focus to a control
	// O : OCX vpeB y[W͕K FALSE Ԃ܂B
}


void CPinProperty::OnEnChangeEditBlock()
{
	// TODO :  ꂪ RICHEDIT Rg[̏ꍇA܂ACDialog::OnInitDialog() ֐I[o[ChāA
	// OR Ԃ ENM_CORRECTTEXT tO}XNɓāA
	// CRichEditCtrl().SetEventMask() ĂяoȂA
	// Rg[́A̒ʒm𑗐M܂B

	// TODO :  ɃRg[ʒmnh R[hǉĂB
	TRACE("void CPinProperty::OnEnChangeEditBlock()\n");

	CEdit* pEdit = (CEdit*)GetDlgItem(IDC_EDIT_BLOCK);
	CString strBlock;
	pEdit->GetWindowText(strBlock);
	int newBlock = atoi(strBlock) -1;
	if(newBlock<0) newBlock = 0;
	else if(newBlock >= m_block) newBlock = m_block -1;
	if(m_currentBlock == newBlock) return;

	CString strNum;
	pEdit = (CEdit*)GetDlgItem(IDC_EDIT_PIN_NUM);
	pEdit->GetWindowText(strNum);
	if(strNum != m_arrayNum[m_currentBlock]){
		m_arrayNum[m_currentBlock] = strNum;
	}
	pEdit->SetWindowText(m_arrayNum[newBlock]);
	m_currentBlock = newBlock;
}

void CPinProperty::OnOK()
{
	// TODO : ɓȃR[hǉ邩A͊{NXĂяoĂB
	CEdit* pEdit;

	pEdit = (CEdit*)GetDlgItem(IDC_EDIT_PIN_NAME);
	pEdit->GetWindowText(m_name);

	pEdit = (CEdit*)GetDlgItem(IDC_EDIT_BLOCK);
	CString strBlock;
	pEdit->GetWindowText(strBlock);
	int block = atoi(strBlock) -1;
	if(block<0) block = 0;
	else if(block >= m_block) block = m_block -1;

	CString strNum;
	pEdit = (CEdit*)GetDlgItem(IDC_EDIT_PIN_NUM);
	pEdit->GetWindowText(strNum);
	if(strNum != m_arrayNum[block]){
		m_arrayNum[block] = strNum;
	}

	CButton* pButton;
	pButton = (CButton*)GetDlgItem(IDC_CHECK_HIDE_NUM);
	m_hideNum = (pButton->GetCheck()!=0);

	if(((CButton*)GetDlgItem(IDC_RADIO_NORM))->GetCheck()){
		m_pinType = PIN_TYPE_NOMAL;
	}else if(((CButton*)GetDlgItem(IDC_RADIO_CK))->GetCheck()){
		m_pinType = PIN_TYPE_CLOCK;
	}else if(((CButton*)GetDlgItem(IDC_RADIO_NEGA))->GetCheck()){
		m_pinType = PIN_TYPE_NEGATIVE;
	}else if(((CButton*)GetDlgItem(IDC_RADIO_NEGACK))->GetCheck()){
		m_pinType = (PIN_TYPE_NEGATIVE | PIN_TYPE_CLOCK);
	}else if(((CButton*)GetDlgItem(IDC_RADIO_SMALL))->GetCheck()){
		m_pinType = PIN_TYPE_SMALL;
	}else{	//if(((CButton*)GetDlgItem(IDC_RADIO_ZLENG))->GetCheck()){
		m_pinType = PIN_TYPE_ZLENG;
	}
	CDialog::OnOK();
}
