/* ------------------------------------------------------------------------- */
/*  HOS-80  ե졼 Ver 0.00                                  */
/*                                               Copyright (C) 1998 by Ryuz  */
/* ------------------------------------------------------------------------- */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>


/* ------------------------------------ */
/*                              */
/* ------------------------------------ */

#define MAX_PATH   		128		/* ѥ̾ */
#define MAX_PARAMETER     5     /* ѥ᡼ */
#define MAX_ID          255     /* ɣĿ */
#define MAX_INT         128		/* ֹ */
#define MAX_INCLUDE_C    32		/* ɤ߹ߥե(ø) */

#define TRUE  1
#define FALSE 0



/* ------------------------------------ */
/*             ؿ                 */
/* ------------------------------------ */

void AnalizeCommand(char *(*pppPara[MAX_PARAMETER]), int nPara, char *pBuf);
void AnalizeDefInt(char *pBuf);
void AnalizeIncludeC(char *pBuf);
void AnalizeMaxTskPri(char *pBuf);
void AnalizeSysStack(char *pBuf);

void FreeParameter(char *ppPara[MAX_PARAMETER]);
void FreeTable(char ***pppTable);

void CutSpace(char *pBuf);
int  ClipParameter(char *ppPar[], int nNum, char *pBuf);
int  StrToInt(int *pNum, char *pBuf);

void Write_Def_ID(void);		/* ե */
void Write_C_Cfg(void);			/* ø */
void Write_Asm_Cfg(void);		/* ֥ */



/* ------------------------------------ */
/*             ѿ                 */
/* ------------------------------------ */

char szCfgFile[MAX_PATH]  = "hos.cfg";		/* ե졼ե */
char szAsmFile[MAX_PATH]  = "cfg_asm.asz";	/* ֥ϥե̾ */
char szCFile[MAX_PATH]    = "cfg_c.c";		/* øϥե̾ */
char szDefCFile[MAX_PATH] = "defid.h";		/* إåե̾ */

int  nLine;			/* ιֹ */
int  bErr = FALSE;	/* 顼 */

char *pMaxTskPri = NULL;		/* ͥ(ǥեȤǣ) */

char **pppTaskTable[MAX_ID];	/* ǡơ֥ */
char **pppSemTable[MAX_ID];		/* ޥեǡơ֥ */
char **pppFlgTable[MAX_ID];		/* ٥ȥե饰ǡơ֥ */
char **pppMbxTable[MAX_ID];		/* åܥåǡơ֥ */
char **pppMpfTable[MAX_ID];		/* Ĺסǡơ֥ */

char *ppIntTable[MAX_INT];		/* ߥ٥Υơ֥ */

char *ppIncludeCTable[MAX_INCLUDE_C];	/* øΥ󥯥롼ɥե */
int  nIncCCount;		/* 󥯥롼ɥե */

unsigned short SystemStack = 0x0000;	/* ƥॹåΥɥ쥹 */

int  bUseTimer = TRUE;		/* ޤȤ */


/* ------------------------------------ */
/*             ᥤ                   */
/* ------------------------------------ */

/* ᥤؿ */
int main(int argc, char argv[])
{
	FILE *fp;
	char szBuf[256];
	int  i;

	/* ɽ */
	fprintf(stderr, "HOS-80 ѥե졼 Ver0.00 by Ryuz\n");

	/* ޥɥ饤 */
	/*
	for ( i = 0; i < argc; i++ ) {
	}
	*/

	/* ե륪ץ */
	if ( (fp = fopen(szCfgFile, "r")) == NULL ) {
		fprintf(stderr, "%s ޤ\n");
		exit(1);
	}
	
	/* եβ */
	nLine = 1;
	while ( fgets(szBuf, sizeof(szBuf), fp) != NULL ) {
		CutSpace(szBuf);
		if ( strncmp(szBuf, "CRE_TSK", 7) == 0 )
			AnalizeCommand(pppTaskTable, 5, &szBuf[7]);
		else if ( strncmp(szBuf, "CRE_SEM", 7) == 0 )
			AnalizeCommand(pppSemTable, 4, &szBuf[7]);
		else if ( strncmp(szBuf, "CRE_FLG", 7) == 0 )
			AnalizeCommand(pppFlgTable, 3, &szBuf[7]);
		else if ( strncmp(szBuf, "CRE_MBX", 7) == 0 )
			AnalizeCommand(pppMbxTable, 3, &szBuf[7]);
		else if ( strncmp(szBuf, "CRE_MPF", 7) == 0 )
			AnalizeCommand(pppMpfTable, 4, &szBuf[7]);
		else if ( strncmp(szBuf, "DEF_INT", 7) == 0 )
			AnalizeDefInt(&szBuf[7]);
		else if ( strncmp(szBuf, "INCLUDE_C", 9) == 0 )
			AnalizeIncludeC(&szBuf[9]);
		else if ( strncmp(szBuf, "MAX_TSKPRI", 10) == 0 )
			AnalizeMaxTskPri(&szBuf[10]);
		else if ( strncmp(szBuf, "SYSTEM_STACK", 12) == 0 )
			AnalizeSysStack(&szBuf[12]);
		else if ( strncmp(szBuf, "USE_TIMER", 9) == 0 )
			bUseTimer = TRUE;
		else if ( strncmp(szBuf, "NOUSE_TIMER", 11) == 0 )
			bUseTimer = FALSE;
		else if ( szBuf[0] != ';' && szBuf[0] != '\0' && szBuf[0] != '\n' ) {
			fprintf(stdout, "ֹ %d: ʸ顼\n", nLine);
			bErr = TRUE;
		}
		nLine++;
	}
	
	fclose(fp);

	/* ե */
	Write_Def_ID();
	Write_C_Cfg();
	Write_Asm_Cfg();

	/* 곫 */
	FreeTable(pppTaskTable);
	FreeTable(pppSemTable);
	FreeTable(pppFlgTable);
	FreeTable(pppMbxTable);
	FreeTable(pppMpfTable);
	if ( pMaxTskPri != NULL )  free(pMaxTskPri);
	for ( i = 0; i < MAX_INT; i++ )
		if ( ppIntTable[i] != NULL )  free(ppIntTable[i]);
	for ( i = 0; i < MAX_INCLUDE_C; i++ )
		if ( ppIncludeCTable[i] != NULL )  free(ppIncludeCTable[i]);
	
	return bErr;
}



/* ------------------------------------ */
/*         ե                 */
/* ------------------------------------ */

/* ե */
void Write_Def_ID(void)
{
	FILE *fp;
	int  i;
	
	fp = fopen(szDefCFile, "w");

	fprintf(fp, "/* ROS-80 øѣɣե */\n\n");
	fprintf(fp, "#ifndef __ROSCFG__DEFID_H_\n");
	fprintf(fp, "#define __ROSCFG__DEFID_H_\n\n\n");

	/* ID  */
	for ( i = 0; i < MAX_ID; i++ ) {
		if ( pppTaskTable[i] != NULL && pppTaskTable[i][0][0] != '\0' ) 
			fprintf(fp, "#define %s\t%d\n", pppTaskTable[i][0], i + 1);
	}
	fprintf(fp, "\n");

	/* ޥեID  */
	for ( i = 0; i < MAX_ID; i++ ) {
		if ( pppSemTable[i] != NULL && pppSemTable[i][0][0] != '\0' ) 
			fprintf(fp, "#define %s\t%d\n", pppSemTable[i][0], i + 1);
	}
	fprintf(fp, "\n");

	/* ٥ȥե饰ID  */
	for ( i = 0; i < MAX_ID; i++ ) {
		if ( pppFlgTable[i] != NULL && pppFlgTable[i][0][0] != '\0' ) 
			fprintf(fp, "#define %s\t%d\n", pppFlgTable[i][0], i + 1);
	}
	fprintf(fp, "\n");

	/* ᡼ܥåID  */
	for ( i = 0; i < MAX_ID; i++ ) {
		if ( pppMbxTable[i] != NULL && pppMbxTable[i][0][0] != '\0' ) 
			fprintf(fp, "#define %s\t%d\n", pppMbxTable[i][0], i + 1);
	}
	fprintf(fp, "\n");

	/* ĹסID  */
	for ( i = 0; i < MAX_ID; i++ ) {
		if ( pppMpfTable[i] != NULL && pppMpfTable[i][0][0] != '\0' ) 
			fprintf(fp, "#define %s\t%d\n", pppMpfTable[i][0], i + 1);
	}
	fprintf(fp, "\n");

	fprintf(fp, "\n#endif /* __ROSCFG__DEFID_H_ */\n");
}


/* ե졼եø */
void Write_C_Cfg(void)
{
	FILE *fp;
	char *pPri;
	int  nMaxID;
	int  i;
	int  bTsk = FALSE;
	int  bSem = FALSE;
	int  bFlg = FALSE;
	int  bMbx = FALSE;
	int  bMpf = FALSE;
	
	fp = fopen(szCFile, "w");
	
	/* Ƚ */
	fprintf(fp, "/* ROS-80 ե졼եø */\n\n");
	
	/* 󥯥롼ɥե */
	fprintf(fp, "#include <ITRON.h>\n");
	for ( i = 0; i < nIncCCount; i++ )
		fprintf(fp, "#include %s\n", ppIncludeCTable[i]);
	
	
	/* ------- ǥ塼 -------- */
	if ( pMaxTskPri == NULL )
		pPri = "8";
	else
		pPri = pMaxTskPri;
	fprintf(fp, "\n\n/* ǥ塼 */\n");
	fprintf(fp, "T_QUE rdyque[%s];\n", pPri);
	fprintf(fp, "UB    rdqcnt = %s;\n", pPri);

	
	/* ------- ǡ -------- */

	/* 祿ID */
	nMaxID = 0;
	for ( i = 0; i < MAX_ID; i++ ) {
		if ( pppTaskTable[i] != NULL )
			nMaxID = i + 1;
	}

	if ( nMaxID > 0 ) {
		bTsk = TRUE;

		/* åΰ */
		fprintf(fp, "\n\n/*åΰ*/\n");
		for ( i = 0; i < nMaxID; i++ ) {
			if ( pppTaskTable[i] != NULL ) {
				fprintf(fp, "UB Stack%d[%s];\n", i + 1, pppTaskTable[i][4]);
			}
		}
	
		/*  */
		fprintf(fp, "\n/*Ͽ*/\n");
		fprintf(fp, "T_TCB  tcbtbl[%d];\n", nMaxID);
		fprintf(fp, "T_TCBS tcbstbl[%d] = {\n", nMaxID);
		for ( i = 0; i < nMaxID; i++ ) {
			if ( pppTaskTable[i] == NULL )
				fprintf(fp, "\t\t{}");
			else
				fprintf(fp, "\t\t"
							"{%s, %s, %s, (VH *)(Stack%d + sizeof(Stack%d))}",
							pppTaskTable[i][1],
							pppTaskTable[i][2],
							pppTaskTable[i][3],
							i + 1, i + 1
						);
			if ( i == nMaxID - 1 )
				fprintf(fp, "\n");
			else
				fprintf(fp, ",\n");
		}
		fprintf(fp, "\t};\n");
	}
	fprintf(fp, "UB  tcbcnt = %d;\t/*  */\n", nMaxID);

	
	/* ------- ޥեǡ -------- */

	/* 祻ޥեID */
	nMaxID = 0;
	for ( i = 0; i < MAX_ID; i++ ) {
		if ( pppSemTable[i] != NULL )
			nMaxID = i + 1;
	}

	if ( nMaxID > 0 ) {
		bSem = TRUE;

		/* ޥե */
		fprintf(fp, "\n\n/* ޥեϿ */\n");
		fprintf(fp, "T_SCB  scbtbl[%d];\n", nMaxID);
		fprintf(fp, "T_SCBS scbstbl[%d] = {\n", nMaxID);
		for ( i = 0; i < nMaxID; i++ ) {
			if ( pppSemTable[i] == NULL )
				fprintf(fp, "\t\t{}");
			else
				fprintf(fp, "\t\t{%s, %s, %s}",
							pppSemTable[i][1],
							pppSemTable[i][2],
							pppSemTable[i][3]
						);
			if ( i == nMaxID - 1 )
				fprintf(fp, "\n");
			else
				fprintf(fp, ",\n");
		}
		fprintf(fp, "\t};\n");
	}
	fprintf(fp, "UB  scbcnt = %d;\t/* ޥե */\n", nMaxID);


	/* ------- ե饰ǡ -------- */

	/* 祤٥ȥե饰ID */
	nMaxID = 0;
	for ( i = 0; i < MAX_ID; i++ ) {
		if ( pppFlgTable[i] != NULL )
			nMaxID = i + 1;
	}

	if ( nMaxID > 0 ) {
		bFlg = TRUE;

		/* ٥ȥե饰 */
		fprintf(fp, "\n\n/* ٥ȥե饰Ͽ */\n");
		fprintf(fp, "T_FCB  fcbtbl[%d];\n", nMaxID);
		fprintf(fp, "T_FCBS fcbstbl[%d] = {\n", nMaxID);
		for ( i = 0; i < nMaxID; i++ ) {
			if ( pppFlgTable[i] == NULL )
				fprintf(fp, "\t\t{}");
			else
				fprintf(fp, "\t\t{%s, %s}",
							pppFlgTable[i][1],
							pppFlgTable[i][2]);
			if ( i == nMaxID - 1 )
				fprintf(fp, "\n");
			else
				fprintf(fp, ",\n");
		}
		fprintf(fp, "\t};\n");
	}
	fprintf(fp, "UB  fcbcnt = %d;\t/* ٥ȥե饰 */\n", nMaxID);

	/* ------- ᥤܥåǡ -------- */

	/* ᡼ܥåID */
	nMaxID = 0;
	for ( i = 0; i < MAX_ID; i++ ) {
		if ( pppMbxTable[i] != NULL )
			nMaxID = i + 1;
	}
	
	if ( nMaxID > 0 ) {
		bMbx = TRUE;
		fprintf(fp, "\n\n/* ᡼ܥåѥХåե */\n");
		for ( i = 0; i < nMaxID; i++ )
			fprintf(fp, "VP msgbuf%d[%s];\n", i, pppMbxTable[i][2]);
		
		/* ᡼ܥå */
		fprintf(fp, "\n/* ᡼ܥåϿ */\n");
		fprintf(fp, "T_MCB  mcbtbl[%d];\n", nMaxID);
		fprintf(fp, "T_MCBS mcbstbl[%d] = {\n", nMaxID);
		for ( i = 0; i < nMaxID; i++ ) {
			if ( pppMbxTable[i] == NULL )
				fprintf(fp, "\t\t{}");
			else
				fprintf(fp, "\t\t{%s, msgbuf%d, msgbuf%d + %s}",
							pppMbxTable[i][1], i, i, pppMbxTable[i][2]);
			if ( i == nMaxID - 1 )
				fprintf(fp, "\n");
			else
				fprintf(fp, ",\n");
		}
		fprintf(fp, "\t};\n");
	}
	fprintf(fp, "UB  mcbcnt = %d;\t/* ᡼ܥå */\n", nMaxID);
	
	
	/* ------- Ĺסǡ -------- */
	
	/* ĹסID */
	nMaxID = 0;
	for ( i = 0; i < MAX_ID; i++ ) {
		if ( pppMpfTable[i] != NULL )
			nMaxID = i + 1;
	}
	
	if ( nMaxID > 0 ) {
		bMpf = TRUE;
		fprintf(fp, "\n\n/* Ĺסѥ */\n");
		for ( i = 0; i < nMaxID; i++ )
			fprintf(fp, "UB mpfblk%d[(%s) * (%s)];\n", i,
						pppMpfTable[i][2], pppMpfTable[i][3]);
		
		/* Ĺס */
		fprintf(fp, "\n/* ĹסϿ */\n");
		fprintf(fp, "T_FMCB  fmcbtbl[%d];\n", nMaxID);
		fprintf(fp, "T_FMCBS fmcbstbl[%d] = {\n", nMaxID);
		for ( i = 0; i < nMaxID; i++ ) {
			if ( pppMpfTable[i] == NULL )
				fprintf(fp, "\t\t{}");
			else
				fprintf(fp, "\t\t{%s, mpfblk%d, %s, %s}",
							pppMpfTable[i][1], i,
							pppMpfTable[i][2], pppMpfTable[i][3]);
			if ( i == nMaxID - 1 )
				fprintf(fp, "\n");
			else
				fprintf(fp, ",\n");
		}
		fprintf(fp, "\t};\n");
	}
	fprintf(fp, "UB  fmcbcnt = %d;\t/* Ĺס */\n", nMaxID);
	
	
	
	/* 롼 */
	fprintf(fp, "\n\n/*  */\n"
				"void __initialize(void)\n{\n"
			);
	if ( bUseTimer )
		fprintf(fp, "\t__ini_tim();\t/* ޽ */\n");
	if ( bTsk )
		fprintf(fp, "\t__ini_tsk();\t/*  */\n");
	if ( bSem )
		fprintf(fp, "\t__ini_sem();\t/* ޥե */\n");
	if ( bFlg )
		fprintf(fp, "\t__ini_flg();\t/* ٥ȥե饰 */\n");
	if ( bMbx )
		fprintf(fp, "\t__ini_mbx();\t/* ᥤܥå */\n");
	if ( bMpf )
		fprintf(fp, "\t__ini_mpf();\t/* Ĺס */\n");
	fprintf(fp, "}\n");

	fclose(fp);
}


/* ֥ */
void Write_Asm_Cfg(void)
{
	FILE *fp;
	int  i;
	
	fp = fopen(szAsmFile, "w");
	
	/* Ƚ */
	fprintf(fp, "; ե졼ե륢֥\n\n");

	/* ƥॹåɥ쥹 */
	fprintf(fp,
				"; -----------------------------------------------\n"
				";        ƥॹåɥ쥹\n"
				"; -----------------------------------------------\n"
				"\n"
				"\t\tpublic\tsystem_stack\n"
				"system_stack\tequ\t%04xh\n\n\n", SystemStack
			);

	/* ߥ٥ */
	fprintf(fp,
				"; -----------------------------------------------\n"
				";        ߥϥɥѥ\n"
				";            (256ܿ)\n"
				"; -----------------------------------------------\n"
				"intvec_seg\tcseg\ton 256 local\n"
				"\t\textrn\tint_default\n"
				"\t\tpublic\tint_vector\n"
				"int_vector:\t\n"
			);
	for ( i = 0; i < MAX_INT; i++ ) {
		if ( ppIntTable[i] == NULL )
			fprintf(fp, "\t\tdw\tint_default\n");
		else
			fprintf(fp, "\t\tdw\tint%d\n", i * 2);
	}
	
	/* ߥϥɥ */
	fprintf(fp,
				"\n\n"
				"; -----------------------------------------------\n"
				";          ߥϥɥ\n"
				"; -----------------------------------------------\n"
				"\t\tcseg\n"
				"\t\textrn\tint_trap\n\n"
			);
	for ( i = 0; i < MAX_INT; i++ ) {
		if ( ppIntTable[i] != NULL ) {
			fprintf(fp, "int%d:\t\tpush\tiy\n", i * 2);
			fprintf(fp, "\t\tld\tiy,%s_##\n", ppIntTable[i]);
			fprintf(fp, "\t\tjp\tint_trap\n\n");
		}
	}
	
	fprintf(fp, "\n\t\tend\n");
	
	fclose(fp);
}



/* ------------------------------------ */
/*           ޥɲ               */
/* ------------------------------------ */

/* ޥɲ (CRE_TSK, CRE_SEM, CRE_FLG, CRE_MBX) */
void AnalizeCommand(char ***pppTable, int nPara, char *pBuf)
{
	char **ppPar;
	int  nID;
	
	/*  */
	ppPar = (char **)calloc(MAX_PARAMETER, sizeof(char *));
	if ( ppPar == NULL ) {
		fprintf(stderr, "­Ǥ\n");
		exit(1);
	}
	
	/* ѥ᡼ʬ */
	if ( !ClipParameter(ppPar, nPara, pBuf) ) {
		FreeParameter(ppPar);
		return;
	}

	/* IDå */
	if ( StrToInt(&nID, ppPar[0]) ) {
		nID--;
		if ( nID < 0 || nID >= MAX_ID ) {
			fprintf(stdout, "ֹ %d: IDֹ椬Ǥ\n", nLine);
			FreeParameter(ppPar);
			bErr = TRUE;
			return;
		}
		if ( pppTable[nID] != NULL ) {
			fprintf(stdout, "ֹ %d: IDֹ椬ʣƤޤ\n", nLine);
			FreeParameter(ppPar);
			bErr = TRUE;
			return;
		}
		ppPar[0][0] = '\0';
	}
	else {
		for ( nID = 0; nID < MAX_ID; nID++ ) {
			if ( pppTable[nID] == NULL )
				break;
		}
		if ( nID >= MAX_ID ) {
			fprintf(stdout, "ֹ %d: ѲǽIDȤڤޤ\n", nLine);
			FreeParameter(ppPar);
			bErr = TRUE;
			return;
		}
	}
	
	/* Ͽ */
	pppTable[nID] = ppPar;
}


/* DEF_INT β */
void AnalizeDefInt(char *pBuf)
{
	char *ppPara[2] = {NULL, NULL};
	int  nIntNum;

	/* ޥڤФ */
	if ( !ClipParameter(ppPara, 2, pBuf) ) {
		if ( ppPara[0] != NULL )  free(ppPara[0]);
		if ( ppPara[1] != NULL )  free(ppPara[1]);
		return;
	}

	/* ֹå */
	if ( !StrToInt(&nIntNum, ppPara[0])
			|| nIntNum < 0 || nIntNum >= 256 || nIntNum % 1 != 0 ) {
		fprintf(stdout, "ֹ %d: ֹλ꤬\n", nLine);
		if ( ppPara[0] != NULL )  free(ppPara[0]);
		if ( ppPara[1] != NULL )  free(ppPara[1]);
		bErr = TRUE;
		return;
	}
	if ( ppIntTable[nIntNum / 2] != NULL ) {
		fprintf(stdout, "ֹ %d: ֹ椬ʣ\n", nLine);
		if ( ppPara[0] != NULL )  free(ppPara[0]);
		if ( ppPara[1] != NULL )  free(ppPara[1]);
		bErr = TRUE;
		return;
	}

	/* ߥå */
	ppIntTable[nIntNum / 2] = ppPara[1];
	free(ppIntTable[0]);
}


/* INCLUDE_C β */
void AnalizeIncludeC(char *pBuf)
{
	char *ppPara[1] = {NULL};

	if ( !ClipParameter(ppPara, 1, pBuf) ) {
		if ( ppPara[0] != NULL )  free(ppPara[0]);
		return;
	}

	if ( nIncCCount >= MAX_INCLUDE_C ) {
		fprintf(stdout, "ֹ %d: 󥯥롼ɥե뤬¿ޤ\n",
					nLine);
		free(ppPara[0]);
		bErr = TRUE;
		return;
	}
	
	ppIncludeCTable[nIncCCount++] = ppPara[0];
}


/* MAX_TSKPRI β */
void AnalizeMaxTskPri(char *pBuf)
{
	char *ppPara[1] = {NULL};
	int  nPri;
	
	if ( !ClipParameter(ppPara, 1, pBuf) ) {
		if ( ppPara[0] != NULL )  free(ppPara[0]);
		return;
	}
	
	pMaxTskPri = ppPara[0];
}


/* SYSTEM_STACK β */
void AnalizeSysStack(char *pBuf)
{
	char *ppPara[1] = {NULL};
	int  nAdr;

	if ( !ClipParameter(ppPara, 1, pBuf) ) {
		if ( ppPara[0] != NULL )  free(ppPara[0]);
		return;
	}
	if ( StrToInt(&nAdr, ppPara[0]) )
		SystemStack = (unsigned short)nAdr;
	else
		fprintf(stdout, "ֹ %d: SYSTEM_STACKΥѥ顼᡼Ǥ\n",
							nLine);
		
	free(ppPara[0]);
}


/* ------------------------------------ */
/*           곫                 */
/* ------------------------------------ */

/* ѥ᡼¸ʬγ */
void FreeParameter(char **ppPara)
{
	int i;
	
	for ( i = 0; i < MAX_PARAMETER; i++ ) {
		if ( ppPara[i] != NULL ) {
			free(ppPara[i]);
			ppPara[i] = NULL;
		}
	}
	free(ppPara);
}

/* ѥ᡼ơ֥γ */
void FreeTable(char ***pppTable)
{
	int i;

	for ( i = 0; i < MAX_ID; i++ ) {
		if ( pppTable[i] != NULL ) {
			FreeParameter(pppTable[i]);
			pppTable[i] = NULL;
		}
	}
}



/* ------------------------------------ */
/*            ʸ                */
/* ------------------------------------ */

/* ζν */
void CutSpace(char *pBuf)
{
	char *p;
	
	/* ζ򥫥å */
	p = &pBuf[strlen(pBuf) - 1];
	while ( p >= pBuf && (*p == ' ' || *p == '\t' || *p == '\n') )
		p--;
	*(p + 1) = '\0';
	
	/* Ⱦζ򥫥å */
	p = pBuf;
	while ( *p == ' ' || *p == '\t' )
		p++;
	memmove(pBuf, p, strlen(p) + 1);
}


/* ̤ǰϤޤ줿ΰ褫ѥ᡼ڤФ */
int ClipParameter(char *ppPar[], int nNum, char *pBuf)
{
	char *pBase;
	int  nParNest = 1;
	int  i;

	/* Ϥޤ '(' å */
	CutSpace(pBuf);
	if ( *pBuf++ != '(' ) {
		fprintf(stdout, "ֹ %d: ɬפʥޥɤǤ\n", nLine);
		bErr = TRUE;
		return FALSE;
	}
	
	/* ʬ */
	for ( i = 0; i < nNum; i++ ) {
		pBase = pBuf;
		while ( *pBuf ) {
			if ( nParNest == 1 && *pBuf == ',' )
				break;
			if ( *pBuf == '(' )
				nParNest++;
			if ( *pBuf == ')' )
				nParNest--;
			if ( nParNest == 0 )
				break;
			pBuf++;
		}
		if ( (i < nNum - 1 && *pBuf == ',')
				|| (i == nNum - 1 && *pBuf == ')') ) {
			*pBuf++ = '\0';
			CutSpace(pBase);
			ppPar[i] = (char *)calloc(strlen(pBase) + 1, sizeof(char));
			if ( ppPar[i] == NULL ) {
				fprintf(stderr, "­Ǥ\n");
				exit(1);
			}
			strcpy(ppPar[i], pBase);
		}
		else {
			fprintf(stdout, "ֹ %d: ѥ᡼۾\n", nLine);
			bErr = TRUE;
			return FALSE;
		}
	}
	
	return TRUE;
}


/* ʸͤѴ(16б */
int StrToInt(int *pNum, char *pBuf)
{
	/* 򥫥å */
	CutSpace(pBuf);
	
	/* ͤɤå */
	if ( pBuf[0] < '0' || pBuf[0] > '9' )
		return FALSE;
	
	/* ʤɤå */
	if ( pBuf[0] == '0' && (pBuf[1] == 'x' || pBuf[1] == 'X') )
		return (sscanf(&pBuf[2], "%x", pNum) == 1);
	
	return (sscanf(&pBuf[0], "%d", pNum) == 1);
}

