/* ------------------------------------------------------------------------- */
/*  HOS                                                            */
/*                                               Copyright (C) 1998 by Ryuz  */
/* ------------------------------------------------------------------------- */

-- 
#include <ITRON.h>


/* ٥ȥե饰Ԥ */
typedef struct t_wflg_stat {
	UB  waiptn;	/* Ԥӥåȥѥ */
	UB  wfmode;	/* Ԥ⡼ */
} T_WFLG_STAT;


/* ե饰Υå */
BOOL __chk_flg(T_FCB *fcb, T_WFLG_STAT *wflg_stat);


-_ini_flg.c
/* ٥ȥե饰 */
void __ini_flg(void)
{
	int i;
	
	for ( i = 0; i < fcbcnt; i++ ) {
		fcbtbl[i].flgptn     = fcbstbl[i].iflgptn;
		fcbtbl[i].que.tskcnt = 0;
	}
}


-set_flg.c
/* ٥ȥե饰å */
ER   set_flg(ID flgid, UB setptn)
{
	T_FCB *fcb;
	T_TCB *tcb;
	UB    old_syssat;
	BOOL  reqdsp;
	
#if __ERR_CHECK_LEVEL >= 4
	/* IDå */
	if ( flgid <= 0 )
		return E_ID;
	if ( flgid > fcbcnt )
		return E_NOEXS;
#endif
	
	fcb = &fcbtbl[flgid - 1];
	
	__set_imsk();
	
	/* ե饰å */
	fcb->flgptn |= setptn;
	
	/* ԤΥΥå */
	if ( fcb->que.tskcnt > 0 ) {
		/* Ū˥ǥѥåػ */
		old_syssat = sysstat;
		sysstat   |= TSS_DDSP;
		reqdsp = FALSE;
		
		/* ե饰ΰפ륿Ƶ */
		tcb = fcb->que.head;
		do {
			if ( __chk_flg(fcb, (T_WFLG_STAT *)tcb->data) ) {
				__wup_dsp(tcb, E_OK);
				reqdsp = TRUE;
			}
			tcb = tcb->next;
		} while ( tcb != fcb->que.head );
		
		/*  */
		sysstat = old_syssat;
		
		/* ʤǥѥå */
		if ( reqdsp )
			__tsk_dsp();
	}
	
	__res_imsk();
	
	return E_OK;
}


-clr_flg.c
/* ٥ȥե饰Υꥢ */
ER   clr_flg(ID flgid, UB clrptn)
{
	T_FCB *fcb;
	
#if __ERR_CHECK_LEVEL >= 4
	/* IDå */
	if ( flgid <= 0 )
		return E_ID;
	if ( flgid > fcbcnt )
		return E_NOEXS;
#endif
	
	fcb = &fcbtbl[flgid - 1];
	
	__set_imsk();
	
	/* ե饰ꥢ */
	fcb->flgptn &= clrptn;
	
	__res_imsk();
	
	return E_OK;
}


-wai_flg.c
/* ٥ȥե饰Ԥ */
ER   wai_flg(UB *p_flgptn, ID flgid, UB waiptn, UB wfmode)
{
	T_WFLG_STAT wflg_stat;
	T_FCB  *fcb;
	INT    ercd;
	
#if __ERR_CHECK_LEVEL >= 4
	/* IDå */
	if ( flgid <= 0 )
		return E_ID;
	if ( flgid > fcbcnt )
		return E_NOEXS;
	if ( wfmode > 3 || waiptn == 0 )
		return E_PAR;
#endif
	
	fcb = &fcbtbl[flgid - 1];
	
	__set_imsk();
	
#if __ERR_CHECK_LEVEL >= 3
	/* ֥å */
	if ( sysstat != 0 ) {
		__res_imsk();
		return E_CTX;
	}
#endif
	
	/* ե饰å */
	wflg_stat.waiptn = waiptn;
	wflg_stat.wfmode = wfmode;
	if ( __chk_flg(fcb, &wflg_stat) ) {
		__res_imsk();
		return E_OK;
	}
	
	/* Ԥ֤˰ܹ */
	__del_que(curtcb);
	curtcb->tskstat = TTS_WAI;
	curtcb->tskwait = TTW_FLG;
	curtcb->data    = (VP)&wflg_stat;
	__adt_que(&fcb->que, curtcb);
	
	/* ǥѥå */
	ercd = __tsk_dsp();
	
	if ( p_flgptn != NADR )
		*p_flgptn = fcb->flgptn;
	
	__res_imsk();
	
	return ercd;
}


-pol_flg.c
/* ٥ȥե饰Ԥ(ݡ) */
ER   pol_flg(UB *p_flgptn, ID flgid, UB waiptn, UB wfmode)
{
	T_WFLG_STAT wflg_stat;
	T_FCB  *fcb;
	
#if __ERR_CHECK_LEVEL >= 4
	/* IDå */
	if ( flgid <= 0 )
		return E_ID;
	if ( flgid > fcbcnt )
		return E_NOEXS;
	if ( wfmode > 3 || waiptn == 0 )
		return E_PAR;
#endif
	
	fcb = &fcbtbl[flgid - 1];
	
	__set_imsk();
	
	/* ե饰å */
	wflg_stat.waiptn = waiptn;
	wflg_stat.wfmode = wfmode;
	if ( __chk_flg(fcb, &wflg_stat) ) {
		if ( p_flgptn != NADR )
			*p_flgptn = fcb->flgptn;
		__res_imsk();
		return E_OK;
	}
	
	__res_imsk();
	
	return E_TMOUT;
}


-ref_flg.c
/* ٥ȥե饰ֻ */
ER   ref_flg(T_RFLG *pk_rflg, ID flgid)
{
	T_FCB  *fcb;
	T_FCBS *fcbs;
	
#if __ERR_CHECK_LEVEL >= 4
	/* IDå */
	if ( flgid <= 0 )
		return E_ID;
	if ( flgid > fcbcnt )
		return E_NOEXS;
#endif
	
	fcb  = &fcbtbl[flgid - 1];
	fcbs = &fcbstbl[flgid - 1];
	
	__set_imsk();
	
	pk_rflg->exinf = fcbs->exinf;
	if ( fcb->que.tskcnt == 0 )
		pk_rflg->wtsk = 0;
	else
		pk_rflg->wtsk = (BOOL_ID)(fcb->que.head - tcbtbl + 1);
	pk_rflg->flgptn = fcb->flgptn;
	
	__res_imsk();
	
	return E_OK;
}


-_chk_flg.c
/* ե饰Υå */
BOOL __chk_flg(T_FCB *fcb, T_WFLG_STAT *wflg_stat)
{
	/* ե饰å */
	if ( wflg_stat->wfmode & TWF_ORW ) {
		if ( !(fcb->flgptn & wflg_stat->waiptn) )
			return FALSE;
	}
	else {
		if ( (fcb->flgptn & wflg_stat->waiptn) != wflg_stat->waiptn )
			return FALSE;
	}
	
	/* TWF_CLRꤵƤХե饰򥯥ꥢ */
	if ( wflg_stat->wfmode & TWF_CLR )
		fcb->flgptn = 0;
	
	return TRUE;
}

