/* ------------------------------------------------------------------------- */
/*  HOS                                                            */
/*                                               Copyright (C) 1998 by Ryuz  */
/* ------------------------------------------------------------------------- */

-- C 
#include <ITRON.h>


-_ini_tsk.c
/* Хѿ */
T_TCB  *curtcb;			/* ߤΥTCB */
BOOL   dlydsp;			/* ٱ䤵Ƥǥѥå뤫 */


/* ν */
void __ini_tsk(void)
{
	int i;
	
	curtcb = NADR;
	dlydsp = FALSE;
	
	/* ǥ塼ν */
	for ( i = 0; i < rdqcnt; i++ )
		rdyque[i].tskcnt = 0;
	
	/* TCBơ֥ν */
	for ( i = 0; i < tcbcnt; i++ ) {
		if ( tcbstbl[i].itskpri != 0 )
			tcbtbl[i].tskstat = TTS_DMT;
		else 
			tcbtbl[i].tskstat = 0;	/* NON-EXISTENT */
		tcbtbl[i].que = NADR;
	}
}


-sta_tsk.c
/*  */
ER sta_tsk(ID tskid, INT stacd)
{
	T_TCB  *tcb;
	T_TCBS *tcbs;
	
#if __ERR_CHECK_LEVEL >= 4
	/* IDå */
	if ( tskid <= 0 )
		return E_ID;
	if ( tskid > tcbcnt || tcbtbl[tskid - 1].tskstat == 0 )
		return E_NOEXS;
#endif
	
	tcb  = &tcbtbl[tskid - 1];
	tcbs = &tcbstbl[tskid - 1];
	
	__set_imsk();
	
#if __ERR_CHECK_LEVEL >= 2
	/* ֥å */
	if ( tcb->tskstat != TTS_DMT ) {
		__res_imsk();
		return E_OBJ;
	}
#endif
	
	/* TCB */
	tcb->sp      = tcbs->isp;
	tcb->tskpri  = tcbs->itskpri;
	tcb->tskstat = TTS_RDY;
	tcb->wupcnt  = 0;
	tcb->suscnt  = 0;
	
	/* åν */
	*(--tcb->sp) = (UH)__tskst_entry;	/* ꥿󥢥ɥ쥹 */
	*(--tcb->sp) = (UH)tcbs->task;		/* ϥɥ쥹 */
	*(--tcb->sp) = (UH)stacd;			/*  */
	
	/* READY塼ɲ */
	__adt_que(&rdyque[tcb->tskpri - 1], tcb);
	
	/* ǥѥå */
	__tsk_dsp();
	
	__res_imsk();
	
	return E_OK;
}

-- ֥
				cseg
-_tss_ent.asz
; -----------------------------------------------
;           ʬ
;     ǽΥǥѥå夳
; -----------------------------------------------
				extrn	ext_tsk_
				public	__tskst_entry_
__tskst_entry_:	
				ld		iy,tse_ret
				push	iy
				ei						; ߵ
				jp		(ix)			; ɥ쥹
tse_ret:		jp		ext_tsk_		; λ



-- ø
#include <ITRON.h>


-ext_tsk.c
/* λ */
void ext_tsk(void)
{
#if __ERR_CHECK_LEVEL >= 4
	/* 顼å */
	if ( sysstat != TSS_TSK ) {
		/* ̿Ū顼꥿ʤ */
		sysstat = TSS_TSK;
	}
#endif
	
	__set_imsk();
	
	if ( curtcb != NADR ) {
		/* 塼鳰DOMANT֤˰ܹ */
		if ( curtcb->que != NADR )
			__del_que(curtcb);
		curtcb->tskstat = TTS_DMT;
		curtcb = NADR;
	}
	
	/* ǥѥå */
	__tsk_dsp();
}


-ter_tsk.c
/* ¾λ */
ER  ter_tsk(ID tskid)
{
	T_TCB *tcb;
	
#if __ERR_CHECK_LEVEL >= 4
	/* IDå */
	if ( tskid <= 0 )
		return E_ID;
	if ( tskid > tcbcnt || tcbtbl[tskid - 1].tskstat == 0 )
		return E_NOEXS;
#endif
	
	tcb = &tcbtbl[tskid - 1];
	
	__set_imsk();
	
#if __ERR_CHECK_LEVEL >= 2
	/* ֥å */
	if ( (!(sysstat & TSS_INDP) && tcb == curtcb)
				|| tcb->tskstat == TTS_DMT || tcb->tskstat == TTS_GST ) {
		__res_imsk();
		return E_OBJ;
	}
#endif
	
	/* λ */
	if ( tcb->que != NADR )
		__del_que(tcb);
	tcb->tskstat = TTS_DMT;
	if ( curtcb == tcb ) {
		if ( sysstat & TSS_DDSP )
			curtcb->tskstat = TTS_GST;
		else
			curtcb = NADR;
	}
	
	/* ǥѥå */
	__tsk_dsp();
	
	__res_imsk();
	
	return E_OK;
}


-dis_dsp.c
/* ǥѥåػ */
ER  dis_dsp(void)
{
#if __ERR_CHECK_LEVEL >= 3
	/* 顼å */
	if ( sysstat & (TSS_INDP | TSS_DINT) )
		return E_CTX;
#endif
	__set_imsk();
	
	sysstat = TSS_DDSP;
	
	__res_imsk();
	
	return E_OK;
}


-ena_dsp.c
/* ǥѥå */
ER  ena_dsp(void)
{
#if __ERR_CHECK_LEVEL >= 3
	/* 顼å */
	if ( sysstat & (TSS_INDP | TSS_DINT) )
		return E_CTX;
#endif
	
	__set_imsk();
	
	if ( curtcb->tskstat == TTS_GST )
		ext_tsk();	/* ٱ佪λ */
	
	/* ٱǥѥå */
	sysstat = TSS_TSK;
	if ( dlydsp )
		__tsk_dsp();
	
	__res_imsk();
	
	return E_OK;
}


-chg_pri.c
/* ͥѹ */
ER  chg_pri(ID tskid, PRI tskpri)
{
	T_TCB *tcb;
	
#if __ERR_CHECK_LEVEL >= 4
	/* ѥ᡼å */
	if ( tskid > tcbcnt )
		return E_NOEXS;
	if ( tskid == TSK_SELF && (sysstat & TSS_INDP) )
		return E_ID;
	if ( tskpri > rdqcnt )
		return E_PAR;
#endif
	
	/* ID -> TCB */
	if ( tskid == TSK_SELF )
		tcb = curtcb;
	else
		tcb = &tcbtbl[tskid - 1];
	
	__set_imsk();
	
#if __ERR_CHECK_LEVEL >= 2
	/* ֥å */
	if ( tcb->tskstat == TTS_DMT ) {
		__res_imsk();
		return E_OBJ;
	}
#endif
	
	/* ͥ٤ѹ */
	if ( tskpri == TPRI_INI )
		tcb->tskpri = tcbstbl[tskid - 1].itskpri;
	else
		tcb->tskpri = tskpri;
	if ( tcb->tskstat == TTS_RDY ) {
		/* ǥ塼ηҤؤ */
		__del_que(tcb);
		__adt_que(&rdyque[tskpri - 1], tcb);
	}
	
	/* ǥѥå */
	__tsk_dsp();
	
	__res_imsk();
	
	return E_OK;
}


-rot_rdq.c
/* ǥ塼βž */
ER  rot_rdq(PRI tskpri)
{
	T_TCB *tcb;
	
#if __ERR_CHECK_LEVEL >= 4
	/* ѥ᡼å */
	if ( tskpri > rdqcnt )
		return E_PAR;
#endif
	
	__set_imsk();
	
	if ( tskpri == TPRI_RUN ) {
		if ( curtcb == NADR ) {
			__res_imsk();
			return E_OK;	/* ̵ϲ⤷ʤ */
		}
		tskpri = curtcb->tskpri;
	}
	
	/* 塼˥Ϥ뤫 */
	if ( rdyque[tskpri - 1].tskcnt == 0 ) {
		__res_imsk();
		return E_OK;
	}
	
	/* ǥ塼ž */
	__rot_que(&rdyque[tskpri - 1]);
	
	/* ɬפǤХǥѥåԤʤ */
	tcb = rdyque[tskpri - 1].head;
	if ( curtcb->tskpri == tskpri && tcb != curtcb ) {
		if ( sysstat == TSS_TSK ) {
			/* ǥѥå */
			curtcb->tskstat = TTS_RDY;
			tcb->tskstat    = TTS_RUN;
			__swc_dsp(tcb);
		}
		else {
			/* ٱǥѥåν */
			dlydsp = TRUE;
		}
	}
	
	__res_imsk();
	
	return E_OK;
}


-rel_wai.c
/* ¾Ԥֲ */
ER  rel_wai(ID tskid)
{
	T_TCB *tcb;
	
#if __ERR_CHECK_LEVEL >= 4
	/* IDå */
	if ( tskid <= 0 )
		return E_ID;
	if ( tskid > tcbcnt || tcbtbl[tskid - 1].tskstat == 0 )
		return E_NOEXS;
#endif
	
	tcb = &tcbtbl[tskid - 1];
	
	__set_imsk();
	
#if __ERR_CHECK_LEVEL >= 2
	/* ֥å */
	if ( !(tcb->tskstat & TTS_WAI) ) {
		__res_imsk();
		return E_OBJ;
	}
#endif
	
	/* Ԥ */
	__wup_dsp(tcb, E_RLWAI);
	
	__res_imsk();
	
	return E_OK;
}


-get_tid.c
/* ID */
ER   get_tid(ID *p_tskid)
{
#if __ERR_CHECK_LEVEL >= 4
	if ( (sysstat & TSS_INDP) || curtcb == NADR ) {
		*p_tskid = FALSE;
		return E_OK;
	}
#endif
	
	*p_tskid = (curtcb - tcbtbl) + 1;
	
	return E_OK;
}


-ref_tsk.c
/* ֻ */
ER   ref_tsk(T_RTSK *pk_rtsk, ID tskid)
{
	T_TCB  *tcb;
	T_TCBS *tcbs;
	
#if __ERR_CHECK_LEVEL >= 4
	/* IDå */
	if ( tskid > tcbcnt || tcbtbl[tskid - 1].tskstat == 0 )
		return E_NOEXS;
	if ( tskid == TSK_SELF && ((sysstat & TSS_INDP) || curtcb == NADR) )
		return E_ID;
#endif
	
	if ( tskid == TSK_SELF )
		tskid = (tcbtbl - curtcb) + 1;
	
	tcb  = &tcbtbl[tskid - 1];
	tcbs = &tcbstbl[tskid - 1];
	
	__set_imsk();
	
	pk_rtsk->exinf   = tcbs->exinf;
	pk_rtsk->tskpri  = tcb->tskpri;
	pk_rtsk->tskstat = tcb->tskstat;
	
	__res_imsk();
	
	return E_OK;
}




-sus_tsk.c
/* ¾Ԥ֤ذܹ */
ER   sus_tsk(ID tskid)
{
	T_TCB *tcb;
	
#if __ERR_CHECK_LEVEL >= 4
	/* IDå */
	if ( tskid <= 0 )
		return E_ID;
	if ( tskid > tcbcnt || tcbtbl[tskid - 1].tskstat == 0 )
		return E_NOEXS;
#endif
	
	tcb = &tcbtbl[tskid - 1];
	
	__set_imsk();
	
#if __ERR_CHECK_LEVEL >= 2
	if ( (!(sysstat & TSS_INDP) && tcb == curtcb)
			|| tcb->tskstat == TTS_DMT ) {
		__res_imsk();
		return E_OBJ;
	}
#endif
	
	/*  SUSPENDʤͥ */
	if ( tcb->tskstat & TTS_SUS ) {
#if __ERR_CHECK_LEVEL >= 1
		/* ͥȤΥСեå */
		if ( tcb->suscnt >= MAX_SUSCNT )
			return E_QOVR;
#endif
		tcb->suscnt++;
	}
	else {
		/* SUSPEND */
		if ( tcb->tskstat == TTS_RDY || tcb->tskstat == TTS_RUN )
			__del_que(tcb);		/* READYʤǥ塼鳰 */
		if ( tcb->tskstat & TTS_WAI )
			tcb->tskstat = TTS_WAS;
		else
			tcb->tskstat = TTS_SUS;
		
		/* ΩǼ¹Υꤷ */
		if ( tcb == curtcb )
			dlydsp = TRUE;	/* ٱǥѥå */
	}
	
	__res_imsk();
	
	return E_OK;
}


-rsm_tsk.c
/* Ԥ֤ΥƳ */
ER   rsm_tsk(ID tskid)
{
	T_TCB *tcb;
	
#if __ERR_CHECK_LEVEL >= 4
	/* IDå */
	if ( tskid <= 0 )
		return E_ID;
	if ( tskid > tcbcnt || tcbtbl[tskid - 1].tskstat == 0 )
		return E_NOEXS;
#endif
	
	tcb = &tcbtbl[tskid - 1];
	
	__set_imsk();
	
#if __ERR_CHECK_LEVEL >= 2
	/* 顼å */
	if ( tcb == curtcb || !(tcb->tskstat & TTS_SUS) ) {
		__res_imsk();
		return E_OBJ;
	}
#endif
	
	if ( tcb->suscnt != 0 ) {
		/* ͥȥǥ */
		tcb->suscnt--;
	}
	else {
		/* SUSPEND  */
		tcb->tskstat &= ~TTS_SUS;
		if ( tcb->tskstat != TTS_WAI ) {
			/* ǥ塼³ */
			__adt_que(&rdyque[tcb->tskpri - 1], tcb);
			tcb->tskstat = TTS_RDY;
			
			/* ǥѥå */
			__tsk_dsp();
		}
	}
	
	__res_imsk();
	
	return E_OK;
}


-frsm_tsk.c
/* Ԥ֤ΥƳ */
ER frsm_tsk(ID tskid)
{
	T_TCB *tcb;
	
#if __ERR_CHECK_LEVEL >= 4
	/* IDå */
	if ( tskid <= 0 )
		return E_ID;
	if ( tskid > tcbcnt || tcbtbl[tskid - 1].tskstat == 0 )
		return E_NOEXS;
#endif
	
	tcb = &tcbtbl[tskid - 1];
	
	__set_imsk();
	
#if __ERR_CHECK_LEVEL >= 2
	/* 顼å */
	if ( tcb == curtcb || !(tcb->tskstat & TTS_SUS) ) {
		__res_imsk();
		return E_OBJ;
	}
#endif
	
	/*  */
	tcb->suscnt = 0;
	return rsm_tsk(tskid);
}


-slp_tsk.c
/* 򵯾Ԥ֤ذܹ */
ER   slp_tsk(void)
{
	ER ercd;
	
#if __ERR_CHECK_LEVEL >= 3
	/* 顼å */
	if( sysstat != 0 )
		return E_CTX;
#endif
	
	__set_imsk();
	
	/* ׵Υ塼󥰤뤫 */
	if ( curtcb->wupcnt > 0 ) {
		curtcb->wupcnt--;
		__res_imsk();
		return E_OK;
	}
	
	/* Ԥ֤˰ܹ */
	__del_que(curtcb);
	curtcb->tskstat = TTS_WAI;
	curtcb->tskwait = TTW_SLP;
	
	/* ǥѥå */
	ercd = __tsk_dsp();
	
	__res_imsk();
	
	return ercd;
}


/* ¾ε */
ER   wup_tsk(ID tskid)
{
	T_TCB *tcb;
	
#if __ERR_CHECK_LEVEL >= 4
	/* ID å */
	if ( tskid <= 0 )
		return E_ID;
	if ( tskid > tcbcnt || tcbtbl[tskid - 1].tskstat == 0 )
		return E_NOEXS;
#endif
	
	tcb = &tcbtbl[tskid - 1];
	
	__set_imsk();
	
#if __ERR_CHECK_LEVEL >= 2
	/* ֥å */
	if ( tcb == curtcb || tcb->tskstat == TTS_DMT ) {
		__res_imsk();
		return E_OBJ;
	}
#endif
	
	/* Ԥ֤ǤʤХ塼 */
	if ( !(tcb->tskstat & TTS_WAI) || tcb->tskwait != TTW_SLP ) {
#if __ERR_CHECK_LEVEL >= 1
		if ( tcb->wupcnt == MAX_WUPCNT ) {
			__res_imsk();
			return E_QOVR;
		}
#endif
		tcb->wupcnt++;
	}
	else {
		/* Ԥ */
		tcb->tskstat &= ~TTS_WAI;
		tcb->tskwait  = 0;
		*(tcb->sp)    = E_OK;
		if ( tcb->tskstat != TTS_SUS ) {
			/* ǥ塼³ */
			tcb->tskstat = TTS_RDY;
			__adt_que(&rdyque[tcb->tskpri - 1], tcb);
			
			/* ǥѥå */
			__tsk_dsp();
		}
	}
	
	__res_imsk();
	
	return E_OK;
}


-can_wup.c
/* ׵̵ */
ER   can_wup(ID tskid)
{
	T_TCB *tcb;
	INT   wupcnt;
	
#if __ERR_CHECK_LEVEL >= 4
	/* IDå */
	if ( tskid > tcbcnt || tcbtbl[tskid - 1].tskstat == 0 )
		return E_NOEXS;
	if ( tskid == TSK_SELF && (sysstat & TSS_INDP) )
		return E_ID;
#endif
	
	if ( tskid == TSK_SELF )
		tcb = curtcb;
	else
		tcb = &tcbtbl[tskid - 1];
	
	__set_imsk();
	
	wupcnt = tcb->wupcnt;
	tcb->wupcnt = 0;
	
	__res_imsk();
	
	return wupcnt;
}

