/* ------------------------------------------------------------------------- */
/*  HOS-H8  ե졼                                           */
/*                                                                           */
/*                                   Copyright (C) 1998-2002 by Project HOS  */
/* ------------------------------------------------------------------------- */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>


/* ------------------------------------ */
/*                              */
/* ------------------------------------ */

#define TRUE  1
#define FALSE 0

#define MAX_PATH   		256		/* ѥ̾ */
#define MAX_PARAMETER     6     /* ѥ᡼ */
#define MAX_ID          255     /* ɣĿ */
#define MAX_INCLUDE_C    64		/* ɤ߹ߥե(ø) */



/* ------------------------------------ */
/*             ؿ                 */
/* ------------------------------------ */

/* ޥɲ */
int  AnalizeCommand(char *(*pppPara[MAX_PARAMETER]), int nPara, char *pBuf);
void AnalizeDefInt(char *pBuf);
void AnalizeIncludeC(char *pBuf);
void AnalizeMaxTskPri(char *pBuf);
void AnalizeSysStack(char *pBuf);

/* γ */
void FreeParameter(char *ppPara[MAX_PARAMETER]);
void FreeTable(char ***pppTable);

/* ʸ */
void CutSpace(char *pBuf);
int  ClipParameter(char *ppPar[], int nNum, char *pBuf);
int  StrToInt(int *pNum, char *pBuf);
int  StrToLong(long *pNum, char *pBuf);

/* ե */
void Write_Def_ID(void);		/* ե */
void Write_C_Cfg(void);			/* ø */
void Write_Asm_Cfg(void);		/* ֥ */



/* ------------------------------------ */
/*             ѿ                 */
/* ------------------------------------ */

char szCfgFile[MAX_PATH]  = "hos.cfg";		/* ե졼ե */
#ifdef __USE_CROSS_GCC__
char szAsmFile[MAX_PATH]  = "cfg_asm.s";	/* ֥ϥե̾ */
#else
char szAsmFile[MAX_PATH]  = "cfg_asm.src";	/* ֥ϥե̾ */
#endif
char szCFile[MAX_PATH]    = "cfg_c.c";		/* øϥե̾ */
char szDefCFile[MAX_PATH] = "defid.h";		/* إåե̾ */

int  nLine;			/* ιֹ */
int  bErr = FALSE;	/* 顼 */

#define ADVANCED 0
#define NORMAL   1
int  Mode = ADVANCED;

#define MAX_INT_ADVANCED  64		/* ֹ */
#define MAX_INT_TINY	  26		/* TINY б        */
int maxInt = MAX_INT_ADVANCED;

char *pMaxTskPri = NULL;		/* ͥ(ǥեȤǣ) */

/* ƥѥ᡼ Ǽ */
char **pppTaskTable[MAX_ID];	/* ǡơ֥ */
char **pppSplTable[MAX_ID];		/* åסǡơ֥ */
char **pppSemTable[MAX_ID];		/* ޥեǡơ֥ */
char **pppFlgTable[MAX_ID];		/* ٥ȥե饰ǡơ֥ */
char **pppMbxTable[MAX_ID];		/* åܥåǡơ֥ */
char **pppMpfTable[MAX_ID];		/* Ĺסǡơ֥ */
char *ppIntTable[MAX_INT_ADVANCED];		/* ߥ٥Υơ֥ */
int  nTaskCount;	/* ο */
int  nSplCount;		/* åסο */
int  nSemCount;		/* ޥեο */
int  nFlgCount;		/* ٥ȥե饰ο */
int  nMbxCount;		/* ᥤܥå */
int  nMpfCount;		/* Ĺסο */

char *ppIncludeCTable[MAX_INCLUDE_C];	/* øΥ󥯥롼ɥե */
int  nIncCCount;		/* ø쥤󥯥롼ɥե */

#define SYSSTACK_ADV  0xfff10
#define SYSSTACK_TINY 0xff80
unsigned long SystemStack = SYSSTACK_ADV; /* ƥॹåΥɥ쥹 */

int  bUseTimer = TRUE;		/* ޤȤɤ */



/* ------------------------------------ */
/*             ᥤ                   */
/* ------------------------------------ */

/* ᥤؿ */
int main(int argc, char *argv[])
{
	FILE *fp;
	char szBuf[256];
	int  i;
	
	/* ɽ */
	fprintf(stderr, "HOS-H8 Configurator\n");
	
	/* ޥɥ饤 */
	if ( argc > 3 ) {
		fprintf(stderr,"Usage: %s [[-n] config_file]\n-n  normal mode.\n", argv[0]);
		exit(1);
	}

	/* Ρޥ⡼ */
	if ( argc > 1) {
		if ( (i = strcmp( argv[1], "-n")) == 0) {
			Mode   = NORMAL;
			maxInt = MAX_INT_TINY;
			SystemStack = SYSSTACK_TINY;
		}
		if ( argc == 3 || Mode == ADVANCED )
			strcpy(szCfgFile, argv[argc-1]);
	}
	
	/* ե륪ץ */
	if ( (fp = fopen(szCfgFile, "r")) == NULL ) {
		fprintf(stderr, "%s ޤ\n", szCfgFile);
		exit(1);
	}
	
	/* եβ */
	nLine = 1;
	while ( fgets(szBuf, sizeof(szBuf), fp) != NULL ) {
		/* ;ʬʶ */
		CutSpace(szBuf);
		
		/* ޥ̾˱Ʋ */
		if ( strncmp(szBuf, "CRE_TSKSP", 9) == 0 ) {
			int nID;
			nID = AnalizeCommand(pppTaskTable, 5, &szBuf[9]);
			if ( nID != -1 )
				pppTaskTable[nID][5] = malloc(1);	/*  (^^;; */
		}
		else if ( strncmp(szBuf, "CRE_TSK", 7) == 0 )
			AnalizeCommand(pppTaskTable, 5, &szBuf[7]);
		else if ( strncmp(szBuf, "CRE_SPL", 7) == 0 )
			AnalizeCommand(pppSplTable, 3, &szBuf[7]);
		else if ( strncmp(szBuf, "CRE_SEM", 7) == 0 )
			AnalizeCommand(pppSemTable, 4, &szBuf[7]);
		else if ( strncmp(szBuf, "CRE_FLG", 7) == 0 )
			AnalizeCommand(pppFlgTable, 3, &szBuf[7]);
		else if ( strncmp(szBuf, "CRE_MBX", 7) == 0 )
			AnalizeCommand(pppMbxTable, 3, &szBuf[7]);
		else if ( strncmp(szBuf, "CRE_MPF", 7) == 0 )
			AnalizeCommand(pppMpfTable, 4, &szBuf[7]);
		else if ( strncmp(szBuf, "DEF_INT", 7) == 0 )
			AnalizeDefInt(&szBuf[7]);
		else if ( strncmp(szBuf, "INCLUDE_C", 9) == 0 )
			AnalizeIncludeC(&szBuf[9]);
		else if ( strncmp(szBuf, "MAX_TSKPRI", 10) == 0 )
			AnalizeMaxTskPri(&szBuf[10]);
		else if ( strncmp(szBuf, "SYSTEM_STACK", 12) == 0 )
			AnalizeSysStack(&szBuf[12]);
		else if ( strncmp(szBuf, "USE_TIMER", 9) == 0 )
			bUseTimer = TRUE;
		else if ( strncmp(szBuf, "NOUSE_TIMER", 11) == 0 )
			bUseTimer = FALSE;
		else if ( szBuf[0] != ';' && szBuf[0] != '\0' && szBuf[0] != '\n' ) {
			fprintf(stdout, "line(%d): ʸˡ顼Ǥ\n", nLine);
			bErr = TRUE;
		}
		nLine++;
	}
	
	fclose(fp);
	
	/* ե */
	Write_Def_ID();
	Write_C_Cfg();
	Write_Asm_Cfg();
	
	/* 곫 */
	FreeTable(pppTaskTable);
	FreeTable(pppSemTable);
	FreeTable(pppFlgTable);
	FreeTable(pppMbxTable);
	FreeTable(pppMpfTable);
	if ( pMaxTskPri != NULL )  free(pMaxTskPri);
	for ( i = 0; i < maxInt; i++ )
		if ( ppIntTable[i] != NULL )  free(ppIntTable[i]);
	for ( i = 0; i < MAX_INCLUDE_C; i++ )
		if ( ppIncludeCTable[i] != NULL )  free(ppIncludeCTable[i]);
	
	return bErr;
}



/* ------------------------------------ */
/*         ե                 */
/* ------------------------------------ */

/* ե */
void Write_Def_ID(void)
{
	FILE *fp;
	int  i;
	
	/* ե륪ץ */
	if ( (fp = fopen(szDefCFile, "w")) == NULL ) {
		fprintf(stderr, "%s κ˼Ԥޤ\n", szDefCFile);
		exit(1);
	}
	
	fprintf(fp, "/* HOS-H8 configuration-file to define ID */\n\n");
	fprintf(fp, "#ifndef __HOSCFG__DEFID_H_\n");
	fprintf(fp, "#define __HOSCFG__DEFID_H_\n\n\n");
	
	/* ID  */
	for ( i = 0; i < MAX_ID; i++ ) {
		if ( pppTaskTable[i] != NULL && pppTaskTable[i][0][0] != '\0' ) 
			fprintf(fp, "#define %s\t%d\n", pppTaskTable[i][0], i + 1);
	}
	fprintf(fp, "\n");
	
	/* åסID  */
	for ( i = 0; i < MAX_ID; i++ ) {
		if ( pppSplTable[i] != NULL && pppSplTable[i][0][0] != '\0' ) 
			fprintf(fp, "#define %s\t%d\n", pppSplTable[i][0], i + 1);
	}
	fprintf(fp, "\n");
	
	/* ޥեID  */
	for ( i = 0; i < MAX_ID; i++ ) {
		if ( pppSemTable[i] != NULL && pppSemTable[i][0][0] != '\0' ) 
			fprintf(fp, "#define %s\t%d\n", pppSemTable[i][0], i + 1);
	}
	fprintf(fp, "\n");
	
	/* ٥ȥե饰ID  */
	for ( i = 0; i < MAX_ID; i++ ) {
		if ( pppFlgTable[i] != NULL && pppFlgTable[i][0][0] != '\0' ) 
			fprintf(fp, "#define %s\t%d\n", pppFlgTable[i][0], i + 1);
	}
	fprintf(fp, "\n");
	
	/* ᡼ܥåID  */
	for ( i = 0; i < MAX_ID; i++ ) {
		if ( pppMbxTable[i] != NULL && pppMbxTable[i][0][0] != '\0' ) 
			fprintf(fp, "#define %s\t%d\n", pppMbxTable[i][0], i + 1);
	}
	fprintf(fp, "\n");

	/* ĹסID  */
	for ( i = 0; i < MAX_ID; i++ ) {
		if ( pppMpfTable[i] != NULL && pppMpfTable[i][0][0] != '\0' ) 
			fprintf(fp, "#define %s\t%d\n", pppMpfTable[i][0], i + 1);
	}
	fprintf(fp, "\n");

	fprintf(fp, "\n#endif /* __HOSCFG__DEFID_H_ */\n");
}


/* ե졼եø */
void Write_C_Cfg(void)
{
	FILE *fp;
	char *pPri;
	int  nMaxID;
	int  i;
	
	/* ե륪ץ */
	if ( (fp = fopen(szCFile, "w")) == NULL ) {
		fprintf(stderr, "%s κ˼Ԥޤ\n", szDefCFile);
		exit(1);
	}
	
	/* Ƚ */
	fprintf(fp, "/* HOS-H8 ե졼եø */\n\n");
	
	/* 󥯥롼ɥե */
	fprintf(fp, "#include \"itron.h\"\n");
	fprintf(fp, "#include \"%s\"\n", szDefCFile);
	for ( i = 0; i < nIncCCount; i++ )
		fprintf(fp, "#include %s\n", ppIncludeCTable[i]);
	
	
	/* ------- ƥॹåɥ쥹 -------- */
	fprintf(fp, "\n\n/* ƥॹåɥ쥹 */\n");
	fprintf(fp, "void *const __system_stack = (void *)(0x%05lx);\n",
					SystemStack);
	
	
	
	/* ------- ǥ塼 -------- */
	fprintf(fp, "\n");
	if ( pMaxTskPri == NULL )
		pPri = "8";
	else
		pPri = pMaxTskPri;
	fprintf(fp, "\n\n/* ǥ塼 */\n");
	fprintf(fp, "T_QUE   rdyque[%s];\n", pPri);
	fprintf(fp, "const H rdqcnt = %s;\n", pPri);
	
	
	/* ------- åסǡ -------- */
	fprintf(fp, "\n");
	
	/* 祹åסID */
	nMaxID = 0;
	for ( i = 0; i < MAX_ID; i++ ) {
		if ( pppSplTable[i] != NULL ) {
			nSplCount++;
			nMaxID = i + 1;
		}
	}
	
	if ( nMaxID > 0 ) {
		/* åΰ */
		fprintf(fp, "\n\n/* åסѥåΰ */\n");
		for ( i = 0; i < nMaxID; i++ ) {
			if ( pppSplTable[i] != NULL ) {
				fprintf(fp, "VH StackPool%d[(%s) / 2];\n",
									i + 1, pppSplTable[i][2]);
			}
		}
		
		/* åס */
		fprintf(fp, "\n\n/* åסϿ */\n");
		fprintf(fp, "T_SPCB  spcbtbl[%d];\n", nMaxID);
		fprintf(fp, "const T_SPCBS spcbstbl[%d] = {\n", nMaxID);
		for ( i = 0; i < nMaxID; i++ ) {
			if ( pppSplTable[i] == NULL )
				fprintf(fp, "\t\t{}");
			else
				fprintf(fp, "\t\t{StackPool%d, %s, (%s) / 2}",
							i + 1,
							pppSplTable[i][1],
							pppSplTable[i][2]
						);
			if ( i == nMaxID - 1 )
				fprintf(fp, "\n");
			else
				fprintf(fp, ",\n");
		}
		fprintf(fp, "\t};\n");
	}
	fprintf(fp, "const H  spcbcnt = %d;\t/* åס */\n", nMaxID);
	
	
	
	/* ------- ǡ -------- */
	fprintf(fp, "\n");
	
	/* 祿ID */
	nMaxID = 0;
	for ( i = 0; i < MAX_ID; i++ ) {
		if ( pppTaskTable[i] != NULL ) {
			nTaskCount++;
			nMaxID = i + 1;
		}
	}
	
	if ( nMaxID > 0 ) {
		/* ѥåΰ */
		fprintf(fp, "\n\n/* åΰ */\n");
		for ( i = 0; i < nMaxID; i++ ) {
			if ( pppTaskTable[i] != NULL && pppTaskTable[i][5] == NULL ) {
				fprintf(fp, "VH Stack%d[(%s) / 2];\n",
								i + 1, pppTaskTable[i][4]);
			}
		}
		
		/*  */
		fprintf(fp, "\n/* Ͽ */\n");
		fprintf(fp, "T_TCB  tcbtbl[%d];\n", nMaxID);
		fprintf(fp, "const T_TCBS tcbstbl[%d] = {\n", nMaxID);
		for ( i = 0; i < nMaxID; i++ ) {
			if ( pppTaskTable[i] == NULL )
				fprintf(fp, "\t\t{}");
			else {
				if ( pppTaskTable[i][5] == NULL ) {
					/* ǥå */
					fprintf(fp, "\t\t"
								"{(VP)%s, %s, %s, &Stack%d[(%s) / 2]}",
								pppTaskTable[i][1],
								pppTaskTable[i][2],
								pppTaskTable[i][3],
								i + 1,
								pppTaskTable[i][4]
							);
				}
				else {
					/* åסȤ */
					fprintf(fp, "\t\t"
								"{(VP)%s, %s, %s, (VH*)(((%s) - 1) * 2 + 1)}",
								pppTaskTable[i][1],
								pppTaskTable[i][2],
								pppTaskTable[i][3],
								pppTaskTable[i][4]
							);
				}
			}
			if ( i == nMaxID - 1 )
				fprintf(fp, "\n");
			else
				fprintf(fp, ",\n");
		}
		fprintf(fp, "\t};\n");
	}
	fprintf(fp, "const H  tcbcnt = %d;\t/*  */\n", nMaxID);
	
	
	/* ------- ޥեǡ -------- */
	fprintf(fp, "\n");
	
	/* 祻ޥեID */
	nMaxID = 0;
	for ( i = 0; i < MAX_ID; i++ ) {
		if ( pppSemTable[i] != NULL ) {
			nSemCount++;
			nMaxID = i + 1;
		}
	}
	
	if ( nMaxID > 0 ) {
		/* ޥե */
		fprintf(fp, "\n\n/* ޥեϿ */\n");
		fprintf(fp, "T_SCB  scbtbl[%d];\n", nMaxID);
		fprintf(fp, "const T_SCBS scbstbl[%d] = {\n", nMaxID);
		for ( i = 0; i < nMaxID; i++ ) {
			if ( pppSemTable[i] == NULL )
				fprintf(fp, "\t\t{}");
			else
				fprintf(fp, "\t\t{%s, %s, %s}",
							pppSemTable[i][1],
							pppSemTable[i][2],
							pppSemTable[i][3]
						);
			if ( i == nMaxID - 1 )
				fprintf(fp, "\n");
			else
				fprintf(fp, ",\n");
		}
		fprintf(fp, "\t};\n");
	}
	fprintf(fp, "const H  scbcnt = %d;\t/* ޥե */\n", nMaxID);


	/* ------- ե饰ǡ -------- */
	fprintf(fp, "\n");
	
	/* 祤٥ȥե饰ID */
	nMaxID = 0;
	for ( i = 0; i < MAX_ID; i++ ) {
		if ( pppFlgTable[i] != NULL ) {
			nFlgCount++;
			nMaxID = i + 1;
		}
	}

	if ( nMaxID > 0 ) {
		/* ٥ȥե饰 */
		fprintf(fp, "\n\n/* ٥ȥե饰Ͽ */\n");
		fprintf(fp, "T_FCB  fcbtbl[%d];\n", nMaxID);
		fprintf(fp, "const T_FCBS fcbstbl[%d] = {\n", nMaxID);
		for ( i = 0; i < nMaxID; i++ ) {
			if ( pppFlgTable[i] == NULL )
				fprintf(fp, "\t\t{}");
			else
				fprintf(fp, "\t\t{%s, %s}",
							pppFlgTable[i][1],
							pppFlgTable[i][2]);
			if ( i == nMaxID - 1 )
				fprintf(fp, "\n");
			else
				fprintf(fp, ",\n");
		}
		fprintf(fp, "\t};\n");
	}
	fprintf(fp, "const H  fcbcnt = %d;\t/* ٥ȥե饰 */\n", nMaxID);

	/* ------- ᥤܥåǡ -------- */
	fprintf(fp, "\n");

	/* ᡼ܥåID */
	nMaxID = 0;
	for ( i = 0; i < MAX_ID; i++ ) {
		if ( pppMbxTable[i] != NULL ) {
			nMbxCount++;
			nMaxID = i + 1;
		}
	}
	
	if ( nMaxID > 0 ) {
		fprintf(fp, "\n\n/* ᡼ܥåѥХåե */\n");
		for ( i = 0; i < nMaxID; i++ )
			fprintf(fp, "VP msgbuf%d[%s];\n", i, pppMbxTable[i][2]);
		
		/* ᡼ܥå */
		fprintf(fp, "\n/* ᡼ܥåϿ */\n");
		fprintf(fp, "T_MCB  mcbtbl[%d];\n", nMaxID);
		fprintf(fp, "const T_MCBS mcbstbl[%d] = {\n", nMaxID);
		for ( i = 0; i < nMaxID; i++ ) {
			if ( pppMbxTable[i] == NULL )
				fprintf(fp, "\t\t{}");
			else
				fprintf(fp, "\t\t{%s, msgbuf%d, msgbuf%d + %s}",
							pppMbxTable[i][1], i, i, pppMbxTable[i][2]);
			if ( i == nMaxID - 1 )
				fprintf(fp, "\n");
			else
				fprintf(fp, ",\n");
		}
		fprintf(fp, "\t};\n");
	}
	fprintf(fp, "const H  mcbcnt = %d;\t/* ᡼ܥå */\n", nMaxID);
	
	
	/* ------- Ĺסǡ -------- */
	fprintf(fp, "\n");
	
	/* ĹסID */
	nMaxID = 0;
	for ( i = 0; i < MAX_ID; i++ ) {
		if ( pppMpfTable[i] != NULL ) {
			nMpfCount++;
			nMaxID = i + 1;
		}
	}
	
	if ( nMaxID > 0 ) {
		fprintf(fp, "\n\n/* Ĺסѥ */\n");
		for ( i = 0; i < nMaxID; i++ )
			fprintf(fp, "UB mpfblk%d[(%s) * (%s)];\n", i,
						pppMpfTable[i][2], pppMpfTable[i][3]);
		
		/* Ĺס */
		fprintf(fp, "\n/* ĹסϿ */\n");
		fprintf(fp, "T_FMCB  fmcbtbl[%d];\n", nMaxID);
		fprintf(fp, "const T_FMCBS fmcbstbl[%d] = {\n", nMaxID);
		for ( i = 0; i < nMaxID; i++ ) {
			if ( pppMpfTable[i] == NULL )
				fprintf(fp, "\t\t{}");
			else
				fprintf(fp, "\t\t{%s, mpfblk%d, %s, %s}",
							pppMpfTable[i][1], i,
							pppMpfTable[i][2], pppMpfTable[i][3]);
			if ( i == nMaxID - 1 )
				fprintf(fp, "\n");
			else
				fprintf(fp, ",\n");
		}
		fprintf(fp, "\t};\n");
	}
	fprintf(fp, "const H  fmcbcnt = %d;\t/* Ĺס */\n", nMaxID);	
	
	/* 롼 */
	fprintf(fp, "\n\n/*  */\n"
				"void __initialize(void)\n{\n"
			);
	if ( bUseTimer )
		fprintf(fp, "\t__ini_tim();\t/* ޽ */\n");
	if ( nTaskCount > 0 )
		fprintf(fp, "\t__ini_tsk();\t/*  */\n");
	if ( nSemCount > 0 )
		fprintf(fp, "\t__ini_sem();\t/* ޥե */\n");
	if ( nFlgCount > 0 )
		fprintf(fp, "\t__ini_flg();\t/* ٥ȥե饰 */\n");
	if ( nMbxCount > 0 )
		fprintf(fp, "\t__ini_mbx();\t/* ᥤܥå */\n");
	if ( nMpfCount > 0 )
		fprintf(fp, "\t__ini_mpf();\t/* Ĺס */\n");
	fprintf(fp, "}\n");

	fclose(fp);
}


/* ֥ */
void Write_Asm_Cfg(void)
{
	FILE *fp;
	int  i;
	
	/* ե륪ץ */
	if ( (fp = fopen(szAsmFile, "w")) == NULL ) {
		fprintf(stderr, "%s κ˼Ԥޤ\n", szAsmFile);
		exit(1);
	}
	
	/* IMPORT */
	fprintf(fp, "; ե졼 ֥\n\n");
#ifndef __USE_CROSS_GCC__
	fprintf(fp, 		"\t\t.CPU     %s\n\n"
				"\t\t.IMPORT\t_hos_start\n"
				"\t\t.IMPORT\t_int_default\n"
				"\t\t.IMPORT\t_int_trap\n",
				Mode == ADVANCED ? "300HA": "300HN");
	for ( i = 1; i < maxInt; i++ ) {
		if ( ppIntTable[i] != NULL )
			fprintf(fp, "\t\t.IMPORT\t_%s\n", ppIntTable[i]);
	}
	
	/* ٥ơ֥ */
	fprintf(fp, "\n\t\t.SECTION  VECT,DATA,ALIGN=2\n\n"
				"; -----------------------------------------------\n"
				";          ߥ٥ơ֥\n"
				"; -----------------------------------------------\n"
				"\t\t.DATA.%c\t_hos_start\n",
				Mode == ADVANCED ? 'L': 'W');
	for ( i = 1; i < maxInt; i++ ) {
		if ( ppIntTable[i] != NULL ) {
			fprintf(fp, "\t\t.DATA.%c\tINT%02X\n",
				Mode == ADVANCED ? 'L': 'W', i);
		}
		else {
			fprintf(fp, "\t\t.DATA.%c\t_int_default\n",
				Mode == ADVANCED ? 'L': 'W');
		}
	}
#endif	 /* __USE_CROSS_GCC_ */
	/* ߥϥɥ */
	fprintf(fp,
#ifdef __USE_CROSS_GCC__
				"\t\t.h8300h\n"
#else
				"\n\n\t\t.SECTION  P,CODE,ALIGN=2\n\n"
#endif
				"; -----------------------------------------------\n"
				";          ߥϥɥ\n"
				"; -----------------------------------------------\n\n"
			);
	for ( i = 1; i < maxInt; i++ ) {
		if ( ppIntTable[i] != NULL ) {
			fprintf(fp,
#ifdef __USE_CROSS_GCC__
				"\t\t.global\tint%02x\nint%02x:\t\tpush.l\ter1\n"
				"\t\tmov.%c\t#_%s,%s1\n"
				"\t\tjmp\t@_int_trap\n\n",
				i , i, Mode == ADVANCED ? 'l': 'w' ,
				ppIntTable[i], Mode == ADVANCED ? "er": "r");
#else
				"INT%02X:\t\tPUSH.L\tER1\n"
				"\t\tMOV.%c\t#_%s,%s1\n"
				"\t\tjmp\t@_int_trap\n\n",
				i , Mode == ADVANCED ? 'L': 'W' ,
				ppIntTable[i], Mode == ADVANCED ? "ER": "R");
#endif
		}
	}
	
	
	/* ơ֥뤬̵ Warning к˥ɥ쥹Τ߳꿶 */
	if ( nTaskCount == 0 || nSplCount == 0 || nSemCount == 0
			|| nFlgCount == 0 || nMbxCount == 0 || nMpfCount == 0 ) {
		fprintf(fp, "\n\n");
#ifndef __USE_CROSS_GCC__
		if ( nSplCount == 0 )
			fprintf(fp,"\t\t.EXPORT\t_spcbtbl\n"
						"\t\t.EXPORT\t_spcbstbl\n");
		if ( nTaskCount == 0 )
			fprintf(fp,"\t\t.EXPORT\t_tcbtbl\n"
						"\t\t.EXPORT\t_tcbstbl\n");
		if ( nSemCount == 0 )
			fprintf(fp,"\t\t.EXPORT\t_scbtbl\n"
						"\t\t.EXPORT\t_scbstbl\n");
		if ( nFlgCount == 0 )
			fprintf(fp,"\t\t.EXPORT\t_fcbtbl\n"
						"\t\t.EXPORT\t_fcbstbl\n");
		if ( nMbxCount == 0 )
			fprintf(fp,"\t\t.EXPORT\t_mcbtbl\n"
						"\t\t.EXPORT\t_mcbstbl\n");
		if ( nMpfCount == 0 )
			fprintf(fp,"\t\t.EXPORT\t_fmcbtbl\n"
						"\t\t.EXPORT\t_fmcbstbl\n");
		
		fprintf(fp,"\n\n\t\t.SECTION  C,DATA,ALIGN=2\n\n");
#else
		if ( nSplCount == 0 )
			fprintf(fp,"\t\t.global\t_spcbtbl\n"
						"\t\t.global\t_spcbstbl\n");
		if ( nTaskCount == 0 )
			fprintf(fp,"\t\t.global\t_tcbtbl\n"
						"\t\t.global\t_tcbstbl\n");
		if ( nSemCount == 0 )
			fprintf(fp,"\t\t.global\t_scbtbl\n"
						"\t\t.global\t_scbstbl\n");
		if ( nFlgCount == 0 )
			fprintf(fp,"\t\t.global\t_fcbtbl\n"
						"\t\t.global\t_fcbstbl\n");
		if ( nMbxCount == 0 )
			fprintf(fp,"\t\t.global\t_mcbtbl\n"
						"\t\t.global\t_mcbstbl\n");
		if ( nMpfCount == 0 )
			fprintf(fp,"\t\t.global\t_fmcbtbl\n"
						"\t\t.global\t_fmcbstbl\n");
		
		fprintf(fp,"\n\n\t\t.data\n\n");
#endif		
		if ( nSplCount == 0 )
			fprintf(fp, "_spcbtbl:\n"
						"_spcbstbl:\n");
		if ( nTaskCount == 0 )
			fprintf(fp,"_tcbtbl:\n"
						"_tcbstbl:\n");
		if ( nSemCount == 0 )
			fprintf(fp,"_scbtbl:\n"
						"_scbstbl:\n");
		if ( nFlgCount == 0 )
			fprintf(fp,"_fcbtbl:\n"
						"_fcbstbl:\n");
		if ( nMbxCount == 0 )
			fprintf(fp,"_mcbtbl:\n"
						"_mcbstbl:\n");
		if ( nMpfCount == 0 )
			fprintf(fp,"_fmcbtbl:\n"
						"_fmcbstbl:\n");
	}
	
#ifndef __USE_CROSS_GCC__
	fprintf(fp, "\n\n\t\t.END\n");
#else
	fprintf(fp, "\n\n\t\t.end\n");
#endif	
	fclose(fp);
}



/* ------------------------------------ */
/*           ޥɲ               */
/* ------------------------------------ */

/* ޥɲ (CRE_TSK, CRE_SEM, CRE_FLG, CRE_MBX) */
/* ƥѥ᡼ pppTable[id][pram] ʸΤޤ޳Ǽ */
int AnalizeCommand(char ***pppTable, int nPara, char *pBuf)
{
	char **ppPar;
	int  nID;
	
	/*  */
	ppPar = (char **)calloc(MAX_PARAMETER, sizeof(char *));
	if ( ppPar == NULL ) {
		fprintf(stderr, "꤬­ޤ\n");
		exit(1);
	}
	
	/* ѥ᡼ʬ */
	if ( !ClipParameter(ppPar, nPara, pBuf) ) {
		FreeParameter(ppPar);
		return -1;
	}
	
	/* IDå */
	if ( StrToInt(&nID, ppPar[0]) ) {
		nID--;
		if ( nID < 0 || nID >= MAX_ID ) {
			/* IDֹ椬 */
			fprintf(stdout, "line(%d): ʣɣֹǤ\n", nLine);
			FreeParameter(ppPar);
			bErr = TRUE;
			return -1;
		}
		if ( pppTable[nID] != NULL ) {
			/* IDֹ椬ʣ */
			fprintf(stdout, "line(%d): ɣֹ椬ʣƤޤ\n", nLine);
			FreeParameter(ppPar);
			bErr = TRUE;
			return -1;
		}
		ppPar[0][0] = '\0';
	}
	else {
		for ( nID = 0; nID < MAX_ID; nID++ ) {
			if ( pppTable[nID] == NULL )
				break;
		}
		if ( nID >= MAX_ID ) {
			/* ֥Ȥ¿ */
			fprintf(stdout, "line(%d): ֥Ȥ¿ޤ\n", nLine);
			FreeParameter(ppPar);
			bErr = TRUE;
			return -1;
		}
	}
	
	/* Ͽ */
	pppTable[nID] = ppPar;
	
	return nID;
}


/* DEF_INT β */
void AnalizeDefInt(char *pBuf)
{
	char *ppPara[2] = {NULL, NULL};
	int  nIntNum;

	/* ޥڤФ */
	if ( !ClipParameter(ppPara, 2, pBuf) ) {
		if ( ppPara[0] != NULL )  free(ppPara[0]);
		if ( ppPara[1] != NULL )  free(ppPara[1]);
		return;
	}

	/* ֹå */
	if ( !StrToInt(&nIntNum, ppPara[0])
			|| nIntNum < 1 || nIntNum >= maxInt ) {
		/* ֹ椬 */
		fprintf(stdout, "line(%d): illegal intrrupt-number.\n", nLine);
		if ( ppPara[0] != NULL )  free(ppPara[0]);
		if ( ppPara[1] != NULL )  free(ppPara[1]);
		bErr = TRUE;
		return;
	}
	if ( ppIntTable[nIntNum] != NULL ) {
		/* ֹ椬ʣ */
		fprintf(stdout, "line(%d): ֹ椬ʣƤޤ\n", nLine);
		if ( ppPara[0] != NULL )  free(ppPara[0]);
		if ( ppPara[1] != NULL )  free(ppPara[1]);
		bErr = TRUE;
		return;
	}

	/* ߥå */
	ppIntTable[nIntNum] = ppPara[1];
	free(ppIntTable[0]);
}


/* INCLUDE_C β */
void AnalizeIncludeC(char *pBuf)
{
	char *ppPara[1] = {NULL};
	
	if ( !ClipParameter(ppPara, 1, pBuf) ) {
		if ( ppPara[0] != NULL )  free(ppPara[0]);
		return;
	}
	
	if ( nIncCCount >= MAX_INCLUDE_C ) {
		/* 󥯥롼ɥե뤬¿ */
		fprintf(stdout, "line(%d): 󥯥롼ɥե뤬¿ޤ\n",
					nLine);
		free(ppPara[0]);
		bErr = TRUE;
		return;
	}
	
	ppIncludeCTable[nIncCCount++] = ppPara[0];
}


/* MAX_TSKPRI β */
void AnalizeMaxTskPri(char *pBuf)
{
	char *ppPara[1] = {NULL};
	
	if ( !ClipParameter(ppPara, 1, pBuf) ) {
		if ( ppPara[0] != NULL )  free(ppPara[0]);
		return;
	}
	
	pMaxTskPri = ppPara[0];
}


/* SYSTEM_STACK β */
void AnalizeSysStack(char *pBuf)
{
	char *ppPara[1] = {NULL};
	long  nAdr;

	if ( !ClipParameter(ppPara, 1, pBuf) ) {
		if ( ppPara[0] != NULL )  free(ppPara[0]);
		return;
	}
	if ( StrToLong(&nAdr, ppPara[0]) ) {
		SystemStack = (unsigned long)nAdr;
	}
	else {
		/* ѥ᡼ */
		fprintf(stdout, "line(%d): ѥ᡼Ǥ\n", nLine);
	}
	
	free(ppPara[0]);
}


/* ------------------------------------ */
/*           곫                 */
/* ------------------------------------ */

/* ѥ᡼¸ʬγ */
void FreeParameter(char **ppPara)
{
	int i;
	
	for ( i = 0; i < MAX_PARAMETER; i++ ) {
		if ( ppPara[i] != NULL ) {
			free(ppPara[i]);
			ppPara[i] = NULL;
		}
	}
	free(ppPara);
}

/* ѥ᡼ơ֥γ */
void FreeTable(char ***pppTable)
{
	int i;

	for ( i = 0; i < MAX_ID; i++ ) {
		if ( pppTable[i] != NULL ) {
			FreeParameter(pppTable[i]);
			pppTable[i] = NULL;
		}
	}
}



/* ------------------------------------ */
/*            ʸ                */
/* ------------------------------------ */

/* ζν */
void CutSpace(char *pBuf)
{
	char *p;
	
	/* ζ򥫥å */
	p = &pBuf[strlen(pBuf) - 1];
	while ( p >= pBuf && (*p == ' ' || *p == '\t' || *p == '\n') )
		p--;
	*(p + 1) = '\0';
	
	/* Ⱦζ򥫥å */
	p = pBuf;
	while ( *p == ' ' || *p == '\t' )
		p++;
	memmove(pBuf, p, strlen(p) + 1);
}


/* ̤ǰϤޤ줿ΰ褫ѥ᡼ڤФ */
int ClipParameter(char *ppPar[], int nNum, char *pBuf)
{
	char *pBase;
	int  nParNest = 1;
	int  i;

	/* Ϥޤ '(' å */
	CutSpace(pBuf);
	if ( *pBuf++ != '(' ) {
		/* ʸˡ顼 */
		fprintf(stdout, "line(%d): ʸˡ顼\n", nLine);
		bErr = TRUE;
		return FALSE;
	}
	
	/* ʬ */
	for ( i = 0; i < nNum; i++ ) {
		pBase = pBuf;
		while ( *pBuf ) {
			if ( nParNest == 1 && *pBuf == ',' )
				break;
			if ( *pBuf == '(' )
				nParNest++;
			if ( *pBuf == ')' )
				nParNest--;
			if ( nParNest == 0 )
				break;
			pBuf++;
		}
		if ( (i < nNum - 1 && *pBuf == ',')
				|| (i == nNum - 1 && *pBuf == ')') ) {
			*pBuf++ = '\0';
			CutSpace(pBase);
			ppPar[i] = (char *)calloc(strlen(pBase) + 1, sizeof(char));
			if ( ppPar[i] == NULL ) {
				/* ­ */
				fprintf(stderr, "꤬­ޤ\n");
				exit(1);
			}
			strcpy(ppPar[i], pBase);
		}
		else {
			/* ѥ᡼۾ */
			fprintf(stdout, "line(%d): ѥ᡼۾Ǥ\n", nLine);
			bErr = TRUE;
			return FALSE;
		}
	}
	
	return TRUE;
}


/* ʸͤѴ(16б) */
int StrToInt(int *pNum, char *pBuf)
{
	/* 򥫥å */
	CutSpace(pBuf);
	
	/* ͤɤå */
	if ( pBuf[0] < '0' || pBuf[0] > '9' )
		return FALSE;
	
	/* ʤɤå */
	if ( pBuf[0] == '0' && (pBuf[1] == 'x' || pBuf[1] == 'X') )
		return (sscanf(&pBuf[2], "%x", pNum) == 1);
	
	return (sscanf(&pBuf[0], "%d", pNum) == 1);
}


/* ʸͤѴ(16б) */
int StrToLong(long *pNum, char *pBuf)
{
	/* 򥫥å */
	CutSpace(pBuf);
	
	/* ͤɤå */
	if ( pBuf[0] < '0' || pBuf[0] > '9' )
		return FALSE;
	
	/* ʤɤå */
	if ( pBuf[0] == '0' && (pBuf[1] == 'x' || pBuf[1] == 'X') )
		return (sscanf(&pBuf[2], "%lx", pNum) == 1);
	
	return (sscanf(&pBuf[0], "%ld", pNum) == 1);
}
