/* ------------------------------------------------------------------------- */
/*  HOS Ĺס إåե                                */
/*                                                                           */
/*                                   Copyright (C) 1998-2002 by Project HOS  */
/* ------------------------------------------------------------------------- */

#ifndef __HOS__FIXMEM_H_
#define __HOS__FIXMEM_H_


/* ------------------------------------ */
/*                                */
/* ------------------------------------ */

/* Fixed-size MemoryPool Controle Block ưŪʬ RAM֤*/
typedef struct t_fmcb {
	T_QUE que;		/* ޥեԤ */
	VP    freeblk;	/* ֥åΥɥ쥹 */
} T_FMCB;

/* Fixed-size MemoryPool Controle Block Ūʬ ROM֤ */
typedef struct t_fmcbs {
	VP    exinf;	/* ĥ */
	VP    mpfhead;	/* סƬɥ쥹 */
	UH    mpfcnt;	/* ֥å */
	UH    mpfsz;	/* ֥å */
} T_FMCBS;

/* Ĺסֻ */
typedef struct t_rmpf {
	VP      exinf;	/* ĥ */
	BOOL_ID wtsk;	/* Ԥ̵ͭ */
	INT     frbcnt;	/* ΰΥ֥å */
} T_RMPF;



/* ------------------------------------ */
/*          Хѿ              */
/* ------------------------------------ */

extern       T_FMCB  fmcbtbl[];		/* FMCBRAM */
extern const T_FMCBS fmcbstbl[];	/* FMCBROM */
extern const H       fmcbcnt;		/* FMCBο */


/* ------------------------------------ */
/*             ؿ                 */
/* ------------------------------------ */

void __ini_mpf(void);		/* Ĺסν */
ER   get_blf(VP *p_blf, ID mpfid);	/* Ĺ֥å */
ER   pget_blf(VP *p_blf, ID mpfid);	/* Ĺ֥å(ݡ) */
ER   rel_blf(ID mpfid, VP blf);		/* Ĺ֥åֵ */
ER   ref_mpf(T_RMPF *pk_rsem, ID mpfid);	/* Ĺסֻ */

/* Ω */
#define ipget_blf pget_blf
#define irel_blf  rel_blf
#define iref_mpf  ref_mpf


#endif /* __HOS__FIXMEM_H_ */
