/* ------------------------------------------------------------------------- */
/*  HOS ޥե إåե                                          */
/*                                                                           */
/*                                   Copyright (C) 1998-2002 by Project HOS  */
/* ------------------------------------------------------------------------- */

#ifndef __HOS__SEMAPHOR_H_
#define __HOS__SEMAPHOR_H_


/* ------------------------------------ */
/*                                */
/* ------------------------------------ */

/* SCBưŪʬ RAM֤*/
typedef struct t_scb {
	T_QUE que;		/* ޥեԤ */
	UH    semcnt;	/* ޥեΥ */
} T_SCB;

/* TCBŪʬ ROM֤ */
typedef struct t_scbs {
	VP    exinf;	/* ĥ */
	UH    isemcnt;	/* ޥեν */
	UH    maxsem;	/* ޥեκ */
} T_SCBS;

/* ޥեֻ */
typedef struct t_rsem {
	VP      exinf;	/* ĥ */
	BOOL_ID wtsk;	/* Ԥ̵ͭ */
	INT     semcnt;	/* ߤΥޥե */
} T_RSEM;



/* ------------------------------------ */
/*          Хѿ              */
/* ------------------------------------ */

extern       T_SCB  scbtbl[];		/* SCBRAM */
extern const T_SCBS scbstbl[];		/* SCBROM */
extern const H      scbcnt;			/* SCBο */


/* ------------------------------------ */
/*             ؿ                 */
/* ------------------------------------ */

void __ini_sem(void);		/* ޥեν */
ER   sig_sem(ID semid);		/* ޥեֵ */
ER   wai_sem(ID semid);		/* ޥեԤ */
ER   preq_sem(ID semid);	/* ޥեԤ(ݡ) */
ER   ref_sem(T_RSEM *pk_rsem, ID semid);	/* ޥեֻ */

/* Ω */
#define isig_sem  sig_sem
#define ipreq_sem preq_sem
#define iref_sem  ref_sem


#endif /* __ROS__SEMAPHOR_H_ */
