/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ͥ¸إå 顼ϥɥ                           */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#ifndef __HOS_V4__knl_alm_h__
#define __HOS_V4__knl_alm_h__



#include "knl_hos.h"
#include "knl_tim.h"



/* ------------------------------------------ */
/*                                    */
/* ------------------------------------------ */

/* IDϰ */
#define KERNEL_TMIN_ALMID	TMIN_ALMID			/* 顼ϥɥIDκǾ */
#define KERNEL_TMAX_ALMID	(KERNEL_TMIN_ALMID + kernel_almcb_cnt - 1)
												/* 顼ϥɥIDκ */



/* ------------------------------------------ */
/*                                      */
/* ------------------------------------------ */

/* 顼ϥɥ饳ȥ֥å(ROM) */
typedef struct t_kernel_almcb_rom
{
	ATR    almatr;		/* 顼ϥɥ° */
	VP_INT exinf;		/* 顼ϥɥγĥ */
	FP     almhdr;		/* 顼ϥɥεư */
} T_KERNEL_ALMCB_ROM;

/* 顼ϥɥ饳ȥ֥å(RAM) */
typedef struct t_kernel_almcb_ram
{
	T_KERNEL_TIM timobj;		/* ޥ֥ȤѾ */
	RELTIM       lefttim;		/* 顼ϥɥΤ򼡤˵ưޤǤλ */
	const T_KERNEL_ALMCB_ROM *almcb_rom;	/* 顼ϥɥ饳ȥ֥åROMؤΥݥ */
} T_KERNEL_ALMCB_RAM;



/* ---------------------------------- */
/*        Хѿ          */
/* ---------------------------------- */

/* 顼ϥɥ */
extern       T_KERNEL_ALMCB_RAM *kernel_almcb_ram_tbl[];	/* 顼ϥɥ饳ȥ֥åơ֥ */
extern const INT kernel_almcb_cnt;							/* 顼ϥɥ饳ȥ֥åĿ */

#define KERNEL_ALMID_TO_ALMCB_RAM(almid)	(kernel_almcb_ram_tbl[(almid) - KERNEL_TMIN_ALMID])
															/* 顼ϥɥIDALMCB RAMɥ쥹 */



/* ------------------------------------------ */
/*                ؿ                    */
/* ------------------------------------------ */

#ifdef __cplusplus
extern "C" {
#endif

/* 顼ϥɥ */
void    kernel_ini_alm(void);								/* 顼ϥɥν */
void    kernel_alm_hdr(T_KERNEL_TIM *timobj, RELTIM tic);	/* 顼ϥɥΥޥϥɥ */
ER      sta_alm(ID almid, RELTIM almtim);					/* 顼ϥɥư */
ER      stp_alm(ID almid);									/* 顼ϥɥư */

#ifdef __cplusplus
}
#endif



#endif	/* __HOS_V4__knl_alm_h__ */


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
