/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ͥ¸إå åХåե                         */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#ifndef __HOS_V4__knl_mbf_h__
#define __HOS_V4__knl_mbf_h__


#include "knl_hos.h"



/* ------------------------------------------ */
/*                                    */
/* ------------------------------------------ */

/* IDϰ */
#define KERNEL_TMIN_MBFID	TMIN_MBFID			/* åХåեIDκǾ */
#define KERNEL_TMAX_MBFID	(KERNEL_TMIN_MBFID + kernel_mbfcb_cnt - 1)
												/* åХåեIDκ */



/* ------------------------------------------ */
/*                                      */
/* ------------------------------------------ */

/* åХåե */
typedef struct t_cmbf
{
	ATR  mbfatr;		/* åХåե° */
	UINT maxmsz;		/* åκ祵(Хȿ) */
	SIZE mbfsz;			/* åХåեΰΥ(Хȿ) */
    VP   mbf;			/* åХåեΰƬ */
} T_CMBF;

/* åХåե־ */
typedef struct t_rmbf
{
	ID   stskid;		/* åХåեԤƬΥIDֹ */
	ID   rtskid;		/* åХåեμԤƬΥIDֹ */
	UINT smsgcnt;		/* åХåեäƤåο */
	SIZE fmbfsz;		/* åХåեΰζΰΥ(Хȿ¤δΰ) */
} T_RMBF;


/* åХåեȥ֥å(ROM) */
typedef struct t_kernel_mbfcb_rom
{
	ATR  mbfatr;		/* åХåե° */
	UINT maxmsz;		/* åκ祵(Хȿ) */
	SIZE mbfsz;			/* åХåեΰΥ(Хȿ) */
    VP   mbf;			/* åХåեΰƬ */
} T_KERNEL_MBFCB_ROM;

/* åХåեȥ֥å(RAM) */
typedef struct t_kernel_mbfcb_ram
{
	T_MKNL_QUE sndque;	/* åХåեԤ塼 */
	T_MKNL_QUE rcvque;	/* åХåեԤ塼 */
	SIZE       head;	/* Ƭåΰ */
	SIZE       fmbfsz;	/* åХåեΰζ */
	UINT       smsgcnt;	/* åХåեäƤåο */
	const T_KERNEL_MBFCB_ROM *mbfcb_rom;	/* åХåեȥ֥åROMؤΥݥ */
} T_KERNEL_MBFCB_RAM;

/* åǡ */
typedef struct t_kernel_mbfdat
{
	UINT msgsz;			/* å */
	VP   msg;			/* åƬ */
} T_KERNEL_MBFDAT;



/* ---------------------------------- */
/*        Хѿ          */
/* ---------------------------------- */

/* åХåե */
extern       T_KERNEL_MBFCB_RAM *kernel_mbfcb_ram_tbl[];	/* åХåեȥ֥åơ֥(RAM) */
extern const INT kernel_mbfcb_cnt;							/* åХåեȥ֥åĿ */

/* åХåեȥ֥åѴޥ */
#define KERNEL_MBFID_TO_MBFCB_RAM(mbfid)	(kernel_mbfcb_ram_tbl[(mbfid) - KERNEL_TMIN_MBFID])
															/* åХåեIDMBFCB RAMɥ쥹 */



/* ------------------------------------------ */
/*                 ޥ                 */
/* ------------------------------------------ */

/* ΰΥ */
#define TSZ_MBF(msgcnt, msgsz)		((SIZE)((UINT)(msgcnt) * ((UINT)(msgsz) + 2) + 1))



/* ------------------------------------------ */
/*                ؿ                    */
/* ------------------------------------------ */

#ifdef __cplusplus
extern "C" {
#endif

/* åХåե */
void    kernel_ini_mbf(void);								/* åХåեν */
ER      cre_mbf(ID mbfid, const T_CMBF *pk_cmbf);			/* åХåե */
ER_ID   acre_mbf(const T_CMBF *pk_cmbf);					/* åХåե(IDֹ漫ưդ) */
ER      kernel_cre_mbf(ID mbfid, const T_CMBF *pk_cmbf);	/* åХåե(ͥؿ) */
ER      del_mbf(ID mbfid);									/* åХåեκ */
ER      snd_mbf(ID mbfid, VP msg, UINT msgsz);				/* åХåեؤ */
ER      psnd_mbf(ID mbfid, VP msg, UINT msgsz);				/* åХåեؤ(ݡ) */
ER      tsnd_mbf(ID mbfid, VP msg, UINT msgsz, TMO tmout);	/* åХåեؤ(ॢȤ) */
ER      kernel_snd_mbf(const T_KERNEL_MBFCB_ROM *mbfcb_rom,
			T_KERNEL_MBFCB_RAM *mbfcb_ram, VP msg, UINT msgsz);	/* åХåեؤ(ͥؿ) */
ER_UINT rcv_mbf(ID mbfid, VP msg);							/* åХåեμ */
ER_UINT prcv_mbf(ID mbfid, VP msg);							/* åХåեμ(ݡ) */
ER_UINT trcv_mbf(ID mbfid, VP msg,  TMO tmout);				/* åХåեμ(ॢȤ) */
ER_UINT kernel_rcv_mbf(const T_KERNEL_MBFCB_ROM *mbfcb_rom,
			T_KERNEL_MBFCB_RAM *mbfcb_ram, VP msg);			/* åХåեμ(ͥؿ) */
ER      ref_mbf(ID mbfid, T_RMBF *pk_rmbf);					/* åХåեξֻ */

#ifdef __cplusplus
}
#endif



#endif	/* __HOS_V4__knl_mbf_h__ */


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
