/* ------------------------------------------------------------------------ */
/*  ȥ꡼ǡ FIFOХåե                                         */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "kernel.h"
#include "stmfifo.h"



/* 󥹥ȥ饯 */
void stmfifo_cre_fifo(
		T_STMFIFO *this,	/* FIFOХåե饹Υݥ */
		UB        *buf,		/* ƤХåեΥɥ쥹 */
		INT       bufsz)	/* ƤХåեΥ */
{
	this->buf   = buf;
	this->bufsz = bufsz;
	this->head  = 0;
	this->tail  = 0;
}


/* ǥȥ饯 */
void stmfifo_del_fifo(
		T_STMFIFO *this)	/* FIFOХåե饹Υݥ */
{
	/* ä˽̵ */
}



/* 饯񤭹 */
ER stmfifo_snd_chr(
		T_STMFIFO *this,	/* FIFOХåե饹Υݥ */
		UB        chr)		/* 񤭹७饯 */
{
	INT next_tail;
	
	/* ַ׻ */
	if ( this->tail + 1 < this->bufsz )
	{
		next_tail = this->tail + 1;
	}
	else
	{
		next_tail = 0;		/* 󥰥Хåեʤޤ֤ */
	}
	
	/* ХåեեΥå */
	if ( next_tail == this->head )
	{
		return E_TMOUT;
	}
	
	/* ǡɲ */
	this->buf[this->tail] = chr;
	this->tail = next_tail;
	
	return E_OK;
}


/* 饯ɤ߹ */
ER stmfifo_rcv_chr(
		T_STMFIFO *this,	/* FIFOХåե饹Υݥ */
		UB        *p_chr)	/* 饯ɤ߹ݥ */
{
	/* ХåեץƥΥå */
	if ( this->head == this->tail )
	{
		return E_TMOUT;
	}
	
	/* ǡɤ߽Ф */
	*p_chr = this->buf[this->head];
	
	/* Ƭ֤ */
	if ( this->head + 1 < this->bufsz )
	{
		this->head = this->head + 1;
	}
	else
	{
		this->head = 0;
	}
	
	return E_OK;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
