/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ץåݲݡͥ (ARM gcc)                            */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "pacarm.inc"


				.text
				.align	4

				.global	_HOS_UndefinedHandler
				.global	_HOS_SwiHandler
				.global	_HOS_PrefetchHandler
				.global	_HOS_AbortHandler


/************************************************
  Undefined ϥɥ
*************************************************/
_HOS_UndefinedHandler:
				b		_HOS_UndefinedHandler



/************************************************
  SWI ϥɥ
*************************************************/
				.extern	hospac_arm_imsk
_HOS_SwiHandler:
			/* SWIֹɤ߽Ф */
				ldr		r13, [lr, #-4]
				bic		r13, r13, #0xff000000

				teq 	r13, #0x10		/* ͥ륳 #10 Ȥ */
				bne 	swi_ret

			/* ѥ᡼Ƚ */
				cmp		a1, #3
				and		a1, a1, #0x03
				addls	pc, pc, a1, lsl #2
				b		swi_ret
				b		swi_dis_int
				b		swi_ena_int

			/* IRQ/FIQ (a1 = 2) */
				ldr		r13, =pac_arm_swi_ret
				ldmia	r13, {a1, r13, lr}
				msr		spsr_csxf, r13
				subs	pc, lr, #0

			/* ߶ػ(a1 = 0) */
swi_dis_int:
				mov		r13, #(Mode_USR | I_Bit | F_Bit)
				msr 	spsr_cf, r13
				subs	pc, lr, #0

			/* ߵ(a1 = 1) */
swi_ena_int:
				ldr		r13, =hospac_arm_imsk
				ldr		r13, [r13]
				msr 	spsr_cf, r13

swi_ret:
			/* 褳㳰 */
				subs	pc, lr, #0


/************************************************
  Prefetch ϥɥ
*************************************************/
_HOS_PrefetchHandler:
				b		_HOS_PrefetchHandler



/************************************************
  Abort ϥɥ
*************************************************/
_HOS_AbortHandler:
				b		_HOS_AbortHandler



/************************************************
  Хѿ
*************************************************/
				.data
				.comm	pac_arm_swi_ret, 12		/* a1, cpsr, lr Ϥ */


				.end


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
