/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ITRONͥ ϥɥ                                            */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_cyc.h"


/*  */
ER cre_cyc(
		ID           cycid,		/* оݤμϥɥIDֹ */
		const T_CCYC *pk_ccyc)	/* ϥɥ줿ѥåȤؤΥݥ */
{
	ER ercd;

	/* ID ϰϥå */
#ifdef HOS_ERCHK_E_ID
	if ( cycid < KERNEL_TMIN_CYCID || cycid > KERNEL_TMAX_CYCID )
	{
		return E_ID;	/* IDֹ */
	}
#endif

	mknl_loc_sys();	/* ƥΥå */

	/* Ͽǽå */
#ifdef HOS_ERCHK_E_OBJ
	if ( KERNEL_CYCID_TO_CYCCB_RAM(cycid) != NULL )
	{
		mknl_unl_sys();	/* ƥΥå */
		return E_OBJ;	/* ϿѤ */
	}
#endif
	
	/*  */
	ercd = kernel_cre_cyc(cycid, pk_ccyc);

	mknl_unl_sys();	/* ƥΥå */

	return ercd;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
