/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ITRONͥ ǡ塼                                            */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_dtq.h"



/* ǡ塼μ */
ER rcv_dtq(
		ID     dtqid,	/* оݤΥǡ塼IDֹ */
		VP_INT *p_data)	/* ǡ塼ǡ */
{
	const T_KERNEL_DTQCB_ROM *dtqcb_rom;
	T_KERNEL_DTQCB_RAM       *dtqcb_ram;
	T_MKNL_TCB *mtcb;
	ER  ercd;

	/* ID Υå */
#ifdef HOS_ERCHK_E_ID
	if ( dtqid < KERNEL_TMIN_DTQID || dtqid > KERNEL_TMAX_DTQID )
	{
		return E_ID;	/* ID */
	}
#endif
	
	/* ѥ᡼å */
#ifdef HOS_ERCHK_E_PAR 
	if ( p_data == NULL )
	{
		return E_PAR;	/* ѥ᡼ */
	}
#endif
	
	mknl_loc_sys();	/* ƥΥå */

	/* ƥȥå */
#ifdef HOS_ERCHK_E_CTX
	if ( mknl_sns_wai() )
	{
		mknl_unl_sys();	/* ƥΥå */
		return E_CTX;	/* ƥ */
	}
#endif

	dtqcb_ram = KERNEL_DTQID_TO_DTQCB_RAM(dtqid);

	/* ֥Ȥ¸ߥå */
#ifdef HOS_ERCHK_E_NOEXS
	if ( dtqcb_ram == NULL )
	{
		mknl_unl_sys();	/* ƥΥå */
		return E_NOEXS;	/* ֥̤ */
	}
#endif

	dtqcb_rom = dtqcb_ram->dtqcb_rom;

	if ( dtqcb_ram->datacnt == 0 )
	{
		/* ǡ塼ʤ */
		if ( mknl_ref_qhd(&dtqcb_ram->sndque) != NULL )
		{
			/* Ԥг */
			mtcb = mknl_ref_qhd(&dtqcb_ram->sndque);	/* ԤƬ饿Ф */
			mknl_rmv_que(mtcb);							/* Ԥ󤫤 */
			mknl_rmv_tmout(mtcb);						/* ॢȲ */
			*p_data = mtcb->data;						/* ǡФ */
			mknl_wup_tsk(mtcb, E_OK);					/* Ԥ */
			
			mknl_exe_dsp();		/* ǥѥåμ¹ */
			mknl_exe_tex();		/* 㳰μ¹ */
			
			ercd = E_OK;
		}
		else
		{
			/* Ԥ̵мԤ */
			mtcb = mknl_get_run_tsk();		/* ߤΥ */
			mknl_wai_tsk(mtcb, TTW_RDTQ);	/* Ԥ֤ */
			mknl_add_que(&dtqcb_ram->rcvque, mtcb, dtqcb_rom->dtqatr);	/* Ԥɲ */
			
			ercd = (ER)mknl_exe_dsp();	/* ǥѥåμ¹ */
			
			/* ʤǡǼ */		
			if ( ercd == E_OK )
			{
				*p_data = mtcb->data;
			}
			
			mknl_exe_tex();		/* 㳰μ¹ */
		}
	}
	else
	{
		/* ǡ塼ǡФ */
		*p_data = dtqcb_rom->dtq[dtqcb_ram->head];
		dtqcb_ram->head++;
		if ( dtqcb_ram->head >= dtqcb_rom->dtqcnt )
		{
			dtqcb_ram->head = 0;
		}
		
		/* Ԥʤ鳫 */
		mtcb = mknl_ref_qhd(&dtqcb_ram->sndque);
		if ( mtcb!= NULL )
		{
			UINT tail;

			/* ǡ塼˥ǡǼ */
			tail = dtqcb_ram->head + dtqcb_ram->datacnt - 1;
			if ( tail >= dtqcb_rom->dtqcnt )
			{
				tail -= dtqcb_rom->dtqcnt;
			}
			dtqcb_rom->dtq[tail] = mtcb->data;

			mknl_rmv_que(mtcb);			/* Ԥ󤫤 */
			mknl_rmv_tmout(mtcb);		/* ॢȲ */
			mknl_wup_tsk(mtcb, E_OK);	/* Ԥ */
			
			mknl_exe_dsp();		/* ǥѥåμ¹ */
			mknl_exe_tex();		/* 㳰μ¹ */
		}
		else
		{
			dtqcb_ram->datacnt--;
		}
		
		ercd = E_OK;
	}

	mknl_unl_sys();	/* ƥΥå */

	return ercd;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
