/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ITRONͥ CPU㳰ϥɥ                                     */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_exc.h"



/* CPU㳰ϥɥγ */
void kernel_sta_exc(void)
{
	/* 󥿥(ߥƥȤ˰ܹ) */
	mknl_sta_ind();
}


/* CPU㳰ϥɥνλ */
void kernel_end_exc(void)
{
	/* ˰ܹ */
	mknl_ext_ind();

	/* ٱǥѥå¹ */
	mknl_dly_dsp();
}


/* CPU㳰ϥɥ߽¹ */
void kernel_exe_exc(
		EXCNO excno)		/* CPU㳰ϥɥֹ */
{
	T_KERNEL_EXCCB exccb;
	
	if ( excno < KERNEL_TMIN_EXCNO || excno > KERNEL_TMAX_EXCNO )
	{
		return;
	}
	
	exccb = kernel_exccb_tbl[excno];	/* ˥ԡ */
	
	mknl_unl_sys();		/* ¿ųߵ */
	
	if ( exccb.exchdr != NULL )
	{
		exccb.exchdr();			/* CPU㳰ϥɥ¹ */
	}
	
	mknl_loc_sys();		/* ¿ų߶ػ */
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
