/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ITRONͥ ٥ȥե饰                                          */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_flg.h"



/* ٥ȥե饰 */
ER cre_flg(
		ID           flgid,		/* оݤΥ٥ȥե饰IDֹ */
		const T_CFLG *pk_cflg)	/* ٥ȥե饰줿ѥåȤؤΥݥ */
{
	ER ercd;

	/* ID Υå */
#ifdef HOS_ERCHK_E_ID
	if ( flgid < KERNEL_TMIN_FLGID || flgid > KERNEL_TMAX_FLGID )
	{
		return E_ID;	/* ID */
	}
#endif

	mknl_loc_sys();	/* ƥΥå */

	/* ٥ȥե饰Ͽǽɤå */
#ifdef HOS_ERCHK_E_OBJ
	if ( KERNEL_FLGID_TO_FLGCB_RAM(flgid) != NULL )
	{
		mknl_unl_sys();	/* ƥΥå */
		return E_OBJ;	/* ϿѤ */
	}
#endif

	/* ٥ȥե饰 */
	ercd = kernel_cre_flg(flgid, pk_cflg);
	
	mknl_unl_sys();	/* ƥΥå */

	return ercd;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
